#!/bin/sh

# This is a WebDruid skin shell script
# It is part of The WebDruid software package
# (http://www.webdruid.org)
#
# Copyright 2003-2004 Fabien Chevalier
# <fabien@juliana-multimedia.com>
#
# This file is distributed under the GNU GPL version 2,
# or at our option, any later version.

skin_version="0.5.0"

if [ $# -ne 6 ]; then
   echo "";
   echo "This is a WedDruid internal shell sript.";
   echo "It is to be called only by The WebDruid.";
   echo "";
   exit 1;
fi

# Script arguments
# Keep in mind when reading this that The WebDruid does
# a chdir to its global output directory.

# $1 : Run mode - one of MONTH, SUMMARY
# $2 : Relative path to directory where xml files are stored
# $3 : The xml file name to process
#      Either monthly_yyyy_mm or summary.xml
# $4 : Full path to xml file containing skin settings
# $5 : This skin's relative output directory
#      This script MUST NOT write anywhere else
#      Please note that the directory may not yet exist
# $6 : Absolute path to skins ressource directory
#      Contains all skins specific data (pictures, xslt stylesheets, ...)
#      Ressources specific to this skin are in subdirectory named with
#      the name of the skin

run_mode=$1;
xml_dir=$2;
raw_xml_file=$3;
skin_settings_file=$4;
output_dir=$5;
skins_ressource_dir=$6;

# Trying to create output directory if required, exit if it fails
test -d "$output_dir" || mkdir -p "$output_dir" || exit 1;

# Begin of 'classic' skin specific part

if [ $run_mode = "SUMMARY" ]; then
   # Let's create summary
   echo "Run mode SUMMARY not impemented";
else
   # Let's deal with monthly files;
   xsltproc --nonet \
            --param output_dir \"$output_dir\" \
            --param xml_dir \"$PWD/$xml_dir\" \
            --param skin_settings_file \"$skin_settings_file\" \
            --param skin_version \"$skin_version\" \
            "$skins_ressource_dir/classic/classic.xsl" \
            "$xml_dir/$raw_xml_file" > /dev/null \
   && cp -f "$skins_ressource_dir"/classic/*.png "$output_dir" \
   && cp -f "$skins_ressource_dir"/classic/classic.css "$output_dir";

   exit $?;
fi
