// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Adjustment, Align, Buildable, CellEditable, Container, DeleteType, Editable, EntryBuffer,
    EntryCompletion, EntryIconPosition, ImageType, InputHints, InputPurpose, MovementStep,
    TargetList, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkEntry")]
    pub struct Entry(Object<ffi::GtkEntry, ffi::GtkEntryClass>) @extends Widget, @implements Buildable, CellEditable, Editable;

    match fn {
        type_ => || ffi::gtk_entry_get_type(),
    }
}

impl Entry {
    pub const NONE: Option<&'static Entry> = None;

    #[doc(alias = "gtk_entry_new")]
    pub fn new() -> Entry {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_entry_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_entry_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<EntryBuffer>) -> Entry {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_entry_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Entry`] objects.
    ///
    /// This method returns an instance of [`EntryBuilder`](crate::builders::EntryBuilder) which can be used to create [`Entry`] objects.
    pub fn builder() -> EntryBuilder {
        EntryBuilder::new()
    }
}

impl Default for Entry {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Entry`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct EntryBuilder {
    builder: glib::object::ObjectBuilder<'static, Entry>,
}

impl EntryBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn activates_default(self, activates_default: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activates-default", activates_default),
        }
    }

    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<EntryBuffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn caps_lock_warning(self, caps_lock_warning: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("caps-lock-warning", caps_lock_warning),
        }
    }

    pub fn completion(self, completion: &impl IsA<EntryCompletion>) -> Self {
        Self {
            builder: self
                .builder
                .property("completion", completion.clone().upcast()),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn enable_emoji_completion(self, enable_emoji_completion: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-emoji-completion", enable_emoji_completion),
        }
    }

    pub fn has_frame(self, has_frame: bool) -> Self {
        Self {
            builder: self.builder.property("has-frame", has_frame),
        }
    }

    pub fn im_module(self, im_module: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("im-module", im_module.into()),
        }
    }

    pub fn input_hints(self, input_hints: InputHints) -> Self {
        Self {
            builder: self.builder.property("input-hints", input_hints),
        }
    }

    pub fn input_purpose(self, input_purpose: InputPurpose) -> Self {
        Self {
            builder: self.builder.property("input-purpose", input_purpose),
        }
    }

    pub fn invisible_char(self, invisible_char: u32) -> Self {
        Self {
            builder: self.builder.property("invisible-char", invisible_char),
        }
    }

    pub fn invisible_char_set(self, invisible_char_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("invisible-char-set", invisible_char_set),
        }
    }

    pub fn max_length(self, max_length: i32) -> Self {
        Self {
            builder: self.builder.property("max-length", max_length),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn overwrite_mode(self, overwrite_mode: bool) -> Self {
        Self {
            builder: self.builder.property("overwrite-mode", overwrite_mode),
        }
    }

    pub fn placeholder_text(self, placeholder_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("placeholder-text", placeholder_text.into()),
        }
    }

    pub fn populate_all(self, populate_all: bool) -> Self {
        Self {
            builder: self.builder.property("populate-all", populate_all),
        }
    }

    pub fn primary_icon_activatable(self, primary_icon_activatable: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-activatable", primary_icon_activatable),
        }
    }

    pub fn primary_icon_gicon(self, primary_icon_gicon: &impl IsA<gio::Icon>) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-gicon", primary_icon_gicon.clone().upcast()),
        }
    }

    pub fn primary_icon_name(self, primary_icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-name", primary_icon_name.into()),
        }
    }

    pub fn primary_icon_pixbuf(self, primary_icon_pixbuf: &gdk_pixbuf::Pixbuf) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-pixbuf", primary_icon_pixbuf.clone()),
        }
    }

    pub fn primary_icon_sensitive(self, primary_icon_sensitive: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("primary-icon-sensitive", primary_icon_sensitive),
        }
    }

    pub fn primary_icon_tooltip_markup(
        self,
        primary_icon_tooltip_markup: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "primary-icon-tooltip-markup",
                primary_icon_tooltip_markup.into(),
            ),
        }
    }

    pub fn primary_icon_tooltip_text(
        self,
        primary_icon_tooltip_text: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "primary-icon-tooltip-text",
                primary_icon_tooltip_text.into(),
            ),
        }
    }

    pub fn progress_fraction(self, progress_fraction: f64) -> Self {
        Self {
            builder: self
                .builder
                .property("progress-fraction", progress_fraction),
        }
    }

    pub fn progress_pulse_step(self, progress_pulse_step: f64) -> Self {
        Self {
            builder: self
                .builder
                .property("progress-pulse-step", progress_pulse_step),
        }
    }

    pub fn secondary_icon_activatable(self, secondary_icon_activatable: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("secondary-icon-activatable", secondary_icon_activatable),
        }
    }

    pub fn secondary_icon_gicon(self, secondary_icon_gicon: &impl IsA<gio::Icon>) -> Self {
        Self {
            builder: self.builder.property(
                "secondary-icon-gicon",
                secondary_icon_gicon.clone().upcast(),
            ),
        }
    }

    pub fn secondary_icon_name(self, secondary_icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("secondary-icon-name", secondary_icon_name.into()),
        }
    }

    pub fn secondary_icon_pixbuf(self, secondary_icon_pixbuf: &gdk_pixbuf::Pixbuf) -> Self {
        Self {
            builder: self
                .builder
                .property("secondary-icon-pixbuf", secondary_icon_pixbuf.clone()),
        }
    }

    pub fn secondary_icon_sensitive(self, secondary_icon_sensitive: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("secondary-icon-sensitive", secondary_icon_sensitive),
        }
    }

    pub fn secondary_icon_tooltip_markup(
        self,
        secondary_icon_tooltip_markup: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "secondary-icon-tooltip-markup",
                secondary_icon_tooltip_markup.into(),
            ),
        }
    }

    pub fn secondary_icon_tooltip_text(
        self,
        secondary_icon_tooltip_text: impl Into<glib::GString>,
    ) -> Self {
        Self {
            builder: self.builder.property(
                "secondary-icon-tooltip-text",
                secondary_icon_tooltip_text.into(),
            ),
        }
    }

    pub fn show_emoji_icon(self, show_emoji_icon: bool) -> Self {
        Self {
            builder: self.builder.property("show-emoji-icon", show_emoji_icon),
        }
    }

    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    pub fn truncate_multiline(self, truncate_multiline: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("truncate-multiline", truncate_multiline),
        }
    }

    pub fn visibility(self, visibility: bool) -> Self {
        Self {
            builder: self.builder.property("visibility", visibility),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn editing_canceled(self, editing_canceled: bool) -> Self {
        Self {
            builder: self.builder.property("editing-canceled", editing_canceled),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Entry`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Entry {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Entry>> Sealed for T {}
}

pub trait EntryExt: IsA<Entry> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_entry_get_activates_default")]
    #[doc(alias = "get_activates_default")]
    fn activates_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_activates_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_alignment")]
    #[doc(alias = "get_alignment")]
    fn alignment(&self) -> f32 {
        unsafe { ffi::gtk_entry_get_alignment(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_attributes")]
    #[doc(alias = "get_attributes")]
    fn attributes(&self) -> Option<pango::AttrList> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_attributes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> EntryBuffer {
        unsafe { from_glib_none(ffi::gtk_entry_get_buffer(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_entry_get_completion")]
    #[doc(alias = "get_completion")]
    fn completion(&self) -> Option<EntryCompletion> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_current_icon_drag_source")]
    #[doc(alias = "get_current_icon_drag_source")]
    fn current_icon_drag_source(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_current_icon_drag_source(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_cursor_hadjustment")]
    #[doc(alias = "get_cursor_hadjustment")]
    fn cursor_hadjustment(&self) -> Option<Adjustment> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_cursor_hadjustment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_has_frame")]
    #[doc(alias = "get_has_frame")]
    fn has_frame(&self) -> bool {
        unsafe { from_glib(ffi::gtk_entry_get_has_frame(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_entry_get_icon_activatable")]
    #[doc(alias = "get_icon_activatable")]
    fn icon_is_activatable(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_area")]
    #[doc(alias = "get_icon_area")]
    fn icon_area(&self, icon_pos: EntryIconPosition) -> gdk::Rectangle {
        unsafe {
            let mut icon_area = gdk::Rectangle::uninitialized();
            ffi::gtk_entry_get_icon_area(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon_area.to_glib_none_mut().0,
            );
            icon_area
        }
    }

    #[doc(alias = "gtk_entry_get_icon_at_pos")]
    #[doc(alias = "get_icon_at_pos")]
    fn icon_at_pos(&self, x: i32, y: i32) -> i32 {
        unsafe { ffi::gtk_entry_get_icon_at_pos(self.as_ref().to_glib_none().0, x, y) }
    }

    #[doc(alias = "gtk_entry_get_icon_gicon")]
    #[doc(alias = "get_icon_gicon")]
    fn icon_gicon(&self, icon_pos: EntryIconPosition) -> Option<gio::Icon> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    fn icon_name(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_pixbuf")]
    #[doc(alias = "get_icon_pixbuf")]
    fn icon_pixbuf(&self, icon_pos: EntryIconPosition) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_icon_pixbuf(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_sensitive")]
    #[doc(alias = "get_icon_sensitive")]
    fn icon_is_sensitive(&self, icon_pos: EntryIconPosition) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_storage_type")]
    #[doc(alias = "get_icon_storage_type")]
    fn icon_storage_type(&self, icon_pos: EntryIconPosition) -> ImageType {
        unsafe {
            from_glib(ffi::gtk_entry_get_icon_storage_type(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_tooltip_markup")]
    #[doc(alias = "get_icon_tooltip_markup")]
    fn icon_tooltip_markup(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_entry_get_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_icon_tooltip_text")]
    #[doc(alias = "get_icon_tooltip_text")]
    fn icon_tooltip_text(&self, icon_pos: EntryIconPosition) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_entry_get_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_input_hints")]
    #[doc(alias = "get_input_hints")]
    fn input_hints(&self) -> InputHints {
        unsafe {
            from_glib(ffi::gtk_entry_get_input_hints(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_input_purpose")]
    #[doc(alias = "get_input_purpose")]
    fn input_purpose(&self) -> InputPurpose {
        unsafe {
            from_glib(ffi::gtk_entry_get_input_purpose(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_layout")]
    #[doc(alias = "get_layout")]
    fn layout(&self) -> Option<pango::Layout> {
        unsafe { from_glib_none(ffi::gtk_entry_get_layout(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_entry_get_layout_offsets")]
    #[doc(alias = "get_layout_offsets")]
    fn layout_offsets(&self) -> (i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            ffi::gtk_entry_get_layout_offsets(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (x.assume_init(), y.assume_init())
        }
    }

    #[doc(alias = "gtk_entry_get_max_length")]
    #[doc(alias = "get_max_length")]
    fn max_length(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_max_length(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_max_width_chars")]
    #[doc(alias = "get_max_width_chars")]
    fn max_width_chars(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_max_width_chars(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_overwrite_mode")]
    #[doc(alias = "get_overwrite_mode")]
    fn is_overwrite_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_overwrite_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_placeholder_text")]
    #[doc(alias = "get_placeholder_text")]
    fn placeholder_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_get_placeholder_text(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_progress_fraction")]
    #[doc(alias = "get_progress_fraction")]
    fn progress_fraction(&self) -> f64 {
        unsafe { ffi::gtk_entry_get_progress_fraction(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_progress_pulse_step")]
    #[doc(alias = "get_progress_pulse_step")]
    fn progress_pulse_step(&self) -> f64 {
        unsafe { ffi::gtk_entry_get_progress_pulse_step(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_tabs")]
    #[doc(alias = "get_tabs")]
    fn tabs(&self) -> Option<pango::TabArray> {
        unsafe { from_glib_none(ffi::gtk_entry_get_tabs(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_entry_get_text")]
    #[doc(alias = "get_text")]
    fn text(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_entry_get_text(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_entry_get_text_area")]
    #[doc(alias = "get_text_area")]
    fn text_area(&self) -> gdk::Rectangle {
        unsafe {
            let mut text_area = gdk::Rectangle::uninitialized();
            ffi::gtk_entry_get_text_area(
                self.as_ref().to_glib_none().0,
                text_area.to_glib_none_mut().0,
            );
            text_area
        }
    }

    #[doc(alias = "gtk_entry_get_text_length")]
    #[doc(alias = "get_text_length")]
    fn text_length(&self) -> u16 {
        unsafe { ffi::gtk_entry_get_text_length(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_get_visibility")]
    #[doc(alias = "get_visibility")]
    fn is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_get_visibility(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_entry_get_width_chars")]
    #[doc(alias = "get_width_chars")]
    fn width_chars(&self) -> i32 {
        unsafe { ffi::gtk_entry_get_width_chars(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_entry_grab_focus_without_selecting")]
    fn grab_focus_without_selecting(&self) {
        unsafe {
            ffi::gtk_entry_grab_focus_without_selecting(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_im_context_filter_keypress")]
    fn im_context_filter_keypress(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_im_context_filter_keypress(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_entry_layout_index_to_text_index")]
    fn layout_index_to_text_index(&self, layout_index: i32) -> i32 {
        unsafe {
            ffi::gtk_entry_layout_index_to_text_index(self.as_ref().to_glib_none().0, layout_index)
        }
    }

    #[doc(alias = "gtk_entry_progress_pulse")]
    fn progress_pulse(&self) {
        unsafe {
            ffi::gtk_entry_progress_pulse(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_reset_im_context")]
    fn reset_im_context(&self) {
        unsafe {
            ffi::gtk_entry_reset_im_context(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_set_activates_default")]
    fn set_activates_default(&self, setting: bool) {
        unsafe {
            ffi::gtk_entry_set_activates_default(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_alignment")]
    fn set_alignment(&self, xalign: f32) {
        unsafe {
            ffi::gtk_entry_set_alignment(self.as_ref().to_glib_none().0, xalign);
        }
    }

    #[doc(alias = "gtk_entry_set_attributes")]
    fn set_attributes(&self, attrs: &pango::AttrList) {
        unsafe {
            ffi::gtk_entry_set_attributes(self.as_ref().to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_set_buffer")]
    fn set_buffer(&self, buffer: &impl IsA<EntryBuffer>) {
        unsafe {
            ffi::gtk_entry_set_buffer(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_completion")]
    fn set_completion(&self, completion: Option<&impl IsA<EntryCompletion>>) {
        unsafe {
            ffi::gtk_entry_set_completion(
                self.as_ref().to_glib_none().0,
                completion.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_cursor_hadjustment")]
    fn set_cursor_hadjustment(&self, adjustment: Option<&impl IsA<Adjustment>>) {
        unsafe {
            ffi::gtk_entry_set_cursor_hadjustment(
                self.as_ref().to_glib_none().0,
                adjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_has_frame")]
    fn set_has_frame(&self, setting: bool) {
        unsafe {
            ffi::gtk_entry_set_has_frame(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_icon_activatable")]
    fn set_icon_activatable(&self, icon_pos: EntryIconPosition, activatable: bool) {
        unsafe {
            ffi::gtk_entry_set_icon_activatable(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                activatable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_drag_source")]
    fn set_icon_drag_source(
        &self,
        icon_pos: EntryIconPosition,
        target_list: &TargetList,
        actions: gdk::DragAction,
    ) {
        unsafe {
            ffi::gtk_entry_set_icon_drag_source(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                target_list.to_glib_none().0,
                actions.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_from_gicon")]
    fn set_icon_from_gicon(&self, icon_pos: EntryIconPosition, icon: Option<&impl IsA<gio::Icon>>) {
        unsafe {
            ffi::gtk_entry_set_icon_from_gicon(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_from_icon_name")]
    fn set_icon_from_icon_name(&self, icon_pos: EntryIconPosition, icon_name: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_from_icon_name(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                icon_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_from_pixbuf")]
    fn set_icon_from_pixbuf(
        &self,
        icon_pos: EntryIconPosition,
        pixbuf: Option<&gdk_pixbuf::Pixbuf>,
    ) {
        unsafe {
            ffi::gtk_entry_set_icon_from_pixbuf(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                pixbuf.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_sensitive")]
    fn set_icon_sensitive(&self, icon_pos: EntryIconPosition, sensitive: bool) {
        unsafe {
            ffi::gtk_entry_set_icon_sensitive(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                sensitive.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_tooltip_markup")]
    fn set_icon_tooltip_markup(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_tooltip_markup(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_icon_tooltip_text")]
    fn set_icon_tooltip_text(&self, icon_pos: EntryIconPosition, tooltip: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_icon_tooltip_text(
                self.as_ref().to_glib_none().0,
                icon_pos.into_glib(),
                tooltip.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_input_hints")]
    fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            ffi::gtk_entry_set_input_hints(self.as_ref().to_glib_none().0, hints.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_input_purpose")]
    fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            ffi::gtk_entry_set_input_purpose(self.as_ref().to_glib_none().0, purpose.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_invisible_char")]
    fn set_invisible_char(&self, ch: Option<char>) {
        unsafe {
            ffi::gtk_entry_set_invisible_char(self.as_ref().to_glib_none().0, ch.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_max_length")]
    fn set_max_length(&self, max: i32) {
        unsafe {
            ffi::gtk_entry_set_max_length(self.as_ref().to_glib_none().0, max);
        }
    }

    #[doc(alias = "gtk_entry_set_max_width_chars")]
    fn set_max_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_entry_set_max_width_chars(self.as_ref().to_glib_none().0, n_chars);
        }
    }

    #[doc(alias = "gtk_entry_set_overwrite_mode")]
    fn set_overwrite_mode(&self, overwrite: bool) {
        unsafe {
            ffi::gtk_entry_set_overwrite_mode(
                self.as_ref().to_glib_none().0,
                overwrite.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_placeholder_text")]
    fn set_placeholder_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_entry_set_placeholder_text(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_entry_set_progress_fraction")]
    fn set_progress_fraction(&self, fraction: f64) {
        unsafe {
            ffi::gtk_entry_set_progress_fraction(self.as_ref().to_glib_none().0, fraction);
        }
    }

    #[doc(alias = "gtk_entry_set_progress_pulse_step")]
    fn set_progress_pulse_step(&self, fraction: f64) {
        unsafe {
            ffi::gtk_entry_set_progress_pulse_step(self.as_ref().to_glib_none().0, fraction);
        }
    }

    #[doc(alias = "gtk_entry_set_tabs")]
    fn set_tabs(&self, tabs: &pango::TabArray) {
        unsafe {
            ffi::gtk_entry_set_tabs(
                self.as_ref().to_glib_none().0,
                mut_override(tabs.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_entry_set_text")]
    fn set_text(&self, text: &str) {
        unsafe {
            ffi::gtk_entry_set_text(self.as_ref().to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_entry_set_visibility")]
    fn set_visibility(&self, visible: bool) {
        unsafe {
            ffi::gtk_entry_set_visibility(self.as_ref().to_glib_none().0, visible.into_glib());
        }
    }

    #[doc(alias = "gtk_entry_set_width_chars")]
    fn set_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_entry_set_width_chars(self.as_ref().to_glib_none().0, n_chars);
        }
    }

    #[doc(alias = "gtk_entry_text_index_to_layout_index")]
    fn text_index_to_layout_index(&self, text_index: i32) -> i32 {
        unsafe {
            ffi::gtk_entry_text_index_to_layout_index(self.as_ref().to_glib_none().0, text_index)
        }
    }

    #[doc(alias = "gtk_entry_unset_invisible_char")]
    fn unset_invisible_char(&self) {
        unsafe {
            ffi::gtk_entry_unset_invisible_char(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "caps-lock-warning")]
    fn is_caps_lock_warning(&self) -> bool {
        ObjectExt::property(self.as_ref(), "caps-lock-warning")
    }

    #[doc(alias = "caps-lock-warning")]
    fn set_caps_lock_warning(&self, caps_lock_warning: bool) {
        ObjectExt::set_property(self.as_ref(), "caps-lock-warning", caps_lock_warning)
    }

    #[doc(alias = "cursor-position")]
    fn cursor_position(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "cursor-position")
    }

    #[doc(alias = "enable-emoji-completion")]
    fn enables_emoji_completion(&self) -> bool {
        ObjectExt::property(self.as_ref(), "enable-emoji-completion")
    }

    #[doc(alias = "enable-emoji-completion")]
    fn set_enable_emoji_completion(&self, enable_emoji_completion: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "enable-emoji-completion",
            enable_emoji_completion,
        )
    }

    #[doc(alias = "im-module")]
    fn im_module(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "im-module")
    }

    #[doc(alias = "im-module")]
    fn set_im_module(&self, im_module: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "im-module", im_module)
    }

    #[doc(alias = "invisible-char-set")]
    fn is_invisible_char_set(&self) -> bool {
        ObjectExt::property(self.as_ref(), "invisible-char-set")
    }

    #[doc(alias = "invisible-char-set")]
    fn set_invisible_char_set(&self, invisible_char_set: bool) {
        ObjectExt::set_property(self.as_ref(), "invisible-char-set", invisible_char_set)
    }

    #[doc(alias = "populate-all")]
    fn populates_all(&self) -> bool {
        ObjectExt::property(self.as_ref(), "populate-all")
    }

    #[doc(alias = "populate-all")]
    fn set_populate_all(&self, populate_all: bool) {
        ObjectExt::set_property(self.as_ref(), "populate-all", populate_all)
    }

    #[doc(alias = "primary-icon-activatable")]
    fn is_primary_icon_activatable(&self) -> bool {
        ObjectExt::property(self.as_ref(), "primary-icon-activatable")
    }

    #[doc(alias = "primary-icon-activatable")]
    fn set_primary_icon_activatable(&self, primary_icon_activatable: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-activatable",
            primary_icon_activatable,
        )
    }

    #[doc(alias = "primary-icon-gicon")]
    fn primary_icon_gicon(&self) -> Option<gio::Icon> {
        ObjectExt::property(self.as_ref(), "primary-icon-gicon")
    }

    #[doc(alias = "primary-icon-gicon")]
    fn set_primary_icon_gicon<P: IsA<gio::Icon>>(&self, primary_icon_gicon: Option<&P>) {
        ObjectExt::set_property(self.as_ref(), "primary-icon-gicon", primary_icon_gicon)
    }

    #[doc(alias = "primary-icon-name")]
    fn primary_icon_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "primary-icon-name")
    }

    #[doc(alias = "primary-icon-name")]
    fn set_primary_icon_name(&self, primary_icon_name: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "primary-icon-name", primary_icon_name)
    }

    #[doc(alias = "primary-icon-pixbuf")]
    fn primary_icon_pixbuf(&self) -> Option<gdk_pixbuf::Pixbuf> {
        ObjectExt::property(self.as_ref(), "primary-icon-pixbuf")
    }

    #[doc(alias = "primary-icon-pixbuf")]
    fn set_primary_icon_pixbuf(&self, primary_icon_pixbuf: Option<&gdk_pixbuf::Pixbuf>) {
        ObjectExt::set_property(self.as_ref(), "primary-icon-pixbuf", primary_icon_pixbuf)
    }

    #[doc(alias = "primary-icon-sensitive")]
    fn is_primary_icon_sensitive(&self) -> bool {
        ObjectExt::property(self.as_ref(), "primary-icon-sensitive")
    }

    #[doc(alias = "primary-icon-sensitive")]
    fn set_primary_icon_sensitive(&self, primary_icon_sensitive: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-sensitive",
            primary_icon_sensitive,
        )
    }

    #[doc(alias = "primary-icon-storage-type")]
    fn primary_icon_storage_type(&self) -> ImageType {
        ObjectExt::property(self.as_ref(), "primary-icon-storage-type")
    }

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn primary_icon_tooltip_markup(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "primary-icon-tooltip-markup")
    }

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn set_primary_icon_tooltip_markup(&self, primary_icon_tooltip_markup: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-tooltip-markup",
            primary_icon_tooltip_markup,
        )
    }

    #[doc(alias = "primary-icon-tooltip-text")]
    fn primary_icon_tooltip_text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "primary-icon-tooltip-text")
    }

    #[doc(alias = "primary-icon-tooltip-text")]
    fn set_primary_icon_tooltip_text(&self, primary_icon_tooltip_text: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "primary-icon-tooltip-text",
            primary_icon_tooltip_text,
        )
    }

    #[doc(alias = "scroll-offset")]
    fn scroll_offset(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "scroll-offset")
    }

    #[doc(alias = "secondary-icon-activatable")]
    fn is_secondary_icon_activatable(&self) -> bool {
        ObjectExt::property(self.as_ref(), "secondary-icon-activatable")
    }

    #[doc(alias = "secondary-icon-activatable")]
    fn set_secondary_icon_activatable(&self, secondary_icon_activatable: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-activatable",
            secondary_icon_activatable,
        )
    }

    #[doc(alias = "secondary-icon-gicon")]
    fn secondary_icon_gicon(&self) -> Option<gio::Icon> {
        ObjectExt::property(self.as_ref(), "secondary-icon-gicon")
    }

    #[doc(alias = "secondary-icon-gicon")]
    fn set_secondary_icon_gicon<P: IsA<gio::Icon>>(&self, secondary_icon_gicon: Option<&P>) {
        ObjectExt::set_property(self.as_ref(), "secondary-icon-gicon", secondary_icon_gicon)
    }

    #[doc(alias = "secondary-icon-name")]
    fn secondary_icon_name(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "secondary-icon-name")
    }

    #[doc(alias = "secondary-icon-name")]
    fn set_secondary_icon_name(&self, secondary_icon_name: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "secondary-icon-name", secondary_icon_name)
    }

    #[doc(alias = "secondary-icon-pixbuf")]
    fn secondary_icon_pixbuf(&self) -> Option<gdk_pixbuf::Pixbuf> {
        ObjectExt::property(self.as_ref(), "secondary-icon-pixbuf")
    }

    #[doc(alias = "secondary-icon-pixbuf")]
    fn set_secondary_icon_pixbuf(&self, secondary_icon_pixbuf: Option<&gdk_pixbuf::Pixbuf>) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-pixbuf",
            secondary_icon_pixbuf,
        )
    }

    #[doc(alias = "secondary-icon-sensitive")]
    fn is_secondary_icon_sensitive(&self) -> bool {
        ObjectExt::property(self.as_ref(), "secondary-icon-sensitive")
    }

    #[doc(alias = "secondary-icon-sensitive")]
    fn set_secondary_icon_sensitive(&self, secondary_icon_sensitive: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-sensitive",
            secondary_icon_sensitive,
        )
    }

    #[doc(alias = "secondary-icon-storage-type")]
    fn secondary_icon_storage_type(&self) -> ImageType {
        ObjectExt::property(self.as_ref(), "secondary-icon-storage-type")
    }

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn secondary_icon_tooltip_markup(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "secondary-icon-tooltip-markup")
    }

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn set_secondary_icon_tooltip_markup(&self, secondary_icon_tooltip_markup: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-tooltip-markup",
            secondary_icon_tooltip_markup,
        )
    }

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn secondary_icon_tooltip_text(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "secondary-icon-tooltip-text")
    }

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn set_secondary_icon_tooltip_text(&self, secondary_icon_tooltip_text: Option<&str>) {
        ObjectExt::set_property(
            self.as_ref(),
            "secondary-icon-tooltip-text",
            secondary_icon_tooltip_text,
        )
    }

    #[doc(alias = "selection-bound")]
    fn selection_bound(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "selection-bound")
    }

    #[doc(alias = "show-emoji-icon")]
    fn shows_emoji_icon(&self) -> bool {
        ObjectExt::property(self.as_ref(), "show-emoji-icon")
    }

    #[doc(alias = "show-emoji-icon")]
    fn set_show_emoji_icon(&self, show_emoji_icon: bool) {
        ObjectExt::set_property(self.as_ref(), "show-emoji-icon", show_emoji_icon)
    }

    #[doc(alias = "truncate-multiline")]
    fn must_truncate_multiline(&self) -> bool {
        ObjectExt::property(self.as_ref(), "truncate-multiline")
    }

    #[doc(alias = "truncate-multiline")]
    fn set_truncate_multiline(&self, truncate_multiline: bool) {
        ObjectExt::set_property(self.as_ref(), "truncate-multiline", truncate_multiline)
    }

    fn xalign(&self) -> f32 {
        ObjectExt::property(self.as_ref(), "xalign")
    }

    fn set_xalign(&self, xalign: f32) {
        ObjectExt::set_property(self.as_ref(), "xalign", xalign)
    }

    #[doc(alias = "activate")]
    fn connect_activate<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate(&self) {
        self.emit_by_name::<()>("activate", &[]);
    }

    #[doc(alias = "backspace")]
    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn backspace_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"backspace\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    backspace_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_backspace(&self) {
        self.emit_by_name::<()>("backspace", &[]);
    }

    #[doc(alias = "copy-clipboard")]
    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    copy_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_copy_clipboard(&self) {
        self.emit_by_name::<()>("copy-clipboard", &[]);
    }

    #[doc(alias = "cut-clipboard")]
    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cut_clipboard_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cut-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cut_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_cut_clipboard(&self) {
        self.emit_by_name::<()>("cut-clipboard", &[]);
    }

    #[doc(alias = "delete-from-cursor")]
    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn delete_from_cursor_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, DeleteType, i32) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            type_: ffi::GtkDeleteType,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(type_),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"delete-from-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    delete_from_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32) {
        self.emit_by_name::<()>("delete-from-cursor", &[&type_, &count]);
    }

    #[doc(alias = "icon-press")]
    fn connect_icon_press<F: Fn(&Self, EntryIconPosition, &gdk::Event) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_press_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, EntryIconPosition, &gdk::Event) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            icon_pos: ffi::GtkEntryIconPosition,
            event: *mut gdk::ffi::GdkEvent,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(icon_pos),
                &from_glib_none(event),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"icon-press\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    icon_press_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "icon-release")]
    fn connect_icon_release<F: Fn(&Self, EntryIconPosition, &gdk::Event) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn icon_release_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, EntryIconPosition, &gdk::Event) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            icon_pos: ffi::GtkEntryIconPosition,
            event: *mut gdk::ffi::GdkEvent,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(icon_pos),
                &from_glib_none(event),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"icon-release\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    icon_release_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "insert-at-cursor")]
    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_at_cursor_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, &str) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            string: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(string),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-at-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_at_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_at_cursor(&self, string: &str) {
        self.emit_by_name::<()>("insert-at-cursor", &[&string]);
    }

    #[doc(alias = "insert-emoji")]
    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_emoji_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-emoji\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_emoji_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_emoji(&self) {
        self.emit_by_name::<()>("insert-emoji", &[]);
    }

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, MovementStep, i32, bool) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            step: ffi::GtkMovementStep,
            count: libc::c_int,
            extend_selection: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                count,
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        self.emit_by_name::<()>("move-cursor", &[&step, &count, &extend_selection]);
    }

    #[doc(alias = "paste-clipboard")]
    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_clipboard_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    paste_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_paste_clipboard(&self) {
        self.emit_by_name::<()>("paste-clipboard", &[]);
    }

    #[doc(alias = "populate-popup")]
    fn connect_populate_popup<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn populate_popup_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, &Widget) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            widget: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(widget),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"populate-popup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    populate_popup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "preedit-changed")]
    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn preedit_changed_trampoline<
            P: IsA<Entry>,
            F: Fn(&P, &str) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            preedit: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Entry::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(preedit),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"preedit-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    preedit_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_preedit_changed(&self, preedit: &str) {
        self.emit_by_name::<()>("preedit-changed", &[&preedit]);
    }

    #[doc(alias = "toggle-overwrite")]
    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_overwrite_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-overwrite\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_overwrite_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_overwrite(&self) {
        self.emit_by_name::<()>("toggle-overwrite", &[]);
    }

    #[doc(alias = "activates-default")]
    fn connect_activates_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_activates_default_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activates-default\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activates_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "buffer")]
    fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "caps-lock-warning")]
    fn connect_caps_lock_warning_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_caps_lock_warning_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::caps-lock-warning\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_caps_lock_warning_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "completion")]
    fn connect_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_completion_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cursor-position")]
    fn connect_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_position_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_position_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "editable")]
    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-emoji-completion")]
    fn connect_enable_emoji_completion_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_emoji_completion_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-emoji-completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_emoji_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-frame")]
    fn connect_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_frame_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-frame\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_frame_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "im-module")]
    fn connect_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::im-module\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_im_module_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-hints")]
    fn connect_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-hints\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_hints_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "input-purpose")]
    fn connect_input_purpose_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-purpose\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_purpose_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char")]
    fn connect_invisible_char_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_char_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "invisible-char-set")]
    fn connect_invisible_char_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_char_set_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-char-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_char_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-length")]
    fn connect_max_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_length_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_length_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-width-chars")]
    fn connect_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_chars_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "overwrite-mode")]
    fn connect_overwrite_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_mode_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overwrite-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overwrite_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "placeholder-text")]
    fn connect_placeholder_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_placeholder_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::placeholder-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_placeholder_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "populate-all")]
    fn connect_populate_all_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_populate_all_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::populate-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_populate_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-activatable")]
    fn connect_primary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_activatable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-activatable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_activatable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-gicon")]
    fn connect_primary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_gicon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-gicon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_gicon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-name")]
    fn connect_primary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_name_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-pixbuf")]
    fn connect_primary_icon_pixbuf_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_pixbuf_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-pixbuf\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_pixbuf_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-sensitive")]
    fn connect_primary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_sensitive_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-sensitive\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-storage-type")]
    fn connect_primary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_storage_type_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-storage-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_storage_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-tooltip-markup")]
    fn connect_primary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_markup_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-tooltip-markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "primary-icon-tooltip-text")]
    fn connect_primary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_primary_icon_tooltip_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::primary-icon-tooltip-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_primary_icon_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "progress-fraction")]
    fn connect_progress_fraction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_fraction_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::progress-fraction\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_progress_fraction_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "progress-pulse-step")]
    fn connect_progress_pulse_step_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_progress_pulse_step_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::progress-pulse-step\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_progress_pulse_step_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scroll-offset")]
    fn connect_scroll_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_offset_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scroll-offset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scroll_offset_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-activatable")]
    fn connect_secondary_icon_activatable_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_activatable_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-activatable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_activatable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-gicon")]
    fn connect_secondary_icon_gicon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_gicon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-gicon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_gicon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-name")]
    fn connect_secondary_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_name_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-pixbuf")]
    fn connect_secondary_icon_pixbuf_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_pixbuf_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-pixbuf\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_pixbuf_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-sensitive")]
    fn connect_secondary_icon_sensitive_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_sensitive_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-sensitive\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-storage-type")]
    fn connect_secondary_icon_storage_type_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_storage_type_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-storage-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_storage_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-tooltip-markup")]
    fn connect_secondary_icon_tooltip_markup_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_markup_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-tooltip-markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "secondary-icon-tooltip-text")]
    fn connect_secondary_icon_tooltip_text_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_secondary_icon_tooltip_text_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::secondary-icon-tooltip-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_secondary_icon_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selection-bound")]
    fn connect_selection_bound_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_bound_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selection-bound\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_selection_bound_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-emoji-icon")]
    fn connect_show_emoji_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_emoji_icon_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-emoji-icon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_emoji_icon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tabs")]
    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text")]
    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text-length")]
    fn connect_text_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_length_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_length_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "truncate-multiline")]
    fn connect_truncate_multiline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_truncate_multiline_trampoline<
            P: IsA<Entry>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::truncate-multiline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_truncate_multiline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visibility")]
    fn connect_visibility_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visibility_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visibility\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visibility_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "width-chars")]
    fn connect_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_chars_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "xalign")]
    fn connect_xalign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xalign_trampoline<P: IsA<Entry>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntry,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Entry::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::xalign\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_xalign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Entry>> EntryExt for O {}

impl fmt::Display for Entry {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Entry")
    }
}
