/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_k_gds08_worker.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t9, t11, t16;
  double tzk0;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t9 = log(t7 * rho[0]);
  t11 = t9 * t9;
  t16 = my_piecewise3(t2, 0, t7 * (params->C * t11 + params->B * t9 + params->A) / 0.2e1);
  tzk0 = 0.2e1 * t16;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t9, t11, t16;
  double tzk0;

  double t17, t19, t25, tvrho0;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t9 = log(t7 * rho[0]);
  t11 = t9 * t9;
  t16 = my_piecewise3(t2, 0, t7 * (params->C * t11 + params->B * t9 + params->A) / 0.2e1);
  tzk0 = 0.2e1 * t16;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t17 = 0.1e1 / rho[0];
  t19 = params->C * t9;
  t25 = my_piecewise3(t2, 0, t7 * (0.2e1 * t19 * t17 + params->B * t17) / 0.2e1);
  tvrho0 = 0.2e1 * rho[0] * t25 + 0.2e1 * t16;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t9, t11, t16;
  double tzk0;

  double t17, t19, t25, tvrho0;

  double t29, t30, t39, tv2rho20;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t9 = log(t7 * rho[0]);
  t11 = t9 * t9;
  t16 = my_piecewise3(t2, 0, t7 * (params->C * t11 + params->B * t9 + params->A) / 0.2e1);
  tzk0 = 0.2e1 * t16;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t17 = 0.1e1 / rho[0];
  t19 = params->C * t9;
  t25 = my_piecewise3(t2, 0, t7 * (0.2e1 * t19 * t17 + params->B * t17) / 0.2e1);
  tvrho0 = 0.2e1 * rho[0] * t25 + 0.2e1 * t16;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t29 = rho[0] * rho[0];
  t30 = 0.1e1 / t29;
  t39 = my_piecewise3(t2, 0, t7 * (-0.2e1 * t19 * t30 - params->B * t30 + 0.2e1 * params->C * t30) / 0.2e1);
  tv2rho20 = 0.2e1 * rho[0] * t39 + 0.4e1 * t25;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t9, t11, t16;
  double tzk0;

  double t17, t19, t25, tvrho0;

  double t29, t30, t39, tv2rho20;

  double t44, t54, tv3rho30;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t9 = log(t7 * rho[0]);
  t11 = t9 * t9;
  t16 = my_piecewise3(t2, 0, t7 * (params->C * t11 + params->B * t9 + params->A) / 0.2e1);
  tzk0 = 0.2e1 * t16;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t17 = 0.1e1 / rho[0];
  t19 = params->C * t9;
  t25 = my_piecewise3(t2, 0, t7 * (0.2e1 * t19 * t17 + params->B * t17) / 0.2e1);
  tvrho0 = 0.2e1 * rho[0] * t25 + 0.2e1 * t16;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t29 = rho[0] * rho[0];
  t30 = 0.1e1 / t29;
  t39 = my_piecewise3(t2, 0, t7 * (-0.2e1 * t19 * t30 - params->B * t30 + 0.2e1 * params->C * t30) / 0.2e1);
  tv2rho20 = 0.2e1 * rho[0] * t39 + 0.4e1 * t25;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t44 = 0.1e1 / t29 / rho[0];
  t54 = my_piecewise3(t2, 0, t7 * (0.4e1 * t19 * t44 + 0.2e1 * params->B * t44 - 0.6e1 * params->C * t44) / 0.2e1);
  tv3rho30 = 0.2e1 * rho[0] * t54 + 0.6e1 * t39;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t9, t11, t16;
  double tzk0;

  double t17, t19, t25, tvrho0;

  double t29, t30, t39, tv2rho20;

  double t44, t54, tv3rho30;

  double t58, t59, t69, tv4rho40;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t9 = log(t7 * rho[0]);
  t11 = t9 * t9;
  t16 = my_piecewise3(t2, 0, t7 * (params->C * t11 + params->B * t9 + params->A) / 0.2e1);
  tzk0 = 0.2e1 * t16;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t17 = 0.1e1 / rho[0];
  t19 = params->C * t9;
  t25 = my_piecewise3(t2, 0, t7 * (0.2e1 * t19 * t17 + params->B * t17) / 0.2e1);
  tvrho0 = 0.2e1 * rho[0] * t25 + 0.2e1 * t16;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t29 = rho[0] * rho[0];
  t30 = 0.1e1 / t29;
  t39 = my_piecewise3(t2, 0, t7 * (-0.2e1 * t19 * t30 - params->B * t30 + 0.2e1 * params->C * t30) / 0.2e1);
  tv2rho20 = 0.2e1 * rho[0] * t39 + 0.4e1 * t25;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t44 = 0.1e1 / t29 / rho[0];
  t54 = my_piecewise3(t2, 0, t7 * (0.4e1 * t19 * t44 + 0.2e1 * params->B * t44 - 0.6e1 * params->C * t44) / 0.2e1);
  tv3rho30 = 0.2e1 * rho[0] * t54 + 0.6e1 * t39;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t58 = t29 * t29;
  t59 = 0.1e1 / t58;
  t69 = my_piecewise3(t2, 0, t7 * (-0.12e2 * t19 * t59 - 0.6e1 * params->B * t59 + 0.22e2 * params->C * t59) / 0.2e1);
  tv4rho40 = 0.2e1 * rho[0] * t69 + 0.8e1 * t54;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t13, t16, t19, t20, t21, t23;
  double t25, t27, t30, t31, t32, t33, t34, t36;
  double t37, t39, t41, t43, t46, tzk0;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = 0.1e1 - t5 <= p->zeta_threshold;
  t11 = -t8;
  t12 = my_piecewise5(t7, t8, t10, t11, t5);
  t13 = 0.1e1 + t12;
  t16 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t19 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t20 = my_piecewise5(t16, t8, t19, t11, t5);
  t21 = 0.1e1 + t20;
  t23 = log(t21 * t3);
  t25 = t23 * t23;
  t27 = t23 * params->B + t25 * params->C + params->A;
  t30 = my_piecewise3(t1, 0, t13 * t27 / 0.2e1);
  t31 = rho[1] <= p->dens_threshold;
  t32 = my_piecewise5(t10, t8, t7, t11, -t5);
  t33 = 0.1e1 + t32;
  t34 = -t2;
  t36 = my_piecewise5(t19, t8, t16, t11, t34 * t4);
  t37 = 0.1e1 + t36;
  t39 = log(t37 * t3);
  t41 = t39 * t39;
  t43 = t39 * params->B + t41 * params->C + params->A;
  t46 = my_piecewise3(t31, 0, t33 * t43 / 0.2e1);
  tzk0 = t30 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t13, t16, t19, t20, t21, t23;
  double t25, t27, t30, t31, t32, t33, t34, t36;
  double t37, t39, t41, t43, t46, tzk0;

  double t47, t48, t49, t50, t51, t53, t55, t56;
  double t57, t58, t60, t61, t65, t69, t71, t73;
  double t75, t77, t78, t79, t80, t82, t83, t87;
  double t91, tvrho0, t94, t95, t97, t99, t100, t102;
  double t106, t110, t112, t115, t117, t118, t120, t124;
  double t128, tvrho1;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = 0.1e1 - t5 <= p->zeta_threshold;
  t11 = -t8;
  t12 = my_piecewise5(t7, t8, t10, t11, t5);
  t13 = 0.1e1 + t12;
  t16 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t19 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t20 = my_piecewise5(t16, t8, t19, t11, t5);
  t21 = 0.1e1 + t20;
  t23 = log(t21 * t3);
  t25 = t23 * t23;
  t27 = t23 * params->B + t25 * params->C + params->A;
  t30 = my_piecewise3(t1, 0, t13 * t27 / 0.2e1);
  t31 = rho[1] <= p->dens_threshold;
  t32 = my_piecewise5(t10, t8, t7, t11, -t5);
  t33 = 0.1e1 + t32;
  t34 = -t2;
  t36 = my_piecewise5(t19, t8, t16, t11, t34 * t4);
  t37 = 0.1e1 + t36;
  t39 = log(t37 * t3);
  t41 = t39 * t39;
  t43 = t39 * params->B + t41 * params->C + params->A;
  t46 = my_piecewise3(t31, 0, t33 * t43 / 0.2e1);
  tzk0 = t30 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t3 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t50 = t4 - t49;
  t51 = my_piecewise5(t7, 0, t10, 0, t50);
  t53 = my_piecewise5(t16, 0, t19, 0, t50);
  t55 = t3 * t53 + t20 + 0.1e1;
  t56 = params->B * t55;
  t57 = 0.1e1 / t21;
  t58 = t57 * t4;
  t60 = params->C * t23;
  t61 = t55 * t57;
  t65 = 0.2e1 * t4 * t60 * t61 + t56 * t58;
  t69 = my_piecewise3(t1, 0, t13 * t65 / 0.2e1 + t51 * t27 / 0.2e1);
  t71 = my_piecewise5(t10, 0, t7, 0, -t50);
  t73 = t34 * t48;
  t75 = my_piecewise5(t19, 0, t16, 0, -t4 - t73);
  t77 = t3 * t75 + t36 + 0.1e1;
  t78 = params->B * t77;
  t79 = 0.1e1 / t37;
  t80 = t79 * t4;
  t82 = params->C * t39;
  t83 = t77 * t79;
  t87 = 0.2e1 * t4 * t82 * t83 + t78 * t80;
  t91 = my_piecewise3(t31, 0, t33 * t87 / 0.2e1 + t71 * t43 / 0.2e1);
  tvrho0 = t30 + t46 + t3 * (t69 + t91);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t94 = -t4 - t49;
  t95 = my_piecewise5(t7, 0, t10, 0, t94);
  t97 = my_piecewise5(t16, 0, t19, 0, t94);
  t99 = t3 * t97 + t20 + 0.1e1;
  t100 = params->B * t99;
  t102 = t99 * t57;
  t106 = 0.2e1 * t102 * t4 * t60 + t100 * t58;
  t110 = my_piecewise3(t1, 0, t13 * t106 / 0.2e1 + t95 * t27 / 0.2e1);
  t112 = my_piecewise5(t10, 0, t7, 0, -t94);
  t115 = my_piecewise5(t19, 0, t16, 0, t4 - t73);
  t117 = t115 * t3 + t36 + 0.1e1;
  t118 = params->B * t117;
  t120 = t117 * t79;
  t124 = 0.2e1 * t120 * t4 * t82 + t118 * t80;
  t128 = my_piecewise3(t31, 0, t112 * t43 / 0.2e1 + t33 * t124 / 0.2e1);
  tvrho1 = t30 + t46 + t3 * (t110 + t128);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t13, t16, t19, t20, t21, t23;
  double t25, t27, t30, t31, t32, t33, t34, t36;
  double t37, t39, t41, t43, t46, tzk0;

  double t47, t48, t49, t50, t51, t53, t55, t56;
  double t57, t58, t60, t61, t65, t69, t71, t73;
  double t75, t77, t78, t79, t80, t82, t83, t87;
  double t91, tvrho0, t94, t95, t97, t99, t100, t102;
  double t106, t110, t112, t115, t117, t118, t120, t124;
  double t128, tvrho1;

  double t134, t135, t137, t138, t142, t145, t146, t148;
  double t149, t150, t151, t153, t155, t156, t157, t160;
  double t164, t170, t174, t176, t180, t183, t186, t187;
  double t189, t190, t191, t192, t194, t196, t197, t198;
  double t201, t205, t211, t215, tv2rho20, t218, t219, t223;
  double t225, t226, t229, t230, t231, t234, t238, t243;
  double t244, t248, t249, t254, t256, t257, t260, t261;
  double t262, t265, t269, t274, t275, t279, tv2rho21, t285;
  double t286, t290, t293, t294, t296, t298, t299, t302;
  double t308, t312, t314, t320, t323, t324, t326, t328;
  double t329, t332, t338, t342, tv2rho22;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = 0.1e1 - t5 <= p->zeta_threshold;
  t11 = -t8;
  t12 = my_piecewise5(t7, t8, t10, t11, t5);
  t13 = 0.1e1 + t12;
  t16 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t19 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t20 = my_piecewise5(t16, t8, t19, t11, t5);
  t21 = 0.1e1 + t20;
  t23 = log(t21 * t3);
  t25 = t23 * t23;
  t27 = t23 * params->B + t25 * params->C + params->A;
  t30 = my_piecewise3(t1, 0, t13 * t27 / 0.2e1);
  t31 = rho[1] <= p->dens_threshold;
  t32 = my_piecewise5(t10, t8, t7, t11, -t5);
  t33 = 0.1e1 + t32;
  t34 = -t2;
  t36 = my_piecewise5(t19, t8, t16, t11, t34 * t4);
  t37 = 0.1e1 + t36;
  t39 = log(t37 * t3);
  t41 = t39 * t39;
  t43 = t39 * params->B + t41 * params->C + params->A;
  t46 = my_piecewise3(t31, 0, t33 * t43 / 0.2e1);
  tzk0 = t30 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t3 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t50 = t4 - t49;
  t51 = my_piecewise5(t7, 0, t10, 0, t50);
  t53 = my_piecewise5(t16, 0, t19, 0, t50);
  t55 = t3 * t53 + t20 + 0.1e1;
  t56 = params->B * t55;
  t57 = 0.1e1 / t21;
  t58 = t57 * t4;
  t60 = params->C * t23;
  t61 = t55 * t57;
  t65 = 0.2e1 * t4 * t60 * t61 + t56 * t58;
  t69 = my_piecewise3(t1, 0, t13 * t65 / 0.2e1 + t51 * t27 / 0.2e1);
  t71 = my_piecewise5(t10, 0, t7, 0, -t50);
  t73 = t34 * t48;
  t75 = my_piecewise5(t19, 0, t16, 0, -t4 - t73);
  t77 = t3 * t75 + t36 + 0.1e1;
  t78 = params->B * t77;
  t79 = 0.1e1 / t37;
  t80 = t79 * t4;
  t82 = params->C * t39;
  t83 = t77 * t79;
  t87 = 0.2e1 * t4 * t82 * t83 + t78 * t80;
  t91 = my_piecewise3(t31, 0, t33 * t87 / 0.2e1 + t71 * t43 / 0.2e1);
  tvrho0 = t30 + t46 + t3 * (t69 + t91);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t94 = -t4 - t49;
  t95 = my_piecewise5(t7, 0, t10, 0, t94);
  t97 = my_piecewise5(t16, 0, t19, 0, t94);
  t99 = t3 * t97 + t20 + 0.1e1;
  t100 = params->B * t99;
  t102 = t99 * t57;
  t106 = 0.2e1 * t102 * t4 * t60 + t100 * t58;
  t110 = my_piecewise3(t1, 0, t13 * t106 / 0.2e1 + t95 * t27 / 0.2e1);
  t112 = my_piecewise5(t10, 0, t7, 0, -t94);
  t115 = my_piecewise5(t19, 0, t16, 0, t4 - t73);
  t117 = t115 * t3 + t36 + 0.1e1;
  t118 = params->B * t117;
  t120 = t117 * t79;
  t124 = 0.2e1 * t120 * t4 * t82 + t118 * t80;
  t128 = my_piecewise3(t31, 0, t112 * t43 / 0.2e1 + t33 * t124 / 0.2e1);
  tvrho1 = t30 + t46 + t3 * (t110 + t128);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t134 = 0.1e1 / t47 / t3;
  t135 = t2 * t134;
  t137 = -0.2e1 * t48 + 0.2e1 * t135;
  t138 = my_piecewise5(t7, 0, t10, 0, t137);
  t142 = my_piecewise5(t16, 0, t19, 0, t137);
  t145 = t142 * t3 + 0.2e1 * t53;
  t146 = params->B * t145;
  t148 = t21 * t21;
  t149 = 0.1e1 / t148;
  t150 = t149 * t4;
  t151 = t150 * t53;
  t153 = t57 * t48;
  t155 = t55 * t55;
  t156 = params->C * t155;
  t157 = t149 * t48;
  t160 = t145 * t57;
  t164 = t60 * t55;
  t170 = 0.2e1 * t160 * t4 * t60 - 0.2e1 * t48 * t60 * t61 + t146 * t58 - 0.2e1 * t151 * t164 - t151 * t56 - t153 * t56 + 0.2e1 * t156 * t157;
  t174 = my_piecewise3(t1, 0, t138 * t27 / 0.2e1 + t51 * t65 + t13 * t170 / 0.2e1);
  t176 = my_piecewise5(t10, 0, t7, 0, -t137);
  t180 = t34 * t134;
  t183 = my_piecewise5(t19, 0, t16, 0, 0.2e1 * t48 + 0.2e1 * t180);
  t186 = t183 * t3 + 0.2e1 * t75;
  t187 = params->B * t186;
  t189 = t37 * t37;
  t190 = 0.1e1 / t189;
  t191 = t190 * t4;
  t192 = t191 * t75;
  t194 = t79 * t48;
  t196 = t77 * t77;
  t197 = params->C * t196;
  t198 = t190 * t48;
  t201 = t186 * t79;
  t205 = t82 * t77;
  t211 = 0.2e1 * t201 * t4 * t82 - 0.2e1 * t48 * t82 * t83 + t187 * t80 - 0.2e1 * t192 * t205 - t192 * t78 - t194 * t78 + 0.2e1 * t197 * t198;
  t215 = my_piecewise3(t31, 0, t176 * t43 / 0.2e1 + t71 * t87 + t33 * t211 / 0.2e1);
  tv2rho20 = 0.2e1 * t69 + 0.2e1 * t91 + t3 * (t174 + t215);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t218 = 0.2e1 * t135;
  t219 = my_piecewise5(t7, 0, t10, 0, t218);
  t223 = my_piecewise5(t16, 0, t19, 0, t218);
  t225 = t223 * t3 + t53 + t97;
  t226 = params->B * t225;
  t229 = t100 * t153;
  t230 = params->C * t55;
  t231 = t157 * t99;
  t234 = t225 * t57;
  t238 = t60 * t99;
  t243 = 0.2e1 * t60 * t102 * t48;
  t244 = 0.2e1 * t234 * t4 * t60 - t100 * t151 - 0.2e1 * t151 * t238 + t226 * t58 + 0.2e1 * t230 * t231 - t229 - t243;
  t248 = my_piecewise3(t1, 0, t51 * t106 / 0.2e1 + t13 * t244 / 0.2e1 + t219 * t27 / 0.2e1 + t95 * t65 / 0.2e1);
  t249 = my_piecewise5(t10, 0, t7, 0, -t218);
  t254 = my_piecewise5(t19, 0, t16, 0, 0.2e1 * t180);
  t256 = t254 * t3 + t115 + t75;
  t257 = params->B * t256;
  t260 = t118 * t194;
  t261 = params->C * t77;
  t262 = t198 * t117;
  t265 = t256 * t79;
  t269 = t82 * t117;
  t274 = 0.2e1 * t82 * t120 * t48;
  t275 = 0.2e1 * t265 * t4 * t82 - t118 * t192 - 0.2e1 * t192 * t269 + t257 * t80 + 0.2e1 * t261 * t262 - t260 - t274;
  t279 = my_piecewise3(t31, 0, t112 * t87 / 0.2e1 + t71 * t124 / 0.2e1 + t249 * t43 / 0.2e1 + t33 * t275 / 0.2e1);
  tv2rho21 = t69 + t91 + t110 + t128 + t3 * (t248 + t279);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t285 = 0.2e1 * t48 + 0.2e1 * t135;
  t286 = my_piecewise5(t7, 0, t10, 0, t285);
  t290 = my_piecewise5(t16, 0, t19, 0, t285);
  t293 = t290 * t3 + 0.2e1 * t97;
  t294 = params->B * t293;
  t296 = t150 * t97;
  t298 = t99 * t99;
  t299 = params->C * t298;
  t302 = t293 * t57;
  t308 = 0.2e1 * t302 * t4 * t60 - t100 * t296 + 0.2e1 * t157 * t299 - 0.2e1 * t238 * t296 + t294 * t58 - t229 - t243;
  t312 = my_piecewise3(t1, 0, t286 * t27 / 0.2e1 + t95 * t106 + t13 * t308 / 0.2e1);
  t314 = my_piecewise5(t10, 0, t7, 0, -t285);
  t320 = my_piecewise5(t19, 0, t16, 0, -0.2e1 * t48 + 0.2e1 * t180);
  t323 = t3 * t320 + 0.2e1 * t115;
  t324 = params->B * t323;
  t326 = t191 * t115;
  t328 = t117 * t117;
  t329 = params->C * t328;
  t332 = t323 * t79;
  t338 = 0.2e1 * t332 * t4 * t82 - t118 * t326 + 0.2e1 * t198 * t329 - 0.2e1 * t269 * t326 + t324 * t80 - t260 - t274;
  t342 = my_piecewise3(t31, 0, t314 * t43 / 0.2e1 + t112 * t124 + t33 * t338 / 0.2e1);
  tv2rho22 = 0.2e1 * t110 + 0.2e1 * t128 + t3 * (t312 + t342);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t13, t16, t19, t20, t21, t23;
  double t25, t27, t30, t31, t32, t33, t34, t36;
  double t37, t39, t41, t43, t46, tzk0;

  double t47, t48, t49, t50, t51, t53, t55, t56;
  double t57, t58, t60, t61, t65, t69, t71, t73;
  double t75, t77, t78, t79, t80, t82, t83, t87;
  double t91, tvrho0, t94, t95, t97, t99, t100, t102;
  double t106, t110, t112, t115, t117, t118, t120, t124;
  double t128, tvrho1;

  double t134, t135, t137, t138, t142, t145, t146, t148;
  double t149, t150, t151, t153, t155, t156, t157, t160;
  double t164, t170, t174, t176, t180, t183, t186, t187;
  double t189, t190, t191, t192, t194, t196, t197, t198;
  double t201, t205, t211, t215, tv2rho20, t218, t219, t223;
  double t225, t226, t229, t230, t231, t234, t238, t243;
  double t244, t248, t249, t254, t256, t257, t260, t261;
  double t262, t265, t269, t274, t275, t279, tv2rho21, t285;
  double t286, t290, t293, t294, t296, t298, t299, t302;
  double t308, t312, t314, t320, t323, t324, t326, t328;
  double t329, t332, t338, t342, tv2rho22;

  double t347, t348, t349, t351, t352, t363, t365, t372;
  double t373, t374, t377, t380, t383, t384, t388, t390;
  double t391, t392, t395, t402, t413, t417, t419, t430;
  double t432, t439, t440, t441, t444, t447, t450, t453;
  double t454, t458, t460, t461, t462, t465, t472, t483;
  double t487, tv3rho30, t490, t491, t492, t493, t494, t495;
  double t506, t510, t511, t514, t517, t519, t520, t521;
  double t525, t529, t533, t535, t536, t537, t540, t541;
  double t543, t547, t553, t554, t558, t560, t571, t575;
  double t576, t579, t582, t584, t586, t587, t588, t592;
  double t596, t600, t602, t603, t604, t607, t608, t610;
  double t614, t620, t621, t625, tv3rho31, t628, t629, t640;
  double t641, t643, t645, t646, t648, t649, t654, t656;
  double t657, t662, t666, t669, t670, t672, t675, t678;
  double t680, t681, t682, t685, t692, t693, t697, t699;
  double t708, t709, t712, t714, t715, t717, t718, t725;
  double t727, t728, t733, t737, t740, t741, t743, t746;
  double t749, t751, t752, t753, t756, t763, t764, t768;
  double tv3rho32, t774, t775, t784, t787, t788, t791, t792;
  double t801, t812, t816, t820, t822, t833, t836, t837;
  double t840, t841, t850, t861, t865, t869, tv3rho33;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = 0.1e1 - t5 <= p->zeta_threshold;
  t11 = -t8;
  t12 = my_piecewise5(t7, t8, t10, t11, t5);
  t13 = 0.1e1 + t12;
  t16 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t19 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t20 = my_piecewise5(t16, t8, t19, t11, t5);
  t21 = 0.1e1 + t20;
  t23 = log(t21 * t3);
  t25 = t23 * t23;
  t27 = t23 * params->B + t25 * params->C + params->A;
  t30 = my_piecewise3(t1, 0, t13 * t27 / 0.2e1);
  t31 = rho[1] <= p->dens_threshold;
  t32 = my_piecewise5(t10, t8, t7, t11, -t5);
  t33 = 0.1e1 + t32;
  t34 = -t2;
  t36 = my_piecewise5(t19, t8, t16, t11, t34 * t4);
  t37 = 0.1e1 + t36;
  t39 = log(t37 * t3);
  t41 = t39 * t39;
  t43 = t39 * params->B + t41 * params->C + params->A;
  t46 = my_piecewise3(t31, 0, t33 * t43 / 0.2e1);
  tzk0 = t30 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t3 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t50 = t4 - t49;
  t51 = my_piecewise5(t7, 0, t10, 0, t50);
  t53 = my_piecewise5(t16, 0, t19, 0, t50);
  t55 = t3 * t53 + t20 + 0.1e1;
  t56 = params->B * t55;
  t57 = 0.1e1 / t21;
  t58 = t57 * t4;
  t60 = params->C * t23;
  t61 = t55 * t57;
  t65 = 0.2e1 * t4 * t60 * t61 + t56 * t58;
  t69 = my_piecewise3(t1, 0, t13 * t65 / 0.2e1 + t51 * t27 / 0.2e1);
  t71 = my_piecewise5(t10, 0, t7, 0, -t50);
  t73 = t34 * t48;
  t75 = my_piecewise5(t19, 0, t16, 0, -t4 - t73);
  t77 = t3 * t75 + t36 + 0.1e1;
  t78 = params->B * t77;
  t79 = 0.1e1 / t37;
  t80 = t79 * t4;
  t82 = params->C * t39;
  t83 = t77 * t79;
  t87 = 0.2e1 * t4 * t82 * t83 + t78 * t80;
  t91 = my_piecewise3(t31, 0, t33 * t87 / 0.2e1 + t71 * t43 / 0.2e1);
  tvrho0 = t30 + t46 + t3 * (t69 + t91);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t94 = -t4 - t49;
  t95 = my_piecewise5(t7, 0, t10, 0, t94);
  t97 = my_piecewise5(t16, 0, t19, 0, t94);
  t99 = t3 * t97 + t20 + 0.1e1;
  t100 = params->B * t99;
  t102 = t99 * t57;
  t106 = 0.2e1 * t102 * t4 * t60 + t100 * t58;
  t110 = my_piecewise3(t1, 0, t13 * t106 / 0.2e1 + t95 * t27 / 0.2e1);
  t112 = my_piecewise5(t10, 0, t7, 0, -t94);
  t115 = my_piecewise5(t19, 0, t16, 0, t4 - t73);
  t117 = t115 * t3 + t36 + 0.1e1;
  t118 = params->B * t117;
  t120 = t117 * t79;
  t124 = 0.2e1 * t120 * t4 * t82 + t118 * t80;
  t128 = my_piecewise3(t31, 0, t112 * t43 / 0.2e1 + t33 * t124 / 0.2e1);
  tvrho1 = t30 + t46 + t3 * (t110 + t128);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t134 = 0.1e1 / t47 / t3;
  t135 = t2 * t134;
  t137 = -0.2e1 * t48 + 0.2e1 * t135;
  t138 = my_piecewise5(t7, 0, t10, 0, t137);
  t142 = my_piecewise5(t16, 0, t19, 0, t137);
  t145 = t142 * t3 + 0.2e1 * t53;
  t146 = params->B * t145;
  t148 = t21 * t21;
  t149 = 0.1e1 / t148;
  t150 = t149 * t4;
  t151 = t150 * t53;
  t153 = t57 * t48;
  t155 = t55 * t55;
  t156 = params->C * t155;
  t157 = t149 * t48;
  t160 = t145 * t57;
  t164 = t60 * t55;
  t170 = 0.2e1 * t160 * t4 * t60 - 0.2e1 * t48 * t60 * t61 + t146 * t58 - 0.2e1 * t151 * t164 - t151 * t56 - t153 * t56 + 0.2e1 * t156 * t157;
  t174 = my_piecewise3(t1, 0, t138 * t27 / 0.2e1 + t51 * t65 + t13 * t170 / 0.2e1);
  t176 = my_piecewise5(t10, 0, t7, 0, -t137);
  t180 = t34 * t134;
  t183 = my_piecewise5(t19, 0, t16, 0, 0.2e1 * t48 + 0.2e1 * t180);
  t186 = t183 * t3 + 0.2e1 * t75;
  t187 = params->B * t186;
  t189 = t37 * t37;
  t190 = 0.1e1 / t189;
  t191 = t190 * t4;
  t192 = t191 * t75;
  t194 = t79 * t48;
  t196 = t77 * t77;
  t197 = params->C * t196;
  t198 = t190 * t48;
  t201 = t186 * t79;
  t205 = t82 * t77;
  t211 = 0.2e1 * t201 * t4 * t82 - 0.2e1 * t48 * t82 * t83 + t187 * t80 - 0.2e1 * t192 * t205 - t192 * t78 - t194 * t78 + 0.2e1 * t197 * t198;
  t215 = my_piecewise3(t31, 0, t176 * t43 / 0.2e1 + t71 * t87 + t33 * t211 / 0.2e1);
  tv2rho20 = 0.2e1 * t69 + 0.2e1 * t91 + t3 * (t174 + t215);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t218 = 0.2e1 * t135;
  t219 = my_piecewise5(t7, 0, t10, 0, t218);
  t223 = my_piecewise5(t16, 0, t19, 0, t218);
  t225 = t223 * t3 + t53 + t97;
  t226 = params->B * t225;
  t229 = t100 * t153;
  t230 = params->C * t55;
  t231 = t157 * t99;
  t234 = t225 * t57;
  t238 = t60 * t99;
  t243 = 0.2e1 * t60 * t102 * t48;
  t244 = 0.2e1 * t234 * t4 * t60 - t100 * t151 - 0.2e1 * t151 * t238 + t226 * t58 + 0.2e1 * t230 * t231 - t229 - t243;
  t248 = my_piecewise3(t1, 0, t51 * t106 / 0.2e1 + t13 * t244 / 0.2e1 + t219 * t27 / 0.2e1 + t95 * t65 / 0.2e1);
  t249 = my_piecewise5(t10, 0, t7, 0, -t218);
  t254 = my_piecewise5(t19, 0, t16, 0, 0.2e1 * t180);
  t256 = t254 * t3 + t115 + t75;
  t257 = params->B * t256;
  t260 = t118 * t194;
  t261 = params->C * t77;
  t262 = t198 * t117;
  t265 = t256 * t79;
  t269 = t82 * t117;
  t274 = 0.2e1 * t82 * t120 * t48;
  t275 = 0.2e1 * t265 * t4 * t82 - t118 * t192 - 0.2e1 * t192 * t269 + t257 * t80 + 0.2e1 * t261 * t262 - t260 - t274;
  t279 = my_piecewise3(t31, 0, t112 * t87 / 0.2e1 + t71 * t124 / 0.2e1 + t249 * t43 / 0.2e1 + t33 * t275 / 0.2e1);
  tv2rho21 = t69 + t91 + t110 + t128 + t3 * (t248 + t279);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t285 = 0.2e1 * t48 + 0.2e1 * t135;
  t286 = my_piecewise5(t7, 0, t10, 0, t285);
  t290 = my_piecewise5(t16, 0, t19, 0, t285);
  t293 = t290 * t3 + 0.2e1 * t97;
  t294 = params->B * t293;
  t296 = t150 * t97;
  t298 = t99 * t99;
  t299 = params->C * t298;
  t302 = t293 * t57;
  t308 = 0.2e1 * t302 * t4 * t60 - t100 * t296 + 0.2e1 * t157 * t299 - 0.2e1 * t238 * t296 + t294 * t58 - t229 - t243;
  t312 = my_piecewise3(t1, 0, t286 * t27 / 0.2e1 + t95 * t106 + t13 * t308 / 0.2e1);
  t314 = my_piecewise5(t10, 0, t7, 0, -t285);
  t320 = my_piecewise5(t19, 0, t16, 0, -0.2e1 * t48 + 0.2e1 * t180);
  t323 = t3 * t320 + 0.2e1 * t115;
  t324 = params->B * t323;
  t326 = t191 * t115;
  t328 = t117 * t117;
  t329 = params->C * t328;
  t332 = t323 * t79;
  t338 = 0.2e1 * t332 * t4 * t82 - t118 * t326 + 0.2e1 * t198 * t329 - 0.2e1 * t269 * t326 + t324 * t80 - t260 - t274;
  t342 = my_piecewise3(t31, 0, t314 * t43 / 0.2e1 + t112 * t124 + t33 * t338 / 0.2e1);
  tv2rho22 = 0.2e1 * t110 + 0.2e1 * t128 + t3 * (t312 + t342);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t347 = t47 * t47;
  t348 = 0.1e1 / t347;
  t349 = t2 * t348;
  t351 = 0.6e1 * t134 - 0.6e1 * t349;
  t352 = my_piecewise5(t7, 0, t10, 0, t351);
  t363 = t150 * t142;
  t365 = t57 * t134;
  t372 = 0.1e1 / t148 / t21;
  t373 = t372 * t48;
  t374 = t373 * t53;
  t377 = t149 * t134;
  t380 = my_piecewise5(t16, 0, t19, 0, t351);
  t383 = t3 * t380 + 0.3e1 * t142;
  t384 = t383 * t57;
  t388 = params->B * t383;
  t390 = t372 * t4;
  t391 = t53 * t53;
  t392 = t390 * t391;
  t395 = t157 * t53;
  t402 = t60 * t145;
  t413 = 0.4e1 * t134 * t60 * t61 + 0.6e1 * t145 * t157 * t230 - 0.4e1 * t160 * t48 * t60 + 0.2e1 * t384 * t4 * t60 - 0.2e1 * t146 * t151 - 0.2e1 * t146 * t153 - 0.4e1 * t151 * t402 - 0.6e1 * t156 * t374 - 0.6e1 * t156 * t377 - 0.2e1 * t164 * t363 + 0.4e1 * t164 * t392 + 0.4e1 * t164 * t395 - t363 * t56 + 0.2e1 * t365 * t56 + t388 * t58 + 0.2e1 * t392 * t56 + 0.2e1 * t395 * t56;
  t417 = my_piecewise3(t1, 0, t352 * t27 / 0.2e1 + 0.3e1 / 0.2e1 * t138 * t65 + 0.3e1 / 0.2e1 * t51 * t170 + t13 * t413 / 0.2e1);
  t419 = my_piecewise5(t10, 0, t7, 0, -t351);
  t430 = t191 * t183;
  t432 = t79 * t134;
  t439 = 0.1e1 / t189 / t37;
  t440 = t439 * t48;
  t441 = t440 * t75;
  t444 = t190 * t134;
  t447 = t34 * t348;
  t450 = my_piecewise5(t19, 0, t16, 0, -0.6e1 * t134 - 0.6e1 * t447);
  t453 = t3 * t450 + 0.3e1 * t183;
  t454 = t453 * t79;
  t458 = params->B * t453;
  t460 = t439 * t4;
  t461 = t75 * t75;
  t462 = t460 * t461;
  t465 = t198 * t75;
  t472 = t82 * t186;
  t483 = 0.4e1 * t134 * t82 * t83 + 0.6e1 * t186 * t198 * t261 - 0.4e1 * t201 * t48 * t82 + 0.2e1 * t4 * t454 * t82 - 0.2e1 * t187 * t192 - 0.2e1 * t187 * t194 - 0.4e1 * t192 * t472 - 0.6e1 * t197 * t441 - 0.6e1 * t197 * t444 - 0.2e1 * t205 * t430 + 0.4e1 * t205 * t462 + 0.4e1 * t205 * t465 - t430 * t78 + 0.2e1 * t432 * t78 + t458 * t80 + 0.2e1 * t462 * t78 + 0.2e1 * t465 * t78;
  t487 = my_piecewise3(t31, 0, t419 * t43 / 0.2e1 + 0.3e1 / 0.2e1 * t176 * t87 + 0.3e1 / 0.2e1 * t71 * t211 + t33 * t483 / 0.2e1);
  tv3rho30 = 0.3e1 * t174 + 0.3e1 * t215 + t3 * (t417 + t487);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t490 = 0.2e1 * t248;
  t491 = 0.2e1 * t279;
  t492 = 0.2e1 * t134;
  t493 = 0.6e1 * t349;
  t494 = t492 - t493;
  t495 = my_piecewise5(t7, 0, t10, 0, t494);
  t506 = t226 * t153;
  t510 = 0.2e1 * t100 * t365;
  t511 = params->C * t145;
  t514 = t157 * t225;
  t517 = my_piecewise5(t16, 0, t19, 0, t494);
  t519 = 0.2e1 * t223;
  t520 = t3 * t517 + t142 + t519;
  t521 = t520 * t57;
  t525 = params->B * t520;
  t529 = t238 * t395;
  t533 = t100 * t395;
  t535 = t230 * t372;
  t536 = t48 * t99;
  t537 = t536 * t53;
  t540 = t377 * t99;
  t541 = t230 * t540;
  t543 = t60 * t225;
  t547 = t60 * t234 * t48;
  t553 = 0.4e1 * t60 * t102 * t134;
  t554 = 0.2e1 * t4 * t521 * t60 - t100 * t363 + 0.2e1 * t100 * t392 - 0.2e1 * t151 * t226 - 0.4e1 * t151 * t543 + 0.4e1 * t230 * t514 + 0.2e1 * t231 * t511 - 0.2e1 * t238 * t363 + 0.4e1 * t238 * t392 + t525 * t58 - 0.6e1 * t535 * t537 - 0.2e1 * t506 + t510 + 0.4e1 * t529 + 0.2e1 * t533 - 0.6e1 * t541 - 0.4e1 * t547 + t553;
  t558 = my_piecewise3(t1, 0, t495 * t27 / 0.2e1 + t219 * t65 + t95 * t170 / 0.2e1 + t138 * t106 / 0.2e1 + t51 * t244 + t13 * t554 / 0.2e1);
  t560 = my_piecewise5(t10, 0, t7, 0, -t494);
  t571 = t257 * t194;
  t575 = 0.2e1 * t118 * t432;
  t576 = params->C * t186;
  t579 = t198 * t256;
  t582 = 0.6e1 * t447;
  t584 = my_piecewise5(t19, 0, t16, 0, -t492 - t582);
  t586 = 0.2e1 * t254;
  t587 = t3 * t584 + t183 + t586;
  t588 = t587 * t79;
  t592 = params->B * t587;
  t596 = t269 * t465;
  t600 = t118 * t465;
  t602 = t261 * t439;
  t603 = t48 * t117;
  t604 = t603 * t75;
  t607 = t444 * t117;
  t608 = t261 * t607;
  t610 = t82 * t256;
  t614 = t82 * t265 * t48;
  t620 = 0.4e1 * t82 * t120 * t134;
  t621 = 0.2e1 * t4 * t588 * t82 - t118 * t430 + 0.2e1 * t118 * t462 - 0.2e1 * t192 * t257 - 0.4e1 * t192 * t610 + 0.4e1 * t261 * t579 + 0.2e1 * t262 * t576 - 0.2e1 * t269 * t430 + 0.4e1 * t269 * t462 + t592 * t80 - 0.6e1 * t602 * t604 - 0.2e1 * t571 + t575 + 0.4e1 * t596 + 0.2e1 * t600 - 0.6e1 * t608 - 0.4e1 * t614 + t620;
  t625 = my_piecewise3(t31, 0, t560 * t43 / 0.2e1 + t249 * t87 + t112 * t211 / 0.2e1 + t176 * t124 / 0.2e1 + t71 * t275 + t33 * t621 / 0.2e1);
  tv3rho31 = t174 + t215 + t490 + t491 + t3 * (t558 + t625);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t628 = -t492 - t493;
  t629 = my_piecewise5(t7, 0, t10, 0, t628);
  t640 = t294 * t153;
  t641 = t299 * t377;
  t643 = my_piecewise5(t16, 0, t19, 0, t628);
  t645 = t643 * t3 + t290 + t519;
  t646 = params->B * t645;
  t648 = t97 * t53;
  t649 = t390 * t648;
  t654 = t150 * t223;
  t656 = -t100 * t654 - t294 * t151 - t226 * t296 + 0.4e1 * t238 * t649 + t646 * t58 - t506 + t510 + t533 - 0.2e1 * t541 - 0.2e1 * t547 + t553 - t640 - 0.4e1 * t641;
  t657 = params->C * t99;
  t662 = t645 * t57;
  t666 = t157 * t293;
  t669 = t157 * t97;
  t670 = t100 * t669;
  t672 = t60 * t302 * t48;
  t675 = t536 * t97;
  t678 = t238 * t669;
  t680 = t100 * t372;
  t681 = t4 * t97;
  t682 = t681 * t53;
  t685 = t60 * t293;
  t692 = 0.2e1 * t4 * t60 * t662 - 0.2e1 * t685 * t151 + 0.2e1 * t230 * t666 - 0.2e1 * t238 * t654 - 0.2e1 * t543 * t296 - 0.4e1 * t299 * t374 + 0.4e1 * t657 * t514 - 0.2e1 * t535 * t675 + 0.2e1 * t680 * t682 + 0.2e1 * t529 + t670 - 0.2e1 * t672 + 0.2e1 * t678;
  t693 = t656 + t692;
  t697 = my_piecewise3(t1, 0, t629 * t27 / 0.2e1 + t286 * t65 / 0.2e1 + t219 * t106 + t95 * t244 + t51 * t308 / 0.2e1 + t13 * t693 / 0.2e1);
  t699 = my_piecewise5(t10, 0, t7, 0, -t628);
  t708 = t324 * t194;
  t709 = t329 * t444;
  t712 = my_piecewise5(t19, 0, t16, 0, t492 - t582);
  t714 = t712 * t3 + t320 + t586;
  t715 = params->B * t714;
  t717 = t115 * t75;
  t718 = t460 * t717;
  t725 = t191 * t254;
  t727 = -t118 * t725 - t324 * t192 - t257 * t326 + 0.4e1 * t269 * t718 + t715 * t80 - t571 + t575 + t600 - 0.2e1 * t608 - 0.2e1 * t614 + t620 - t708 - 0.4e1 * t709;
  t728 = params->C * t117;
  t733 = t714 * t79;
  t737 = t198 * t323;
  t740 = t198 * t115;
  t741 = t118 * t740;
  t743 = t82 * t332 * t48;
  t746 = t603 * t115;
  t749 = t269 * t740;
  t751 = t118 * t439;
  t752 = t4 * t115;
  t753 = t752 * t75;
  t756 = t82 * t323;
  t763 = 0.2e1 * t4 * t733 * t82 - 0.2e1 * t756 * t192 + 0.2e1 * t261 * t737 - 0.2e1 * t269 * t725 - 0.2e1 * t610 * t326 - 0.4e1 * t329 * t441 + 0.4e1 * t728 * t579 - 0.2e1 * t602 * t746 + 0.2e1 * t751 * t753 + 0.2e1 * t596 + t741 - 0.2e1 * t743 + 0.2e1 * t749;
  t764 = t727 + t763;
  t768 = my_piecewise3(t31, 0, t699 * t43 / 0.2e1 + t314 * t87 / 0.2e1 + t249 * t124 + t112 * t275 + t71 * t338 / 0.2e1 + t33 * t764 / 0.2e1);
  tv3rho32 = t490 + t491 + t312 + t342 + t3 * (t697 + t768);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t774 = -0.6e1 * t134 - 0.6e1 * t349;
  t775 = my_piecewise5(t7, 0, t10, 0, t774);
  t784 = my_piecewise5(t16, 0, t19, 0, t774);
  t787 = t784 * t3 + 0.3e1 * t290;
  t788 = params->B * t787;
  t791 = t97 * t97;
  t792 = t390 * t791;
  t801 = t150 * t290;
  t812 = t787 * t57;
  t816 = -0.6e1 * t299 * t373 * t97 + 0.2e1 * t4 * t60 * t812 + 0.2e1 * t100 * t792 - t100 * t801 + 0.4e1 * t238 * t792 - 0.2e1 * t238 * t801 - 0.2e1 * t294 * t296 - 0.4e1 * t685 * t296 + t788 * t58 + 0.6e1 * t657 * t666 + t510 + t553 - 0.2e1 * t640 - 0.6e1 * t641 + 0.2e1 * t670 - 0.4e1 * t672 + 0.4e1 * t678;
  t820 = my_piecewise3(t1, 0, t775 * t27 / 0.2e1 + 0.3e1 / 0.2e1 * t286 * t106 + 0.3e1 / 0.2e1 * t95 * t308 + t13 * t816 / 0.2e1);
  t822 = my_piecewise5(t10, 0, t7, 0, -t774);
  t833 = my_piecewise5(t19, 0, t16, 0, 0.6e1 * t134 - 0.6e1 * t447);
  t836 = t833 * t3 + 0.3e1 * t320;
  t837 = params->B * t836;
  t840 = t115 * t115;
  t841 = t460 * t840;
  t850 = t191 * t320;
  t861 = t836 * t79;
  t865 = -0.6e1 * t115 * t329 * t440 + 0.2e1 * t4 * t82 * t861 + 0.2e1 * t118 * t841 - t118 * t850 + 0.4e1 * t269 * t841 - 0.2e1 * t269 * t850 - 0.2e1 * t324 * t326 - 0.4e1 * t756 * t326 + 0.6e1 * t728 * t737 + t837 * t80 + t575 + t620 - 0.2e1 * t708 - 0.6e1 * t709 + 0.2e1 * t741 - 0.4e1 * t743 + 0.4e1 * t749;
  t869 = my_piecewise3(t31, 0, t822 * t43 / 0.2e1 + 0.3e1 / 0.2e1 * t314 * t124 + 0.3e1 / 0.2e1 * t112 * t338 + t33 * t865 / 0.2e1);
  tv3rho33 = 0.3e1 * t312 + 0.3e1 * t342 + t3 * (t820 + t869);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t13, t16, t19, t20, t21, t23;
  double t25, t27, t30, t31, t32, t33, t34, t36;
  double t37, t39, t41, t43, t46, tzk0;

  double t47, t48, t49, t50, t51, t53, t55, t56;
  double t57, t58, t60, t61, t65, t69, t71, t73;
  double t75, t77, t78, t79, t80, t82, t83, t87;
  double t91, tvrho0, t94, t95, t97, t99, t100, t102;
  double t106, t110, t112, t115, t117, t118, t120, t124;
  double t128, tvrho1;

  double t134, t135, t137, t138, t142, t145, t146, t148;
  double t149, t150, t151, t153, t155, t156, t157, t160;
  double t164, t170, t174, t176, t180, t183, t186, t187;
  double t189, t190, t191, t192, t194, t196, t197, t198;
  double t201, t205, t211, t215, tv2rho20, t218, t219, t223;
  double t225, t226, t229, t230, t231, t234, t238, t243;
  double t244, t248, t249, t254, t256, t257, t260, t261;
  double t262, t265, t269, t274, t275, t279, tv2rho21, t285;
  double t286, t290, t293, t294, t296, t298, t299, t302;
  double t308, t312, t314, t320, t323, t324, t326, t328;
  double t329, t332, t338, t342, tv2rho22;

  double t347, t348, t349, t351, t352, t363, t365, t372;
  double t373, t374, t377, t380, t383, t384, t388, t390;
  double t391, t392, t395, t402, t413, t417, t419, t430;
  double t432, t439, t440, t441, t444, t447, t450, t453;
  double t454, t458, t460, t461, t462, t465, t472, t483;
  double t487, tv3rho30, t490, t491, t492, t493, t494, t495;
  double t506, t510, t511, t514, t517, t519, t520, t521;
  double t525, t529, t533, t535, t536, t537, t540, t541;
  double t543, t547, t553, t554, t558, t560, t571, t575;
  double t576, t579, t582, t584, t586, t587, t588, t592;
  double t596, t600, t602, t603, t604, t607, t608, t610;
  double t614, t620, t621, t625, tv3rho31, t628, t629, t640;
  double t641, t643, t645, t646, t648, t649, t654, t656;
  double t657, t662, t666, t669, t670, t672, t675, t678;
  double t680, t681, t682, t685, t692, t693, t697, t699;
  double t708, t709, t712, t714, t715, t717, t718, t725;
  double t727, t728, t733, t737, t740, t741, t743, t746;
  double t749, t751, t752, t753, t756, t763, t764, t768;
  double tv3rho32, t774, t775, t784, t787, t788, t791, t792;
  double t801, t812, t816, t820, t822, t833, t836, t837;
  double t840, t841, t850, t861, t865, t869, tv3rho33;

  double t875, t876, t878, t879, t890, t893, t898, t901;
  double t905, t909, t916, t922, t923, t924, t925, t928;
  double t929, t935, t937, t940, t949, t954, t956, t962;
  double t977, t997, t1002, t1004, t1015, t1018, t1021, t1026;
  double t1029, t1033, t1037, t1044, t1050, t1051, t1052, t1053;
  double t1056, t1057, t1063, t1065, t1068, t1077, t1082, t1084;
  double t1090, t1105, t1125, t1130, tv4rho40, t1135, t1136, t1137;
  double t1138, t1153, t1155, t1158, t1161, t1164, t1169, t1171;
  double t1173, t1175, t1176, t1179, t1183, t1186, t1189, t1193;
  double t1199, t1200, t1207, t1214, t1218, t1220, t1224, t1226;
  double t1230, t1233, t1234, t1237, t1242, t1244, t1253, t1258;
  double t1260, t1275, t1277, t1279, t1282, t1285, t1288, t1293;
  double t1295, t1297, t1299, t1300, t1303, t1307, t1310, t1313;
  double t1317, t1323, t1324, t1331, t1338, t1342, t1344, t1348;
  double t1350, t1354, t1357, t1358, t1361, t1366, t1368, t1377;
  double t1382, tv4rho41, t1389, t1405, t1407, t1408, t1410, t1411;
  double t1415, t1419, t1420, t1421, t1423, t1424, t1427, t1435;
  double t1439, t1442, t1446, t1454, t1456, t1458, t1463, t1465;
  double t1469, t1477, t1480, t1485, t1489, t1492, t1495, t1497;
  double t1501, t1509, t1526, t1527, t1531, t1533, t1541, t1559;
  double t1562, t1568, t1569, t1585, t1587, t1588, t1590, t1591;
  double t1595, t1599, t1600, t1601, t1603, t1604, t1607, t1615;
  double t1619, t1622, t1626, t1633, t1638, t1641, t1643, t1647;
  double t1655, t1669, t1672, t1674, t1676, t1681, t1683, t1687;
  double t1695, t1698, t1703, t1709, t1710, t1714, t1716, t1722;
  double t1742, t1748, tv4rho42, t1753, t1754, t1777, t1787, t1790;
  double t1795, t1798, t1799, t1801, t1803, t1804, t1805, t1808;
  double t1811, t1813, t1835, t1842, t1846, t1852, t1854, t1856;
  double t1860, t1890, t1897, t1903, t1905, t1920, t1923, t1924;
  double t1926, t1928, t1929, t1930, t1933, t1936, t1946, t1957;
  double t1960, t1965, t1976, t1981, t1998, t2004, t2006, t2008;
  double t2012, t2042, t2049, t2055, tv4rho43, t2061, t2062, t2078;
  double t2087, t2091, t2094, t2108, t2114, t2140, t2145, t2147;
  double t2168, t2174, t2177, t2183, t2194, t2200, t2227, t2232;
  double tv4rho44;

  lda_k_gds08_params *params;

  assert(p->params != NULL);
  params = (lda_k_gds08_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = rho[0] - rho[1];
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t5 = t2 * t4;
  t7 = 0.1e1 + t5 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = 0.1e1 - t5 <= p->zeta_threshold;
  t11 = -t8;
  t12 = my_piecewise5(t7, t8, t10, t11, t5);
  t13 = 0.1e1 + t12;
  t16 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t19 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t20 = my_piecewise5(t16, t8, t19, t11, t5);
  t21 = 0.1e1 + t20;
  t23 = log(t21 * t3);
  t25 = t23 * t23;
  t27 = t23 * params->B + t25 * params->C + params->A;
  t30 = my_piecewise3(t1, 0, t13 * t27 / 0.2e1);
  t31 = rho[1] <= p->dens_threshold;
  t32 = my_piecewise5(t10, t8, t7, t11, -t5);
  t33 = 0.1e1 + t32;
  t34 = -t2;
  t36 = my_piecewise5(t19, t8, t16, t11, t34 * t4);
  t37 = 0.1e1 + t36;
  t39 = log(t37 * t3);
  t41 = t39 * t39;
  t43 = t39 * params->B + t41 * params->C + params->A;
  t46 = my_piecewise3(t31, 0, t33 * t43 / 0.2e1);
  tzk0 = t30 + t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t3 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t50 = t4 - t49;
  t51 = my_piecewise5(t7, 0, t10, 0, t50);
  t53 = my_piecewise5(t16, 0, t19, 0, t50);
  t55 = t3 * t53 + t20 + 0.1e1;
  t56 = params->B * t55;
  t57 = 0.1e1 / t21;
  t58 = t57 * t4;
  t60 = params->C * t23;
  t61 = t55 * t57;
  t65 = 0.2e1 * t4 * t60 * t61 + t56 * t58;
  t69 = my_piecewise3(t1, 0, t13 * t65 / 0.2e1 + t51 * t27 / 0.2e1);
  t71 = my_piecewise5(t10, 0, t7, 0, -t50);
  t73 = t34 * t48;
  t75 = my_piecewise5(t19, 0, t16, 0, -t4 - t73);
  t77 = t3 * t75 + t36 + 0.1e1;
  t78 = params->B * t77;
  t79 = 0.1e1 / t37;
  t80 = t79 * t4;
  t82 = params->C * t39;
  t83 = t77 * t79;
  t87 = 0.2e1 * t4 * t82 * t83 + t78 * t80;
  t91 = my_piecewise3(t31, 0, t33 * t87 / 0.2e1 + t71 * t43 / 0.2e1);
  tvrho0 = t30 + t46 + t3 * (t69 + t91);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t94 = -t4 - t49;
  t95 = my_piecewise5(t7, 0, t10, 0, t94);
  t97 = my_piecewise5(t16, 0, t19, 0, t94);
  t99 = t3 * t97 + t20 + 0.1e1;
  t100 = params->B * t99;
  t102 = t99 * t57;
  t106 = 0.2e1 * t102 * t4 * t60 + t100 * t58;
  t110 = my_piecewise3(t1, 0, t13 * t106 / 0.2e1 + t95 * t27 / 0.2e1);
  t112 = my_piecewise5(t10, 0, t7, 0, -t94);
  t115 = my_piecewise5(t19, 0, t16, 0, t4 - t73);
  t117 = t115 * t3 + t36 + 0.1e1;
  t118 = params->B * t117;
  t120 = t117 * t79;
  t124 = 0.2e1 * t120 * t4 * t82 + t118 * t80;
  t128 = my_piecewise3(t31, 0, t112 * t43 / 0.2e1 + t33 * t124 / 0.2e1);
  tvrho1 = t30 + t46 + t3 * (t110 + t128);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t134 = 0.1e1 / t47 / t3;
  t135 = t2 * t134;
  t137 = -0.2e1 * t48 + 0.2e1 * t135;
  t138 = my_piecewise5(t7, 0, t10, 0, t137);
  t142 = my_piecewise5(t16, 0, t19, 0, t137);
  t145 = t142 * t3 + 0.2e1 * t53;
  t146 = params->B * t145;
  t148 = t21 * t21;
  t149 = 0.1e1 / t148;
  t150 = t149 * t4;
  t151 = t150 * t53;
  t153 = t57 * t48;
  t155 = t55 * t55;
  t156 = params->C * t155;
  t157 = t149 * t48;
  t160 = t145 * t57;
  t164 = t60 * t55;
  t170 = 0.2e1 * t160 * t4 * t60 - 0.2e1 * t48 * t60 * t61 + t146 * t58 - 0.2e1 * t151 * t164 - t151 * t56 - t153 * t56 + 0.2e1 * t156 * t157;
  t174 = my_piecewise3(t1, 0, t138 * t27 / 0.2e1 + t51 * t65 + t13 * t170 / 0.2e1);
  t176 = my_piecewise5(t10, 0, t7, 0, -t137);
  t180 = t34 * t134;
  t183 = my_piecewise5(t19, 0, t16, 0, 0.2e1 * t48 + 0.2e1 * t180);
  t186 = t183 * t3 + 0.2e1 * t75;
  t187 = params->B * t186;
  t189 = t37 * t37;
  t190 = 0.1e1 / t189;
  t191 = t190 * t4;
  t192 = t191 * t75;
  t194 = t79 * t48;
  t196 = t77 * t77;
  t197 = params->C * t196;
  t198 = t190 * t48;
  t201 = t186 * t79;
  t205 = t82 * t77;
  t211 = 0.2e1 * t201 * t4 * t82 - 0.2e1 * t48 * t82 * t83 + t187 * t80 - 0.2e1 * t192 * t205 - t192 * t78 - t194 * t78 + 0.2e1 * t197 * t198;
  t215 = my_piecewise3(t31, 0, t176 * t43 / 0.2e1 + t71 * t87 + t33 * t211 / 0.2e1);
  tv2rho20 = 0.2e1 * t69 + 0.2e1 * t91 + t3 * (t174 + t215);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t218 = 0.2e1 * t135;
  t219 = my_piecewise5(t7, 0, t10, 0, t218);
  t223 = my_piecewise5(t16, 0, t19, 0, t218);
  t225 = t223 * t3 + t53 + t97;
  t226 = params->B * t225;
  t229 = t100 * t153;
  t230 = params->C * t55;
  t231 = t157 * t99;
  t234 = t225 * t57;
  t238 = t60 * t99;
  t243 = 0.2e1 * t60 * t102 * t48;
  t244 = 0.2e1 * t234 * t4 * t60 - t100 * t151 - 0.2e1 * t151 * t238 + t226 * t58 + 0.2e1 * t230 * t231 - t229 - t243;
  t248 = my_piecewise3(t1, 0, t51 * t106 / 0.2e1 + t13 * t244 / 0.2e1 + t219 * t27 / 0.2e1 + t95 * t65 / 0.2e1);
  t249 = my_piecewise5(t10, 0, t7, 0, -t218);
  t254 = my_piecewise5(t19, 0, t16, 0, 0.2e1 * t180);
  t256 = t254 * t3 + t115 + t75;
  t257 = params->B * t256;
  t260 = t118 * t194;
  t261 = params->C * t77;
  t262 = t198 * t117;
  t265 = t256 * t79;
  t269 = t82 * t117;
  t274 = 0.2e1 * t82 * t120 * t48;
  t275 = 0.2e1 * t265 * t4 * t82 - t118 * t192 - 0.2e1 * t192 * t269 + t257 * t80 + 0.2e1 * t261 * t262 - t260 - t274;
  t279 = my_piecewise3(t31, 0, t112 * t87 / 0.2e1 + t71 * t124 / 0.2e1 + t249 * t43 / 0.2e1 + t33 * t275 / 0.2e1);
  tv2rho21 = t69 + t91 + t110 + t128 + t3 * (t248 + t279);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t285 = 0.2e1 * t48 + 0.2e1 * t135;
  t286 = my_piecewise5(t7, 0, t10, 0, t285);
  t290 = my_piecewise5(t16, 0, t19, 0, t285);
  t293 = t290 * t3 + 0.2e1 * t97;
  t294 = params->B * t293;
  t296 = t150 * t97;
  t298 = t99 * t99;
  t299 = params->C * t298;
  t302 = t293 * t57;
  t308 = 0.2e1 * t302 * t4 * t60 - t100 * t296 + 0.2e1 * t157 * t299 - 0.2e1 * t238 * t296 + t294 * t58 - t229 - t243;
  t312 = my_piecewise3(t1, 0, t286 * t27 / 0.2e1 + t95 * t106 + t13 * t308 / 0.2e1);
  t314 = my_piecewise5(t10, 0, t7, 0, -t285);
  t320 = my_piecewise5(t19, 0, t16, 0, -0.2e1 * t48 + 0.2e1 * t180);
  t323 = t3 * t320 + 0.2e1 * t115;
  t324 = params->B * t323;
  t326 = t191 * t115;
  t328 = t117 * t117;
  t329 = params->C * t328;
  t332 = t323 * t79;
  t338 = 0.2e1 * t332 * t4 * t82 - t118 * t326 + 0.2e1 * t198 * t329 - 0.2e1 * t269 * t326 + t324 * t80 - t260 - t274;
  t342 = my_piecewise3(t31, 0, t314 * t43 / 0.2e1 + t112 * t124 + t33 * t338 / 0.2e1);
  tv2rho22 = 0.2e1 * t110 + 0.2e1 * t128 + t3 * (t312 + t342);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t347 = t47 * t47;
  t348 = 0.1e1 / t347;
  t349 = t2 * t348;
  t351 = 0.6e1 * t134 - 0.6e1 * t349;
  t352 = my_piecewise5(t7, 0, t10, 0, t351);
  t363 = t150 * t142;
  t365 = t57 * t134;
  t372 = 0.1e1 / t148 / t21;
  t373 = t372 * t48;
  t374 = t373 * t53;
  t377 = t149 * t134;
  t380 = my_piecewise5(t16, 0, t19, 0, t351);
  t383 = t3 * t380 + 0.3e1 * t142;
  t384 = t383 * t57;
  t388 = params->B * t383;
  t390 = t372 * t4;
  t391 = t53 * t53;
  t392 = t390 * t391;
  t395 = t157 * t53;
  t402 = t60 * t145;
  t413 = 0.4e1 * t134 * t60 * t61 + 0.6e1 * t145 * t157 * t230 - 0.4e1 * t160 * t48 * t60 + 0.2e1 * t384 * t4 * t60 - 0.2e1 * t146 * t151 - 0.2e1 * t146 * t153 - 0.4e1 * t151 * t402 - 0.6e1 * t156 * t374 - 0.6e1 * t156 * t377 - 0.2e1 * t164 * t363 + 0.4e1 * t164 * t392 + 0.4e1 * t164 * t395 - t363 * t56 + 0.2e1 * t365 * t56 + t388 * t58 + 0.2e1 * t392 * t56 + 0.2e1 * t395 * t56;
  t417 = my_piecewise3(t1, 0, t352 * t27 / 0.2e1 + 0.3e1 / 0.2e1 * t138 * t65 + 0.3e1 / 0.2e1 * t51 * t170 + t13 * t413 / 0.2e1);
  t419 = my_piecewise5(t10, 0, t7, 0, -t351);
  t430 = t191 * t183;
  t432 = t79 * t134;
  t439 = 0.1e1 / t189 / t37;
  t440 = t439 * t48;
  t441 = t440 * t75;
  t444 = t190 * t134;
  t447 = t34 * t348;
  t450 = my_piecewise5(t19, 0, t16, 0, -0.6e1 * t134 - 0.6e1 * t447);
  t453 = t3 * t450 + 0.3e1 * t183;
  t454 = t453 * t79;
  t458 = params->B * t453;
  t460 = t439 * t4;
  t461 = t75 * t75;
  t462 = t460 * t461;
  t465 = t198 * t75;
  t472 = t82 * t186;
  t483 = 0.4e1 * t134 * t82 * t83 + 0.6e1 * t186 * t198 * t261 - 0.4e1 * t201 * t48 * t82 + 0.2e1 * t4 * t454 * t82 - 0.2e1 * t187 * t192 - 0.2e1 * t187 * t194 - 0.4e1 * t192 * t472 - 0.6e1 * t197 * t441 - 0.6e1 * t197 * t444 - 0.2e1 * t205 * t430 + 0.4e1 * t205 * t462 + 0.4e1 * t205 * t465 - t430 * t78 + 0.2e1 * t432 * t78 + t458 * t80 + 0.2e1 * t462 * t78 + 0.2e1 * t465 * t78;
  t487 = my_piecewise3(t31, 0, t419 * t43 / 0.2e1 + 0.3e1 / 0.2e1 * t176 * t87 + 0.3e1 / 0.2e1 * t71 * t211 + t33 * t483 / 0.2e1);
  tv3rho30 = 0.3e1 * t174 + 0.3e1 * t215 + t3 * (t417 + t487);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t490 = 0.2e1 * t248;
  t491 = 0.2e1 * t279;
  t492 = 0.2e1 * t134;
  t493 = 0.6e1 * t349;
  t494 = t492 - t493;
  t495 = my_piecewise5(t7, 0, t10, 0, t494);
  t506 = t226 * t153;
  t510 = 0.2e1 * t100 * t365;
  t511 = params->C * t145;
  t514 = t157 * t225;
  t517 = my_piecewise5(t16, 0, t19, 0, t494);
  t519 = 0.2e1 * t223;
  t520 = t3 * t517 + t142 + t519;
  t521 = t520 * t57;
  t525 = params->B * t520;
  t529 = t238 * t395;
  t533 = t100 * t395;
  t535 = t230 * t372;
  t536 = t48 * t99;
  t537 = t536 * t53;
  t540 = t377 * t99;
  t541 = t230 * t540;
  t543 = t60 * t225;
  t547 = t60 * t234 * t48;
  t553 = 0.4e1 * t60 * t102 * t134;
  t554 = 0.2e1 * t4 * t521 * t60 - t100 * t363 + 0.2e1 * t100 * t392 - 0.2e1 * t151 * t226 - 0.4e1 * t151 * t543 + 0.4e1 * t230 * t514 + 0.2e1 * t231 * t511 - 0.2e1 * t238 * t363 + 0.4e1 * t238 * t392 + t525 * t58 - 0.6e1 * t535 * t537 - 0.2e1 * t506 + t510 + 0.4e1 * t529 + 0.2e1 * t533 - 0.6e1 * t541 - 0.4e1 * t547 + t553;
  t558 = my_piecewise3(t1, 0, t495 * t27 / 0.2e1 + t219 * t65 + t95 * t170 / 0.2e1 + t138 * t106 / 0.2e1 + t51 * t244 + t13 * t554 / 0.2e1);
  t560 = my_piecewise5(t10, 0, t7, 0, -t494);
  t571 = t257 * t194;
  t575 = 0.2e1 * t118 * t432;
  t576 = params->C * t186;
  t579 = t198 * t256;
  t582 = 0.6e1 * t447;
  t584 = my_piecewise5(t19, 0, t16, 0, -t492 - t582);
  t586 = 0.2e1 * t254;
  t587 = t3 * t584 + t183 + t586;
  t588 = t587 * t79;
  t592 = params->B * t587;
  t596 = t269 * t465;
  t600 = t118 * t465;
  t602 = t261 * t439;
  t603 = t48 * t117;
  t604 = t603 * t75;
  t607 = t444 * t117;
  t608 = t261 * t607;
  t610 = t82 * t256;
  t614 = t82 * t265 * t48;
  t620 = 0.4e1 * t82 * t120 * t134;
  t621 = 0.2e1 * t4 * t588 * t82 - t118 * t430 + 0.2e1 * t118 * t462 - 0.2e1 * t192 * t257 - 0.4e1 * t192 * t610 + 0.4e1 * t261 * t579 + 0.2e1 * t262 * t576 - 0.2e1 * t269 * t430 + 0.4e1 * t269 * t462 + t592 * t80 - 0.6e1 * t602 * t604 - 0.2e1 * t571 + t575 + 0.4e1 * t596 + 0.2e1 * t600 - 0.6e1 * t608 - 0.4e1 * t614 + t620;
  t625 = my_piecewise3(t31, 0, t560 * t43 / 0.2e1 + t249 * t87 + t112 * t211 / 0.2e1 + t176 * t124 / 0.2e1 + t71 * t275 + t33 * t621 / 0.2e1);
  tv3rho31 = t174 + t215 + t490 + t491 + t3 * (t558 + t625);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t628 = -t492 - t493;
  t629 = my_piecewise5(t7, 0, t10, 0, t628);
  t640 = t294 * t153;
  t641 = t299 * t377;
  t643 = my_piecewise5(t16, 0, t19, 0, t628);
  t645 = t643 * t3 + t290 + t519;
  t646 = params->B * t645;
  t648 = t97 * t53;
  t649 = t390 * t648;
  t654 = t150 * t223;
  t656 = -t100 * t654 - t294 * t151 - t226 * t296 + 0.4e1 * t238 * t649 + t646 * t58 - t506 + t510 + t533 - 0.2e1 * t541 - 0.2e1 * t547 + t553 - t640 - 0.4e1 * t641;
  t657 = params->C * t99;
  t662 = t645 * t57;
  t666 = t157 * t293;
  t669 = t157 * t97;
  t670 = t100 * t669;
  t672 = t60 * t302 * t48;
  t675 = t536 * t97;
  t678 = t238 * t669;
  t680 = t100 * t372;
  t681 = t4 * t97;
  t682 = t681 * t53;
  t685 = t60 * t293;
  t692 = 0.2e1 * t4 * t60 * t662 - 0.2e1 * t685 * t151 + 0.2e1 * t230 * t666 - 0.2e1 * t238 * t654 - 0.2e1 * t543 * t296 - 0.4e1 * t299 * t374 + 0.4e1 * t657 * t514 - 0.2e1 * t535 * t675 + 0.2e1 * t680 * t682 + 0.2e1 * t529 + t670 - 0.2e1 * t672 + 0.2e1 * t678;
  t693 = t656 + t692;
  t697 = my_piecewise3(t1, 0, t629 * t27 / 0.2e1 + t286 * t65 / 0.2e1 + t219 * t106 + t95 * t244 + t51 * t308 / 0.2e1 + t13 * t693 / 0.2e1);
  t699 = my_piecewise5(t10, 0, t7, 0, -t628);
  t708 = t324 * t194;
  t709 = t329 * t444;
  t712 = my_piecewise5(t19, 0, t16, 0, t492 - t582);
  t714 = t712 * t3 + t320 + t586;
  t715 = params->B * t714;
  t717 = t115 * t75;
  t718 = t460 * t717;
  t725 = t191 * t254;
  t727 = -t118 * t725 - t324 * t192 - t257 * t326 + 0.4e1 * t269 * t718 + t715 * t80 - t571 + t575 + t600 - 0.2e1 * t608 - 0.2e1 * t614 + t620 - t708 - 0.4e1 * t709;
  t728 = params->C * t117;
  t733 = t714 * t79;
  t737 = t198 * t323;
  t740 = t198 * t115;
  t741 = t118 * t740;
  t743 = t82 * t332 * t48;
  t746 = t603 * t115;
  t749 = t269 * t740;
  t751 = t118 * t439;
  t752 = t4 * t115;
  t753 = t752 * t75;
  t756 = t82 * t323;
  t763 = 0.2e1 * t4 * t733 * t82 - 0.2e1 * t756 * t192 + 0.2e1 * t261 * t737 - 0.2e1 * t269 * t725 - 0.2e1 * t610 * t326 - 0.4e1 * t329 * t441 + 0.4e1 * t728 * t579 - 0.2e1 * t602 * t746 + 0.2e1 * t751 * t753 + 0.2e1 * t596 + t741 - 0.2e1 * t743 + 0.2e1 * t749;
  t764 = t727 + t763;
  t768 = my_piecewise3(t31, 0, t699 * t43 / 0.2e1 + t314 * t87 / 0.2e1 + t249 * t124 + t112 * t275 + t71 * t338 / 0.2e1 + t33 * t764 / 0.2e1);
  tv3rho32 = t490 + t491 + t312 + t342 + t3 * (t697 + t768);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t774 = -0.6e1 * t134 - 0.6e1 * t349;
  t775 = my_piecewise5(t7, 0, t10, 0, t774);
  t784 = my_piecewise5(t16, 0, t19, 0, t774);
  t787 = t784 * t3 + 0.3e1 * t290;
  t788 = params->B * t787;
  t791 = t97 * t97;
  t792 = t390 * t791;
  t801 = t150 * t290;
  t812 = t787 * t57;
  t816 = -0.6e1 * t299 * t373 * t97 + 0.2e1 * t4 * t60 * t812 + 0.2e1 * t100 * t792 - t100 * t801 + 0.4e1 * t238 * t792 - 0.2e1 * t238 * t801 - 0.2e1 * t294 * t296 - 0.4e1 * t685 * t296 + t788 * t58 + 0.6e1 * t657 * t666 + t510 + t553 - 0.2e1 * t640 - 0.6e1 * t641 + 0.2e1 * t670 - 0.4e1 * t672 + 0.4e1 * t678;
  t820 = my_piecewise3(t1, 0, t775 * t27 / 0.2e1 + 0.3e1 / 0.2e1 * t286 * t106 + 0.3e1 / 0.2e1 * t95 * t308 + t13 * t816 / 0.2e1);
  t822 = my_piecewise5(t10, 0, t7, 0, -t774);
  t833 = my_piecewise5(t19, 0, t16, 0, 0.6e1 * t134 - 0.6e1 * t447);
  t836 = t833 * t3 + 0.3e1 * t320;
  t837 = params->B * t836;
  t840 = t115 * t115;
  t841 = t460 * t840;
  t850 = t191 * t320;
  t861 = t836 * t79;
  t865 = -0.6e1 * t115 * t329 * t440 + 0.2e1 * t4 * t82 * t861 + 0.2e1 * t118 * t841 - t118 * t850 + 0.4e1 * t269 * t841 - 0.2e1 * t269 * t850 - 0.2e1 * t324 * t326 - 0.4e1 * t756 * t326 + 0.6e1 * t728 * t737 + t837 * t80 + t575 + t620 - 0.2e1 * t708 - 0.6e1 * t709 + 0.2e1 * t741 - 0.4e1 * t743 + 0.4e1 * t749;
  t869 = my_piecewise3(t31, 0, t822 * t43 / 0.2e1 + 0.3e1 / 0.2e1 * t314 * t124 + 0.3e1 / 0.2e1 * t112 * t338 + t33 * t865 / 0.2e1);
  tv3rho33 = 0.3e1 * t312 + 0.3e1 * t342 + t3 * (t820 + t869);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t875 = 0.1e1 / t347 / t3;
  t876 = t2 * t875;
  t878 = -0.24e2 * t348 + 0.24e2 * t876;
  t879 = my_piecewise5(t7, 0, t10, 0, t878);
  t890 = my_piecewise5(t16, 0, t19, 0, t878);
  t893 = t890 * t3 + 0.4e1 * t380;
  t898 = t57 * t348;
  t901 = t145 * t145;
  t905 = t149 * t348;
  t909 = t390 * t53 * t142;
  t916 = t157 * t142;
  t922 = t148 * t148;
  t923 = 0.1e1 / t922;
  t924 = t923 * t48;
  t925 = t924 * t391;
  t928 = t372 * t134;
  t929 = t928 * t53;
  t935 = t923 * t4;
  t937 = t935 * t391 * t53;
  t940 = t373 * t391;
  t949 = -0.3e1 * t388 * t153 + params->B * t893 * t58 + 0.6e1 * t146 * t365 - 0.6e1 * t56 * t898 + 0.6e1 * params->C * t901 * t157 + 0.22e2 * t156 * t905 + 0.12e2 * t164 * t909 + 0.6e1 * t146 * t392 + 0.6e1 * t146 * t395 + 0.3e1 * t56 * t916 - 0.28e2 * t230 * t377 * t145 + 0.22e2 * t156 * t925 + 0.28e2 * t156 * t929 - 0.6e1 * t60 * t384 * t48 - 0.6e1 * t56 * t937 - 0.6e1 * t56 * t940 + 0.12e2 * t60 * t160 * t134 - 0.12e2 * t60 * t61 * t348;
  t954 = t150 * t380;
  t956 = t377 * t53;
  t962 = t373 * t142;
  t977 = t4 * t142 * t53;
  t997 = -0.28e2 * t145 * t48 * t53 * t535 + 0.2e1 * t4 * t57 * t60 * t893 - 0.6e1 * t151 * t383 * t60 + 0.8e1 * t157 * t230 * t383 + 0.6e1 * t372 * t56 * t977 - 0.3e1 * t146 * t363 - 0.3e1 * t388 * t151 - 0.8e1 * t156 * t962 + 0.6e1 * t164 * t916 - 0.12e2 * t164 * t937 - 0.12e2 * t164 * t940 - 0.2e1 * t164 * t954 - 0.12e2 * t164 * t956 - 0.6e1 * t402 * t363 + 0.12e2 * t402 * t392 + 0.12e2 * t402 * t395 - t56 * t954 - 0.6e1 * t56 * t956;
  t1002 = my_piecewise3(t1, 0, t879 * t27 / 0.2e1 + 0.2e1 * t352 * t65 + 0.3e1 * t138 * t170 + 0.2e1 * t51 * t413 + t13 * (t949 + t997) / 0.2e1);
  t1004 = my_piecewise5(t10, 0, t7, 0, -t878);
  t1015 = t34 * t875;
  t1018 = my_piecewise5(t19, 0, t16, 0, 0.24e2 * t348 + 0.24e2 * t1015);
  t1021 = t1018 * t3 + 0.4e1 * t450;
  t1026 = t79 * t348;
  t1029 = t186 * t186;
  t1033 = t190 * t348;
  t1037 = t460 * t75 * t183;
  t1044 = t198 * t183;
  t1050 = t189 * t189;
  t1051 = 0.1e1 / t1050;
  t1052 = t1051 * t48;
  t1053 = t1052 * t461;
  t1056 = t439 * t134;
  t1057 = t1056 * t75;
  t1063 = t1051 * t4;
  t1065 = t1063 * t461 * t75;
  t1068 = t440 * t461;
  t1077 = -0.3e1 * t458 * t194 + params->B * t1021 * t80 + 0.6e1 * t187 * t432 - 0.6e1 * t78 * t1026 + 0.6e1 * params->C * t1029 * t198 + 0.22e2 * t197 * t1033 + 0.12e2 * t205 * t1037 + 0.6e1 * t187 * t462 + 0.6e1 * t187 * t465 + 0.3e1 * t78 * t1044 - 0.28e2 * t261 * t444 * t186 + 0.22e2 * t197 * t1053 + 0.28e2 * t197 * t1057 - 0.6e1 * t82 * t454 * t48 - 0.6e1 * t78 * t1065 - 0.6e1 * t78 * t1068 + 0.12e2 * t82 * t201 * t134 - 0.12e2 * t82 * t83 * t348;
  t1082 = t191 * t450;
  t1084 = t444 * t75;
  t1090 = t440 * t183;
  t1105 = t4 * t183 * t75;
  t1125 = 0.2e1 * t1021 * t4 * t79 * t82 - 0.28e2 * t186 * t48 * t602 * t75 + 0.6e1 * t1105 * t439 * t78 - 0.6e1 * t192 * t453 * t82 + 0.8e1 * t198 * t261 * t453 + 0.6e1 * t205 * t1044 - 0.12e2 * t205 * t1065 - 0.12e2 * t205 * t1068 - 0.2e1 * t205 * t1082 - t78 * t1082 - 0.12e2 * t205 * t1084 - 0.6e1 * t78 * t1084 - 0.8e1 * t197 * t1090 - 0.3e1 * t187 * t430 - 0.3e1 * t458 * t192 - 0.6e1 * t472 * t430 + 0.12e2 * t472 * t462 + 0.12e2 * t472 * t465;
  t1130 = my_piecewise3(t31, 0, t1004 * t43 / 0.2e1 + 0.2e1 * t419 * t87 + 0.3e1 * t176 * t211 + 0.2e1 * t71 * t483 + t33 * (t1077 + t1125) / 0.2e1);
  tv4rho40 = 0.4e1 * t417 + 0.4e1 * t487 + t3 * (t1002 + t1130);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1135 = 0.12e2 * t348;
  t1136 = 0.24e2 * t876;
  t1137 = -t1135 + t1136;
  t1138 = my_piecewise5(t7, 0, t10, 0, t1137);
  t1153 = t525 * t153;
  t1155 = my_piecewise5(t16, 0, t19, 0, t1137);
  t1158 = t1155 * t3 + t380 + 0.3e1 * t517;
  t1161 = t226 * t365;
  t1164 = 0.6e1 * t100 * t898;
  t1169 = t226 * t395;
  t1171 = t100 * t916;
  t1173 = t511 * t540;
  t1175 = t377 * t225;
  t1176 = t230 * t1175;
  t1179 = t60 * t521 * t48;
  t1183 = t100 * t940;
  t1186 = t230 * t905 * t99;
  t1189 = t60 * t234 * t134;
  t1193 = 0.12e2 * t60 * t102 * t348;
  t1199 = t1158 * t58 * params->B - 0.6e1 * t100 * t937 - t100 * t954 - 0.3e1 * t525 * t151 - 0.3e1 * t226 * t363 + 0.6e1 * t226 * t392 + 0.12e2 * t238 * t909 - 0.3e1 * t1153 + 0.6e1 * t1161 - t1164 + 0.6e1 * t1169 + 0.3e1 * t1171 - 0.1e2 * t1173 - 0.18e2 * t1176 - 0.6e1 * t1179 - 0.6e1 * t1183 + 0.22e2 * t1186 + 0.12e2 * t1189 - t1193;
  t1200 = t100 * t956;
  t1207 = t157 * t520;
  t1214 = t230 * t923;
  t1218 = t134 * t99;
  t1220 = t535 * t1218 * t53;
  t1224 = t238 * t940;
  t1226 = t238 * t956;
  t1230 = t511 * t372;
  t1233 = t48 * t225;
  t1234 = t1233 * t53;
  t1237 = t60 * t520;
  t1242 = t543 * t395;
  t1244 = t238 * t916;
  t1253 = -0.6e1 * t1200 + 0.2e1 * params->C * t383 * t231 + 0.6e1 * t511 * t514 + 0.6e1 * t230 * t1207 + 0.2e1 * t60 * t1158 * t57 * t4 + 0.22e2 * t1214 * t536 * t391 + 0.28e2 * t1220 - 0.12e2 * t238 * t937 - 0.12e2 * t1224 - 0.12e2 * t1226 + 0.6e1 * t680 * t977 - 0.1e2 * t1230 * t537 - 0.18e2 * t535 * t1234 - 0.6e1 * t1237 * t151 + 0.12e2 * t543 * t392 + 0.12e2 * t1242 + 0.6e1 * t1244 - 0.8e1 * t535 * t536 * t142 - 0.6e1 * t543 * t363 - 0.2e1 * t238 * t954;
  t1258 = my_piecewise3(t1, 0, t1138 * t27 / 0.2e1 + 0.3e1 / 0.2e1 * t495 * t65 + 0.3e1 / 0.2e1 * t219 * t170 + t95 * t413 / 0.2e1 + t352 * t106 / 0.2e1 + 0.3e1 / 0.2e1 * t138 * t244 + 0.3e1 / 0.2e1 * t51 * t554 + t13 * (t1199 + t1253) / 0.2e1);
  t1260 = my_piecewise5(t10, 0, t7, 0, -t1137);
  t1275 = t592 * t194;
  t1277 = 0.24e2 * t1015;
  t1279 = my_piecewise5(t19, 0, t16, 0, t1135 + t1277);
  t1282 = t1279 * t3 + t450 + 0.3e1 * t584;
  t1285 = t257 * t432;
  t1288 = 0.6e1 * t118 * t1026;
  t1293 = t257 * t465;
  t1295 = t118 * t1044;
  t1297 = t576 * t607;
  t1299 = t444 * t256;
  t1300 = t261 * t1299;
  t1303 = t82 * t588 * t48;
  t1307 = t118 * t1068;
  t1310 = t261 * t1033 * t117;
  t1313 = t82 * t265 * t134;
  t1317 = 0.12e2 * t82 * t120 * t348;
  t1323 = t1282 * t80 * params->B + 0.12e2 * t269 * t1037 - 0.6e1 * t118 * t1065 - t118 * t1082 - 0.3e1 * t592 * t192 - 0.3e1 * t257 * t430 + 0.6e1 * t257 * t462 - 0.3e1 * t1275 + 0.6e1 * t1285 - t1288 + 0.6e1 * t1293 + 0.3e1 * t1295 - 0.1e2 * t1297 - 0.18e2 * t1300 - 0.6e1 * t1303 - 0.6e1 * t1307 + 0.22e2 * t1310 + 0.12e2 * t1313 - t1317;
  t1324 = t118 * t1084;
  t1331 = t198 * t587;
  t1338 = t261 * t1051;
  t1342 = t134 * t117;
  t1344 = t602 * t1342 * t75;
  t1348 = t269 * t1068;
  t1350 = t269 * t1084;
  t1354 = t576 * t439;
  t1357 = t48 * t256;
  t1358 = t1357 * t75;
  t1361 = t82 * t587;
  t1366 = t610 * t465;
  t1368 = t269 * t1044;
  t1377 = -0.6e1 * t1324 + 0.2e1 * params->C * t453 * t262 + 0.6e1 * t576 * t579 + 0.6e1 * t261 * t1331 + 0.2e1 * t82 * t1282 * t79 * t4 + 0.22e2 * t1338 * t603 * t461 + 0.28e2 * t1344 - 0.12e2 * t269 * t1065 - 0.12e2 * t1348 - 0.12e2 * t1350 + 0.6e1 * t751 * t1105 - 0.1e2 * t1354 * t604 - 0.18e2 * t602 * t1358 - 0.6e1 * t1361 * t192 + 0.12e2 * t610 * t462 + 0.12e2 * t1366 + 0.6e1 * t1368 - 0.8e1 * t602 * t603 * t183 - 0.6e1 * t610 * t430 - 0.2e1 * t269 * t1082;
  t1382 = my_piecewise3(t31, 0, t1260 * t43 / 0.2e1 + 0.3e1 / 0.2e1 * t560 * t87 + 0.3e1 / 0.2e1 * t249 * t211 + t112 * t483 / 0.2e1 + t419 * t124 / 0.2e1 + 0.3e1 / 0.2e1 * t176 * t275 + 0.3e1 / 0.2e1 * t71 * t621 + t33 * (t1323 + t1377) / 0.2e1);
  tv4rho41 = t417 + t487 + 0.3e1 * t558 + 0.3e1 * t625 + t3 * (t1258 + t1382);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1389 = my_piecewise5(t7, 0, t10, 0, t1136);
  t1405 = 0.2e1 * t294 * t395;
  t1407 = 0.2e1 * t226 * t669;
  t1408 = t157 * t223;
  t1410 = 0.2e1 * t100 * t1408;
  t1411 = t657 * t1175;
  t1415 = t299 * t929;
  t1419 = 0.4e1 * t60 * t662 * t48;
  t1420 = t377 * t293;
  t1421 = t230 * t1420;
  t1423 = t377 * t97;
  t1424 = t100 * t1423;
  t1427 = t60 * t302 * t134;
  t1435 = t150 * t517;
  t1439 = -t100 * t1435 + 0.4e1 * t657 * t1207 - 0.2e1 * t646 * t151 - 0.2e1 * t226 * t654 - t294 * t363 + 0.2e1 * t294 * t392 - t525 * t296 + 0.12e2 * t299 * t925 + t1405 + t1407 + t1410 - 0.16e2 * t1411 + 0.16e2 * t1415 - t1419 - 0.6e1 * t1421 - 0.2e1 * t1424 + 0.4e1 * t1427;
  t1442 = my_piecewise5(t16, 0, t19, 0, t1136);
  t1446 = t1442 * t3 + 0.2e1 * t517 + 0.2e1 * t643;
  t1454 = t535 * t1218 * t97;
  t1456 = t238 * t1423;
  t1458 = t100 * t923;
  t1463 = t48 * t97 * t53;
  t1465 = 0.4e1 * t680 * t1463;
  t1469 = 0.4e1 * t685 * t395;
  t1477 = t657 * t372;
  t1480 = t60 * t645;
  t1485 = t1233 * t97;
  t1489 = -0.4e1 * t299 * t962 + 0.2e1 * t60 * t1446 * t57 * t4 + 0.2e1 * t511 * t666 + 0.6e1 * t1454 - 0.4e1 * t1456 - 0.6e1 * t1458 * t681 * t391 - t1465 + 0.4e1 * t685 * t392 + t1469 + 0.4e1 * t226 * t372 * t682 + 0.4e1 * t680 * t4 * t223 * t53 - 0.16e2 * t1477 * t1234 - 0.4e1 * t1480 * t151 - 0.2e1 * t1230 * t675 - 0.4e1 * t535 * t1485 - t1153 + 0.4e1 * t1161 - t1164;
  t1492 = 0.2e1 * t646 * t153;
  t1495 = t294 * t365;
  t1497 = t225 * t225;
  t1501 = t299 * t905;
  t1509 = 0.8e1 * t238 * t373 * t648;
  t1526 = t48 * t293;
  t1527 = t1526 * t53;
  t1531 = 0.4e1 * t543 * t669;
  t1533 = 0.4e1 * t238 * t1408;
  t1541 = -t1492 + params->B * t1446 * t58 + 0.2e1 * t1495 + 0.4e1 * params->C * t1497 * t157 + 0.12e2 * t1501 - 0.12e2 * t238 * t935 * t97 * t391 - t1509 + 0.1e2 * t1214 * t536 * t648 + 0.8e1 * t543 * t649 + 0.8e1 * t238 * t390 * t223 * t53 + 0.4e1 * t238 * t390 * t97 * t142 - 0.4e1 * t535 * t536 * t223 - 0.6e1 * t535 * t1527 + t1531 + t1533 + 0.2e1 * t680 * t681 * t142 - 0.2e1 * t685 * t363 - 0.2e1 * t1237 * t296;
  t1559 = t157 * t645;
  t1562 = -0.2e1 * t238 * t1435 + 0.4e1 * t230 * t1559 - 0.4e1 * t543 * t654 + 0.2e1 * t1169 + t1171 - 0.2e1 * t1173 - 0.4e1 * t1176 - 0.2e1 * t1179 - 0.2e1 * t1183 + 0.1e2 * t1186 + 0.8e1 * t1189 - t1193 - 0.4e1 * t1200 + 0.6e1 * t1220 - 0.4e1 * t1224 - 0.8e1 * t1226 + 0.4e1 * t1242 + 0.2e1 * t1244;
  t1568 = my_piecewise3(t1, 0, t1389 * t27 / 0.2e1 + t629 * t65 + t286 * t170 / 0.2e1 + t495 * t106 + 0.2e1 * t219 * t244 + t95 * t554 + t138 * t308 / 0.2e1 + t51 * t693 + t13 * (t1439 + t1489 + t1541 + t1562) / 0.2e1);
  t1569 = my_piecewise5(t10, 0, t7, 0, -t1136);
  t1585 = 0.2e1 * t324 * t465;
  t1587 = 0.2e1 * t257 * t740;
  t1588 = t198 * t254;
  t1590 = 0.2e1 * t118 * t1588;
  t1591 = t728 * t1299;
  t1595 = t329 * t1057;
  t1599 = 0.4e1 * t82 * t733 * t48;
  t1600 = t444 * t323;
  t1601 = t261 * t1600;
  t1603 = t444 * t115;
  t1604 = t118 * t1603;
  t1607 = t82 * t332 * t134;
  t1615 = t191 * t584;
  t1619 = 0.12e2 * t329 * t1053 - t118 * t1615 + 0.4e1 * t728 * t1331 - 0.2e1 * t715 * t192 - 0.2e1 * t257 * t725 - t324 * t430 + 0.2e1 * t324 * t462 - t592 * t326 + t1585 + t1587 + t1590 - 0.16e2 * t1591 + 0.16e2 * t1595 - t1599 - 0.6e1 * t1601 - 0.2e1 * t1604 + 0.4e1 * t1607;
  t1622 = my_piecewise5(t19, 0, t16, 0, t1277);
  t1626 = t1622 * t3 + 0.2e1 * t584 + 0.2e1 * t712;
  t1633 = t198 * t714;
  t1638 = 0.2e1 * t715 * t194;
  t1641 = t324 * t432;
  t1643 = t256 * t256;
  t1647 = t329 * t1033;
  t1655 = 0.8e1 * t269 * t440 * t717;
  t1669 = -0.4e1 * t329 * t1090 + 0.2e1 * t82 * t1626 * t79 * t4 + 0.2e1 * t576 * t737 + 0.4e1 * t261 * t1633 - t1275 + 0.4e1 * t1285 - t1288 - t1638 + params->B * t1626 * t80 + 0.2e1 * t1641 + 0.4e1 * params->C * t1643 * t198 + 0.12e2 * t1647 - 0.12e2 * t269 * t1063 * t115 * t461 - t1655 + 0.1e2 * t1338 * t603 * t717 + 0.8e1 * t610 * t718 + 0.8e1 * t269 * t460 * t254 * t75 + 0.4e1 * t269 * t460 * t115 * t183;
  t1672 = t602 * t1342 * t115;
  t1674 = t269 * t1603;
  t1676 = t118 * t1051;
  t1681 = t48 * t115 * t75;
  t1683 = 0.4e1 * t751 * t1681;
  t1687 = 0.4e1 * t756 * t465;
  t1695 = t728 * t439;
  t1698 = t82 * t714;
  t1703 = t1357 * t115;
  t1709 = t48 * t323;
  t1710 = t1709 * t75;
  t1714 = 0.4e1 * t610 * t740;
  t1716 = 0.4e1 * t269 * t1588;
  t1722 = 0.4e1 * t254 * t4 * t75 * t751 - 0.6e1 * t1676 * t461 * t752 + 0.2e1 * t183 * t751 * t752 - 0.4e1 * t254 * t602 * t603 + 0.4e1 * t257 * t439 * t753 - 0.2e1 * t1354 * t746 - 0.16e2 * t1695 * t1358 - 0.4e1 * t1698 * t192 - 0.4e1 * t602 * t1703 - 0.6e1 * t602 * t1710 - 0.2e1 * t756 * t430 + 0.4e1 * t756 * t462 + 0.6e1 * t1672 - 0.4e1 * t1674 - t1683 + t1687 + t1714 + t1716;
  t1742 = -0.2e1 * t1361 * t326 - 0.2e1 * t269 * t1615 - 0.4e1 * t610 * t725 + 0.2e1 * t1293 + t1295 - 0.2e1 * t1297 - 0.4e1 * t1300 - 0.2e1 * t1303 - 0.2e1 * t1307 + 0.1e2 * t1310 + 0.8e1 * t1313 - t1317 - 0.4e1 * t1324 + 0.6e1 * t1344 - 0.4e1 * t1348 - 0.8e1 * t1350 + 0.4e1 * t1366 + 0.2e1 * t1368;
  t1748 = my_piecewise3(t31, 0, t1569 * t43 / 0.2e1 + t699 * t87 + t314 * t211 / 0.2e1 + t560 * t124 + 0.2e1 * t249 * t275 + t112 * t621 + t176 * t338 / 0.2e1 + t71 * t764 + t33 * (t1619 + t1669 + t1722 + t1742) / 0.2e1);
  tv4rho42 = 0.2e1 * t558 + 0.2e1 * t625 + 0.2e1 * t697 + 0.2e1 * t768 + t3 * (t1568 + t1748);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1753 = t1135 + t1136;
  t1754 = my_piecewise5(t7, 0, t10, 0, t1753);
  t1777 = t150 * t643;
  t1787 = my_piecewise5(t16, 0, t19, 0, t1753);
  t1790 = t1787 * t3 + 0.3e1 * t643 + t784;
  t1795 = t157 * t787;
  t1798 = t373 * t791;
  t1799 = t100 * t1798;
  t1801 = t294 * t669;
  t1803 = t157 * t290;
  t1804 = t100 * t1803;
  t1805 = t657 * t1420;
  t1808 = t299 * t928 * t97;
  t1811 = t60 * t812 * t48;
  t1813 = -t788 * t151 + 0.2e1 * t226 * t792 - 0.2e1 * t646 * t296 - 0.2e1 * t294 * t654 - t226 * t801 - t100 * t1777 + 0.6e1 * params->C * t225 * t666 + 0.6e1 * t657 * t1559 - 0.6e1 * t299 * t373 * t223 + 0.2e1 * t60 * t1790 * t57 * t4 + 0.2e1 * t230 * t1795 - 0.2e1 * t1799 + 0.2e1 * t1801 + t1804 - 0.12e2 * t1805 + 0.12e2 * t1808 - 0.2e1 * t1811;
  t1835 = 0.8e1 * t223 * t238 * t390 * t97 + 0.4e1 * t238 * t290 * t390 * t53 - 0.12e2 * t238 * t53 * t791 * t935 + 0.8e1 * t685 * t649 + t1405 + t1407 + t1410 - 0.12e2 * t1411 + 0.12e2 * t1415 - t1419 - 0.4e1 * t1421 - 0.4e1 * t1424 + 0.8e1 * t1427 + 0.4e1 * t1454 - 0.8e1 * t1456 - t1465 + t1469;
  t1842 = t788 * t153;
  t1846 = t1526 * t97;
  t1852 = t238 * t1798;
  t1854 = t685 * t669;
  t1856 = t238 * t1803;
  t1860 = 0.4e1 * t1214 * t536 * t791 + t1790 * t58 * params->B - 0.2e1 * t290 * t535 * t536 - 0.4e1 * t535 * t1846 + 0.4e1 * t543 * t792 + 0.2e1 * t1161 - t1164 - t1492 + 0.4e1 * t1495 + 0.18e2 * t1501 - t1509 + t1531 + t1533 - t1842 - 0.4e1 * t1852 + 0.4e1 * t1854 + 0.2e1 * t1856;
  t1890 = t60 * t787;
  t1897 = -0.6e1 * t1458 * t4 * t791 * t53 + 0.4e1 * t680 * t681 * t223 - 0.4e1 * t1480 * t296 - 0.4e1 * t685 * t654 - 0.2e1 * t543 * t801 - 0.2e1 * t238 * t1777 + 0.4e1 * t294 * t372 * t682 + 0.2e1 * t680 * t4 * t290 * t53 - 0.12e2 * t1477 * t1527 - 0.12e2 * t1477 * t1485 + 0.18e2 * t299 * t923 * t1463 - 0.2e1 * t1890 * t151 + 0.4e1 * t1186 + 0.4e1 * t1189 - t1193 - 0.2e1 * t1200 - 0.4e1 * t1226;
  t1903 = my_piecewise3(t1, 0, t1754 * t27 / 0.2e1 + t775 * t65 / 0.2e1 + 0.3e1 / 0.2e1 * t629 * t106 + 0.3e1 / 0.2e1 * t286 * t244 + 0.3e1 / 0.2e1 * t219 * t308 + 0.3e1 / 0.2e1 * t95 * t693 + t51 * t816 / 0.2e1 + t13 * (t1813 + t1835 + t1860 + t1897) / 0.2e1);
  t1905 = my_piecewise5(t10, 0, t7, 0, -t1753);
  t1920 = t198 * t836;
  t1923 = t440 * t840;
  t1924 = t118 * t1923;
  t1926 = t324 * t740;
  t1928 = t198 * t320;
  t1929 = t118 * t1928;
  t1930 = t728 * t1600;
  t1933 = t329 * t1056 * t115;
  t1936 = t82 * t861 * t48;
  t1946 = t191 * t712;
  t1957 = my_piecewise5(t19, 0, t16, 0, -t1135 + t1277);
  t1960 = t1957 * t3 + 0.3e1 * t712 + t833;
  t1965 = 0.2e1 * t261 * t1920 - 0.2e1 * t1924 + 0.2e1 * t1926 + t1929 - 0.12e2 * t1930 + 0.12e2 * t1933 - 0.2e1 * t1936 - t837 * t192 + 0.2e1 * t257 * t841 - 0.2e1 * t715 * t326 - 0.2e1 * t324 * t725 - t257 * t850 - t118 * t1946 + 0.6e1 * params->C * t256 * t737 + 0.6e1 * t728 * t1633 - 0.6e1 * t329 * t440 * t254 + 0.2e1 * t82 * t1960 * t79 * t4;
  t1976 = t837 * t194;
  t1981 = -0.12e2 * t1063 * t269 * t75 * t840 + t1960 * t80 * params->B + 0.2e1 * t1285 - t1288 + t1585 + t1587 + t1590 - 0.12e2 * t1591 + 0.12e2 * t1595 - t1599 - 0.4e1 * t1601 - 0.4e1 * t1604 + 0.8e1 * t1607 - t1638 + 0.4e1 * t1641 + 0.18e2 * t1647 - t1976;
  t1998 = t1709 * t115;
  t2004 = t269 * t1923;
  t2006 = t756 * t740;
  t2008 = t269 * t1928;
  t2012 = 0.8e1 * t115 * t254 * t269 * t460 + 0.4e1 * t269 * t320 * t460 * t75 + 0.4e1 * t1338 * t603 * t840 - 0.2e1 * t320 * t602 * t603 - 0.4e1 * t602 * t1998 + 0.4e1 * t610 * t841 + 0.8e1 * t756 * t718 - t1655 + 0.4e1 * t1672 - 0.8e1 * t1674 - t1683 + t1687 + t1714 + t1716 - 0.4e1 * t2004 + 0.4e1 * t2006 + 0.2e1 * t2008;
  t2042 = t82 * t836;
  t2049 = -0.6e1 * t1676 * t4 * t840 * t75 + 0.4e1 * t751 * t752 * t254 - 0.4e1 * t1698 * t326 - 0.4e1 * t756 * t725 - 0.2e1 * t610 * t850 - 0.2e1 * t269 * t1946 + 0.4e1 * t324 * t439 * t753 + 0.2e1 * t751 * t4 * t320 * t75 - 0.12e2 * t1695 * t1710 - 0.12e2 * t1695 * t1703 + 0.18e2 * t329 * t1051 * t1681 - 0.2e1 * t2042 * t192 + 0.4e1 * t1310 + 0.4e1 * t1313 - t1317 - 0.2e1 * t1324 - 0.4e1 * t1350;
  t2055 = my_piecewise3(t31, 0, t1905 * t43 / 0.2e1 + t822 * t87 / 0.2e1 + 0.3e1 / 0.2e1 * t699 * t124 + 0.3e1 / 0.2e1 * t314 * t275 + 0.3e1 / 0.2e1 * t249 * t338 + 0.3e1 / 0.2e1 * t112 * t764 + t71 * t865 / 0.2e1 + t33 * (t1965 + t1981 + t2012 + t2049) / 0.2e1);
  tv4rho43 = 0.3e1 * t697 + 0.3e1 * t768 + t820 + t869 + t3 * (t1903 + t2055);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t2061 = 0.24e2 * t348 + 0.24e2 * t876;
  t2062 = my_piecewise5(t7, 0, t10, 0, t2061);
  t2078 = t935 * t791 * t97;
  t2087 = t150 * t784;
  t2091 = my_piecewise5(t16, 0, t19, 0, t2061);
  t2094 = t2091 * t3 + 0.4e1 * t784;
  t2108 = 0.2e1 * t2094 * t4 * t57 * t60 - 0.8e1 * t290 * t299 * t373 + 0.22e2 * t299 * t791 * t924 - 0.6e1 * t100 * t2078 - t100 * t2087 + 0.8e1 * t657 * t1795 + 0.6e1 * t294 * t792 - 0.3e1 * t294 * t801 - 0.3e1 * t788 * t296 - 0.6e1 * t1424 + 0.12e2 * t1427 - 0.12e2 * t1456 - 0.6e1 * t1799 + 0.6e1 * t1801 + 0.3e1 * t1804 - 0.28e2 * t1805 + 0.28e2 * t1808 - 0.6e1 * t1811;
  t2114 = t293 * t293;
  t2140 = 0.12e2 * t238 * t290 * t390 * t97 + 0.6e1 * t157 * t2114 * params->C + t2094 * t58 * params->B + 0.6e1 * t290 * t680 * t681 - 0.28e2 * t1477 * t1846 - 0.6e1 * t1890 * t296 - 0.12e2 * t238 * t2078 - 0.2e1 * t238 * t2087 + 0.12e2 * t685 * t792 - 0.6e1 * t685 * t801 - t1164 - t1193 + 0.6e1 * t1495 + 0.22e2 * t1501 - 0.3e1 * t1842 - 0.12e2 * t1852 + 0.12e2 * t1854 + 0.6e1 * t1856;
  t2145 = my_piecewise3(t1, 0, t2062 * t27 / 0.2e1 + 0.2e1 * t775 * t106 + 0.3e1 * t286 * t308 + 0.2e1 * t95 * t816 + t13 * (t2108 + t2140) / 0.2e1);
  t2147 = my_piecewise5(t10, 0, t7, 0, -t2061);
  t2168 = t191 * t833;
  t2174 = my_piecewise5(t19, 0, t16, 0, -0.24e2 * t348 + 0.24e2 * t1015);
  t2177 = t2174 * t3 + 0.4e1 * t833;
  t2183 = t1063 * t840 * t115;
  t2194 = 0.2e1 * t2177 * t4 * t79 * t82 + 0.22e2 * t1052 * t329 * t840 - 0.8e1 * t320 * t329 * t440 - t118 * t2168 - 0.6e1 * t118 * t2183 + 0.8e1 * t728 * t1920 + 0.6e1 * t324 * t841 - 0.3e1 * t324 * t850 - 0.3e1 * t837 * t326 - t1288 - 0.6e1 * t1604 + 0.12e2 * t1607 - 0.6e1 * t1924 + 0.6e1 * t1926 + 0.3e1 * t1929 - 0.28e2 * t1930 + 0.28e2 * t1933 - 0.6e1 * t1936;
  t2200 = t323 * t323;
  t2227 = 0.12e2 * t115 * t269 * t320 * t460 + 0.6e1 * t198 * t2200 * params->C + t2177 * t80 * params->B + 0.6e1 * t320 * t751 * t752 - 0.28e2 * t1695 * t1998 - 0.6e1 * t2042 * t326 - 0.2e1 * t269 * t2168 - 0.12e2 * t269 * t2183 + 0.12e2 * t756 * t841 - 0.6e1 * t756 * t850 - t1317 + 0.6e1 * t1641 + 0.22e2 * t1647 - 0.12e2 * t1674 - 0.3e1 * t1976 - 0.12e2 * t2004 + 0.12e2 * t2006 + 0.6e1 * t2008;
  t2232 = my_piecewise3(t31, 0, t2147 * t43 / 0.2e1 + 0.2e1 * t822 * t124 + 0.3e1 * t314 * t338 + 0.2e1 * t112 * t865 + t33 * (t2194 + t2227) / 0.2e1);
  tv4rho44 = 0.4e1 * t820 + 0.4e1 * t869 + t3 * (t2145 + t2232);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

