[comment {-*- tcl -*- doctools}]
[vset FORMATNAME bmp]
[vset FORMATFULLNAME {Windows bitmap format}]
[manpage_begin img-[vset FORMATNAME] n 2.1]

[include format-header.inc]

This handler provides new additional configuration options. See
section [sectref {Options}] for more detailed explanations.

[include format-middle.inc]

In addition the value of option [option -format] is treated as a list and may
contain any of the special options listed in section [sectref {Options}].

[include format-package.inc]


[section {Notes}]

[list_begin enum]
[enum]
Chapter [emph "Image Metadata"] of the [package Img] manual page
describes the parameters of the resolution related options.

[list_end]


[section {Options}]

The handler provides the following options:

[list_begin definitions]

[def "[option -verbose] [arg bool]"]

This option is supported for reading and writing. Available since version 2.0.
[para]
If set to [const true], additional information about the read or written image
is printed to stdout. Default is [const false].


[def "[option -resolution] [arg xres] [opt [arg yres]]"]

This option is supported for writing only. Available since version 2.0.
An incompatible version of this option was introduced in version 1.4.1.
[para]

Set the resolution values of the written image file.
If [arg yres] is not specified, it is set to the value of [arg xres].
[para]
If option is not specified, the [emph DPI] and [emph aspect] values of the metadata dictionary are written.
If no metadata values are available, no resolution values are written.


[def "[option -xresolution] [arg xres]"]

This option is supported for writing only. Available since version 2.0.
[para]

Set the horizontal resolution value of the written image file. 


[def "[option -yresolution] [arg yres]"]

This option is supported for writing only. Available since version 2.0.
[para]

Set the vertical resolution value of the written image file.

[list_end]

[include format-footer.inc]
