package PDF::Builder::Resource::Font::CoreFont::courier;

use strict;
use warnings;

our $VERSION = '3.025'; # VERSION
our $LAST_UPDATE = '3.019'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::courier - font-specific information for regular Courier font

=cut

sub data { return {
    'fontname' => 'Courier',
    'type' => 'Type1',
    'apiname' => 'Cour',
    'ascender' => '629',
    'capheight' => '562',
    'descender' => '-157',
    'iscore' => '1',
    'isfixedpitch' => '1',
    'italicangle' => '0',
    'missingwidth' => '600',
   #'stdhw' => '**',
   #'stdvw' => '**',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '426',
    'firstchar' => '32',
    'lastchar' => '255',
    'fontbbox' => [-23, -250, 715, 805],
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
# source: \Windows\Fonts\cour.ttf
# font underline position = -477
# CIDs 0 .. 3762 to be output
# fontbbox = (-121 -679 622 1020)
    'wx' => { # HORIZ. WIDTH TABLE
        'A'       => 600,
        'AE'       => 600,
        'AEacute'       => 600,
        'AEmacron'       => 600,
        'Aacute'       => 600,
        'Abreve'       => 600,
        'Abreveacute'       => 600,
        'Abrevecyrillic'       => 600,
        'Abrevedotbelow'       => 600,
        'Abrevegrave'       => 600,
        'Abrevehookabove'       => 600,
        'Abrevetilde'       => 600,
        'Acaron'       => 600,
        'Acircumflex'       => 600,
        'Acircumflexacute'       => 600,
        'Acircumflexdotbelow'       => 600,
        'Acircumflexgrave'       => 600,
        'Acircumflexhookabove'       => 600,
        'Acircumflextilde'       => 600,
        'Adblgrave'       => 600,
        'Adieresis'       => 600,
        'Adieresiscyrillic'       => 600,
        'Adieresismacron'       => 600,
        'Adotbelow'       => 600,
        'Adotmacron'       => 600,
        'Agrave'       => 600,
        'Ahookabove'       => 600,
        'Aiecyrillic'       => 600,
        'Ainvertedbreve'       => 600,
        'Alpha'       => 600,
        'Alphatonos'       => 600,
        'Amacron'       => 600,
        'Aogonek'       => 600,
        'Aring'       => 600,
        'Aringacute'       => 600,
        'Aringbelow'       => 600,
        'Atilde'       => 600,
        'Aybarmenian'       => 600,
        'B'       => 600,
        'Bdotaccent'       => 600,
        'Bdotbelow'       => 600,
        'Benarmenian'       => 600,
        'Beta'       => 600,
        'Bhook'       => 600,
        'Blinebelow'       => 600,
        'Btopbar'       => 600,
        'C'       => 600,
        'Caarmenian'       => 600,
        'Cacute'       => 600,
        'Ccaron'       => 600,
        'Ccedilla'       => 600,
        'Ccedillaacute'       => 600,
        'Ccircumflex'       => 600,
        'Cdotaccent'       => 600,
        'Chaarmenian'       => 600,
        'Cheabkhasiancyrillic'       => 600,
        'Chedescenderabkhasiancyrillic'       => 600,
        'Chedescendercyrillic'       => 600,
        'Chedieresiscyrillic'       => 600,
        'Cheharmenian'       => 600,
        'Chekhakassiancyrillic'       => 600,
        'Cheverticalstrokecyrillic'       => 600,
        'Chi'       => 600,
        'Chook'       => 600,
        'Coarmenian'       => 600,
        'D'       => 600,
        'DZ'       => 600,
        'DZcaron'       => 600,
        'Daarmenian'       => 600,
        'Dafrican'       => 600,
        'Dcaron'       => 600,
        'Dcedilla'       => 600,
        'Dcircumflexbelow'       => 600,
        'Dcroat'       => 600,
        'Ddotaccent'       => 600,
        'Ddotbelow'       => 600,
        'Deicoptic'       => 600,
        'Delta'       => 600,
        'Dhook'       => 600,
        'Digammagreek'       => 600,
        'Dlinebelow'       => 600,
        'Dtopbar'       => 600,
        'Dz'       => 600,
        'Dzcaron'       => 600,
        'Dzeabkhasiancyrillic'       => 600,
        'E'       => 600,
        'Eacute'       => 600,
        'Ebreve'       => 600,
        'Ecaron'       => 600,
        'Ecedillabreve'       => 600,
        'Echarmenian'       => 600,
        'Ecircumflex'       => 600,
        'Ecircumflexacute'       => 600,
        'Ecircumflexbelow'       => 600,
        'Ecircumflexdotbelow'       => 600,
        'Ecircumflexgrave'       => 600,
        'Ecircumflexhookabove'       => 600,
        'Ecircumflextilde'       => 600,
        'Edblgrave'       => 600,
        'Edieresis'       => 600,
        'Edotaccent'       => 600,
        'Edotbelow'       => 600,
        'Egrave'       => 600,
        'Eharmenian'       => 600,
        'Ehookabove'       => 600,
        'Einvertedbreve'       => 600,
        'Eiotifiedcyrillic'       => 600,
        'Emacron'       => 600,
        'Emacronacute'       => 600,
        'Emacrongrave'       => 600,
        'Endescendercyrillic'       => 600,
        'Eng'       => 600,
        'Enghecyrillic'       => 600,
        'Enhookcyrillic'       => 600,
        'Eogonek'       => 600,
        'Eopen'       => 600,
        'Epsilon'       => 600,
        'Epsilontonos'       => 600,
        'Ereversed'       => 600,
        'Esdescendercyrillic'       => 600,
        'Esh'       => 600,
        'Eta'       => 600,
        'Etarmenian'       => 600,
        'Etatonos'       => 600,
        'Eth'       => 600,
        'Etilde'       => 600,
        'Etildebelow'       => 600,
        'Euro'       => 600,
        'Ezh'       => 600,
        'Ezhcaron'       => 600,
        'Ezhreversed'       => 600,
        'F'       => 600,
        'Fdotaccent'       => 600,
        'Feharmenian'       => 600,
        'Feicoptic'       => 600,
        'Fhook'       => 600,
        'G'       => 600,
        'Gacute'       => 600,
        'Gamma'       => 600,
        'Gammaafrican'       => 600,
        'Gangiacoptic'       => 600,
        'Gbreve'       => 600,
        'Gcaron'       => 600,
        'Gcircumflex'       => 600,
        'Gcommaaccent'       => 600,
        'Gdotaccent'       => 600,
        'Ghadarmenian'       => 600,
        'Ghemiddlehookcyrillic'       => 600,
        'Ghestrokecyrillic'       => 600,
        'Ghook'       => 600,
        'Gimarmenian'       => 600,
        'Gmacron'       => 600,
        'Gsmallhook'       => 600,
        'Gstroke'       => 600,
        'H'       => 600,
        'H18533'       => 600,
        'H18543'       => 600,
        'H18551'       => 600,
        'H22073'       => 600,
        'Haabkhasiancyrillic'       => 600,
        'Hadescendercyrillic'       => 600,
        'Hbar'       => 600,
        'Hbrevebelow'       => 600,
        'Hcedilla'       => 600,
        'Hcircumflex'       => 600,
        'Hdieresis'       => 600,
        'Hdotaccent'       => 600,
        'Hdotbelow'       => 600,
        'Hoarmenian'       => 600,
        'Horicoptic'       => 600,
        'I'       => 600,
        'IJ'       => 600,
        'Iacute'       => 600,
        'Ibreve'       => 600,
        'Icaron'       => 600,
        'Icircumflex'       => 600,
        'Idblgrave'       => 600,
        'Idieresis'       => 600,
        'Idieresisacute'       => 600,
        'Idieresiscyrillic'       => 600,
        'Idotaccent'       => 600,
        'Idotbelow'       => 600,
        'Iebrevecyrillic'       => 600,
        'Igrave'       => 600,
        'Ihookabove'       => 600,
        'Iinvertedbreve'       => 600,
        'Imacron'       => 600,
        'Imacroncyrillic'       => 600,
        'Iniarmenian'       => 600,
        'Iogonek'       => 600,
        'Iota'       => 600,
        'Iotaafrican'       => 600,
        'Iotadieresis'       => 600,
        'Iotatonos'       => 600,
        'Istroke'       => 600,
        'Itilde'       => 600,
        'Itildebelow'       => 600,
        'Izhitsadblgravecyrillic'       => 600,
        'J'       => 600,
        'Jaarmenian'       => 600,
        'Jcircumflex'       => 600,
        'Jheharmenian'       => 600,
        'K'       => 600,
        'Kabashkircyrillic'       => 600,
        'Kacute'       => 600,
        'Kadescendercyrillic'       => 600,
        'Kahookcyrillic'       => 600,
        'Kappa'       => 600,
        'Kastrokecyrillic'       => 600,
        'Kaverticalstrokecyrillic'       => 600,
        'Kcaron'       => 600,
        'Kcommaaccent'       => 600,
        'Kdotbelow'       => 600,
        'Keharmenian'       => 600,
        'Kenarmenian'       => 600,
        'Kheicoptic'       => 600,
        'Khook'       => 600,
        'Klinebelow'       => 600,
        'Koppacyrillic'       => 600,
        'Koppagreek'       => 600,
        'Ksicyrillic'       => 600,
        'L'       => 600,
        'LJ'       => 600,
        'Lacute'       => 600,
        'Lambda'       => 600,
        'Lcaron'       => 600,
        'Lcircumflexbelow'       => 600,
        'Lcommaaccent'       => 600,
        'Ldot'       => 600,
        'Ldotbelow'       => 600,
        'Ldotbelowmacron'       => 600,
        'Liwnarmenian'       => 600,
        'Lj'       => 600,
        'Llinebelow'       => 600,
        'Lslash'       => 600,
        'M'       => 600,
        'Macute'       => 600,
        'Mdotaccent'       => 600,
        'Mdotbelow'       => 600,
        'Menarmenian'       => 600,
        'Mturned'       => 600,
        'Mu'       => 600,
        'N'       => 600,
        'NJ'       => 600,
        'Nacute'       => 600,
        'Ncaron'       => 600,
        'Ncircumflexbelow'       => 600,
        'Ncommaaccent'       => 600,
        'Ndotaccent'       => 600,
        'Ndotbelow'       => 600,
        'Nhookleft'       => 600,
        'Nj'       => 600,
        'Nlinebelow'       => 600,
        'Nowarmenian'       => 600,
        'Ntilde'       => 600,
        'Nu'       => 600,
        'O'       => 600,
        'OE'       => 600,
        'Oacute'       => 600,
        'Obarredcyrillic'       => 600,
        'Obarreddieresiscyrillic'       => 600,
        'Obreve'       => 600,
        'Ocaron'       => 600,
        'Ocenteredtilde'       => 600,
        'Ocircumflex'       => 600,
        'Ocircumflexacute'       => 600,
        'Ocircumflexdotbelow'       => 600,
        'Ocircumflexgrave'       => 600,
        'Ocircumflexhookabove'       => 600,
        'Ocircumflextilde'       => 600,
        'Odblgrave'       => 600,
        'Odieresis'       => 600,
        'Odieresiscyrillic'       => 600,
        'Odotbelow'       => 600,
        'Ograve'       => 600,
        'Oharmenian'       => 600,
        'Ohookabove'       => 600,
        'Ohorn'       => 600,
        'Ohornacute'       => 600,
        'Ohorndotbelow'       => 600,
        'Ohorngrave'       => 600,
        'Ohornhookabove'       => 600,
        'Ohorntilde'       => 600,
        'Ohungarumlaut'       => 600,
        'Oi'       => 600,
        'Oinvertedbreve'       => 600,
        'Omacron'       => 600,
        'Omacronacute'       => 600,
        'Omacrongrave'       => 600,
        'Omega'       => 600,
        'Omegacyrillic'       => 600,
        'Omegaroundcyrillic'       => 600,
        'Omegatitlocyrillic'       => 600,
        'Omegatonos'       => 600,
        'Omicron'       => 600,
        'Omicrontonos'       => 600,
        'Oogonek'       => 600,
        'Oogonekmacron'       => 600,
        'Oopen'       => 600,
        'Oslash'       => 600,
        'Oslashacute'       => 600,
        'Otcyrillic'       => 600,
        'Otilde'       => 600,
        'Otildeacute'       => 600,
        'Otildedieresis'       => 600,
        'P'       => 600,
        'Pacute'       => 600,
        'Pdotaccent'       => 600,
        'Peharmenian'       => 600,
        'Pemiddlehookcyrillic'       => 600,
        'Phi'       => 600,
        'Phook'       => 600,
        'Pi'       => 600,
        'Piwrarmenian'       => 600,
        'Psi'       => 600,
        'Psicyrillic'       => 600,
        'Q'       => 600,
        'R'       => 600,
        'Raarmenian'       => 600,
        'Racute'       => 600,
        'Rcaron'       => 600,
        'Rcommaaccent'       => 600,
        'Rdblgrave'       => 600,
        'Rdotaccent'       => 600,
        'Rdotbelow'       => 600,
        'Rdotbelowmacron'       => 600,
        'Reharmenian'       => 600,
        'Rho'       => 600,
        'Rinvertedbreve'       => 600,
        'Rlinebelow'       => 600,
        'Rsmallinverted'       => 600,
        'Rsmallinvertedsuperior'       => 600,
        'S'       => 600,
        'SF010000'       => 600,
        'SF020000'       => 600,
        'SF030000'       => 600,
        'SF040000'       => 600,
        'SF050000'       => 600,
        'SF060000'       => 600,
        'SF070000'       => 600,
        'SF080000'       => 600,
        'SF090000'       => 600,
        'SF100000'       => 600,
        'SF110000'       => 600,
        'SF190000'       => 600,
        'SF200000'       => 600,
        'SF210000'       => 600,
        'SF220000'       => 600,
        'SF230000'       => 600,
        'SF240000'       => 600,
        'SF250000'       => 600,
        'SF260000'       => 600,
        'SF270000'       => 600,
        'SF280000'       => 600,
        'SF360000'       => 600,
        'SF370000'       => 600,
        'SF380000'       => 600,
        'SF390000'       => 600,
        'SF400000'       => 600,
        'SF410000'       => 600,
        'SF420000'       => 600,
        'SF430000'       => 600,
        'SF440000'       => 600,
        'SF450000'       => 600,
        'SF460000'       => 600,
        'SF470000'       => 600,
        'SF480000'       => 600,
        'SF490000'       => 600,
        'SF500000'       => 600,
        'SF510000'       => 600,
        'SF520000'       => 600,
        'SF530000'       => 600,
        'SF540000'       => 600,
        'Sacute'       => 600,
        'Sacutedotaccent'       => 600,
        'Sampigreek'       => 600,
        'Scaron'       => 600,
        'Scarondotaccent'       => 600,
        'Scedilla'       => 600,
        'Schwacyrillic'       => 600,
        'Schwadieresiscyrillic'       => 600,
        'Scircumflex'       => 600,
        'Scommaaccent'       => 600,
        'Sdotaccent'       => 600,
        'Sdotbelow'       => 600,
        'Sdotbelowdotaccent'       => 600,
        'Seharmenian'       => 600,
        'Shaarmenian'       => 600,
        'Sheicoptic'       => 600,
        'Shhacyrillic'       => 600,
        'Shimacoptic'       => 600,
        'Sigma'       => 600,
        'Stigmagreek'       => 600,
        'T'       => 600,
        'Tau'       => 600,
        'Tbar'       => 600,
        'Tcaron'       => 600,
        'Tcedilla'       => 600,
        'Tcircumflexbelow'       => 600,
        'Tcommaaccent'       => 600,
        'Tdotaccent'       => 600,
        'Tdotbelow'       => 600,
        'Tedescendercyrillic'       => 600,
        'Tetsecyrillic'       => 600,
        'Theta'       => 600,
        'Thook'       => 600,
        'Thorn'       => 600,
        'Tiwnarmenian'       => 600,
        'Tlinebelow'       => 600,
        'Toarmenian'       => 600,
        'Tonefive'       => 600,
        'Tonesix'       => 600,
        'Tonetwo'       => 600,
        'Tretroflexhook'       => 600,
        'U'       => 600,
        'Uacute'       => 600,
        'Ubreve'       => 600,
        'Ucaron'       => 600,
        'Ucircumflex'       => 600,
        'Ucircumflexbelow'       => 600,
        'Udblgrave'       => 600,
        'Udieresis'       => 600,
        'Udieresisacute'       => 600,
        'Udieresisbelow'       => 600,
        'Udieresiscaron'       => 600,
        'Udieresiscyrillic'       => 600,
        'Udieresisgrave'       => 600,
        'Udieresismacron'       => 600,
        'Udotbelow'       => 600,
        'Ugrave'       => 600,
        'Uhookabove'       => 600,
        'Uhorn'       => 600,
        'Uhornacute'       => 600,
        'Uhorndotbelow'       => 600,
        'Uhorngrave'       => 600,
        'Uhornhookabove'       => 600,
        'Uhorntilde'       => 600,
        'Uhungarumlaut'       => 600,
        'Uhungarumlautcyrillic'       => 600,
        'Uinvertedbreve'       => 600,
        'Ukcyrillic'       => 600,
        'Umacron'       => 600,
        'Umacroncyrillic'       => 600,
        'Umacrondieresis'       => 600,
        'Uogonek'       => 600,
        'Upsilon'       => 600,
        'Upsilon1'       => 600,
        'Upsilonacutehooksymbolgreek'       => 600,
        'Upsilonafrican'       => 600,
        'Upsilondieresis'       => 600,
        'Upsilondieresishooksymbolgreek'       => 600,
        'Upsilontonos'       => 600,
        'Uring'       => 600,
        'Ustraightcyrillic'       => 600,
        'Ustraightstrokecyrillic'       => 600,
        'Utilde'       => 600,
        'Utildeacute'       => 600,
        'Utildebelow'       => 600,
        'V'       => 600,
        'Vdotbelow'       => 600,
        'Vewarmenian'       => 600,
        'Vhook'       => 600,
        'Voarmenian'       => 600,
        'Vtilde'       => 600,
        'W'       => 600,
        'Wacute'       => 600,
        'Wcircumflex'       => 600,
        'Wdieresis'       => 600,
        'Wdotaccent'       => 600,
        'Wdotbelow'       => 600,
        'Wgrave'       => 600,
        'X'       => 600,
        'Xdieresis'       => 600,
        'Xdotaccent'       => 600,
        'Xeharmenian'       => 600,
        'Xi'       => 600,
        'Y'       => 600,
        'Yacute'       => 600,
        'Ycircumflex'       => 600,
        'Ydieresis'       => 600,
        'Ydotaccent'       => 600,
        'Ydotbelow'       => 600,
        'Yerudieresiscyrillic'       => 600,
        'Ygrave'       => 600,
        'Yhook'       => 600,
        'Yhookabove'       => 600,
        'Yiarmenian'       => 600,
        'Yiwnarmenian'       => 600,
        'Ytilde'       => 600,
        'Yusbigcyrillic'       => 600,
        'Yusbigiotifiedcyrillic'       => 600,
        'Yuslittlecyrillic'       => 600,
        'Yuslittleiotifiedcyrillic'       => 600,
        'Z'       => 600,
        'Zaarmenian'       => 600,
        'Zacute'       => 600,
        'Zcaron'       => 600,
        'Zcircumflex'       => 600,
        'Zdotaccent'       => 600,
        'Zdotbelow'       => 600,
        'Zedescendercyrillic'       => 600,
        'Zedieresiscyrillic'       => 600,
        'Zeta'       => 600,
        'Zhearmenian'       => 600,
        'Zhebrevecyrillic'       => 600,
        'Zhedescendercyrillic'       => 600,
        'Zhedieresiscyrillic'       => 600,
        'Zlinebelow'       => 600,
        'Zstroke'       => 600,
        'a'       => 600,
        'aacute'       => 600,
        'abbreviationmarkarmenian'       => 600,
        'abreve'       => 600,
        'abreveacute'       => 600,
        'abrevecyrillic'       => 600,
        'abrevedotbelow'       => 600,
        'abrevegrave'       => 600,
        'abrevehookabove'       => 600,
        'abrevetilde'       => 600,
        'acaron'       => 600,
        'acircumflex'       => 600,
        'acircumflexacute'       => 600,
        'acircumflexdotbelow'       => 600,
        'acircumflexgrave'       => 600,
        'acircumflexhookabove'       => 600,
        'acircumflextilde'       => 600,
        'acute'       => 600,
        'acutebelowcmb'       => 600,
        'acutecomb'       => 600,
        'acutelowmod'       => 600,
        'acutetonecmb'       => 600,
        'adblgrave'       => 600,
        'adieresis'       => 600,
        'adieresiscyrillic'       => 600,
        'adieresismacron'       => 600,
        'adotbelow'       => 600,
        'adotmacron'       => 600,
        'ae'       => 600,
        'aeacute'       => 600,
        'aemacron'       => 600,
        'afii00208'       => 600,
        'afii10017'       => 600,
        'afii10018'       => 600,
        'afii10019'       => 600,
        'afii10020'       => 600,
        'afii10021'       => 600,
        'afii10022'       => 600,
        'afii10023'       => 600,
        'afii10024'       => 600,
        'afii10025'       => 600,
        'afii10026'       => 600,
        'afii10027'       => 600,
        'afii10028'       => 600,
        'afii10029'       => 600,
        'afii10030'       => 600,
        'afii10031'       => 600,
        'afii10032'       => 600,
        'afii10033'       => 600,
        'afii10034'       => 600,
        'afii10035'       => 600,
        'afii10036'       => 600,
        'afii10037'       => 600,
        'afii10038'       => 600,
        'afii10039'       => 600,
        'afii10040'       => 600,
        'afii10041'       => 600,
        'afii10042'       => 600,
        'afii10043'       => 600,
        'afii10044'       => 600,
        'afii10045'       => 600,
        'afii10046'       => 600,
        'afii10047'       => 600,
        'afii10048'       => 600,
        'afii10049'       => 600,
        'afii10050'       => 600,
        'afii10051'       => 600,
        'afii10052'       => 600,
        'afii10053'       => 600,
        'afii10054'       => 600,
        'afii10055'       => 600,
        'afii10056'       => 600,
        'afii10057'       => 600,
        'afii10058'       => 600,
        'afii10059'       => 600,
        'afii10060'       => 600,
        'afii10061'       => 600,
        'afii10062'       => 600,
        'afii10065'       => 600,
        'afii10066'       => 600,
        'afii10067'       => 600,
        'afii10068'       => 600,
        'afii10069'       => 600,
        'afii10070'       => 600,
        'afii10071'       => 600,
        'afii10072'       => 600,
        'afii10073'       => 600,
        'afii10074'       => 600,
        'afii10075'       => 600,
        'afii10076'       => 600,
        'afii10077'       => 600,
        'afii10078'       => 600,
        'afii10079'       => 600,
        'afii10080'       => 600,
        'afii10081'       => 600,
        'afii10082'       => 600,
        'afii10083'       => 600,
        'afii10084'       => 600,
        'afii10085'       => 600,
        'afii10086'       => 600,
        'afii10087'       => 600,
        'afii10088'       => 600,
        'afii10089'       => 600,
        'afii10090'       => 600,
        'afii10091'       => 600,
        'afii10092'       => 600,
        'afii10093'       => 600,
        'afii10094'       => 600,
        'afii10095'       => 600,
        'afii10096'       => 600,
        'afii10097'       => 600,
        'afii10098'       => 600,
        'afii10099'       => 600,
        'afii10100'       => 600,
        'afii10101'       => 600,
        'afii10102'       => 600,
        'afii10103'       => 600,
        'afii10104'       => 600,
        'afii10105'       => 600,
        'afii10106'       => 600,
        'afii10107'       => 600,
        'afii10108'       => 600,
        'afii10109'       => 600,
        'afii10110'       => 600,
        'afii10145'       => 600,
        'afii10146'       => 600,
        'afii10147'       => 600,
        'afii10148'       => 600,
        'afii10193'       => 600,
        'afii10194'       => 600,
        'afii10195'       => 600,
        'afii10196'       => 600,
        'afii10846'       => 600,
        'afii299'       => 600,
        'afii300'       => 600,
        'afii301'       => 600,
        'afii57381'       => 600,
        'afii57388'       => 600,
        'afii57396'       => 600,
        'afii57397'       => 600,
        'afii57398'       => 600,
        'afii57403'       => 600,
        'afii57407'       => 600,
        'afii57409'       => 600,
        'afii57440'       => 600,
        'afii57451'       => 600,
        'afii57452'       => 600,
        'afii57453'       => 600,
        'afii57454'       => 600,
        'afii57455'       => 600,
        'afii57456'       => 600,
        'afii57457'       => 600,
        'afii57458'       => 600,
        'afii57534'       => 600,
        'afii57636'       => 600,
        'afii57645'       => 600,
        'afii57658'       => 600,
        'afii57664'       => 600,
        'afii57665'       => 600,
        'afii57666'       => 600,
        'afii57667'       => 600,
        'afii57668'       => 600,
        'afii57669'       => 600,
        'afii57670'       => 600,
        'afii57671'       => 600,
        'afii57672'       => 600,
        'afii57673'       => 600,
        'afii57674'       => 600,
        'afii57675'       => 600,
        'afii57676'       => 600,
        'afii57677'       => 600,
        'afii57678'       => 600,
        'afii57679'       => 600,
        'afii57680'       => 600,
        'afii57681'       => 600,
        'afii57682'       => 600,
        'afii57683'       => 600,
        'afii57684'       => 600,
        'afii57685'       => 600,
        'afii57686'       => 600,
        'afii57687'       => 600,
        'afii57688'       => 600,
        'afii57689'       => 600,
        'afii57690'       => 600,
        'afii57694'       => 600,
        'afii57695'       => 600,
        'afii57700'       => 600,
        'afii57705'       => 600,
        'afii57716'       => 600,
        'afii57717'       => 600,
        'afii57718'       => 600,
        'afii57723'       => 600,
        'afii57793'       => 600,
        'afii57794'       => 600,
        'afii57795'       => 600,
        'afii57796'       => 600,
        'afii57797'       => 600,
        'afii57798'       => 600,
        'afii57799'       => 600,
        'afii57800'       => 600,
        'afii57801'       => 600,
        'afii57802'       => 600,
        'afii57803'       => 600,
        'afii57804'       => 600,
        'afii57806'       => 600,
        'afii57807'       => 600,
        'afii57839'       => 600,
        'afii57841'       => 600,
        'afii57842'       => 600,
        'afii57929'       => 600,
        'afii61248'       => 600,
        'afii61289'       => 600,
        'afii61352'       => 600,
        'afii61664'       => 600,
        'afii63167'       => 600,
        'afii64937'       => 600,
        'agrave'       => 600,
        'ahookabove'       => 600,
        'aiecyrillic'       => 600,
        'ainfinalarabic'       => 600,
        'aininitialarabic'       => 600,
        'ainmedialarabic'       => 600,
        'ainvertedbreve'       => 600,
        'alefdageshhebrew'       => 600,
        'aleffinalarabic'       => 600,
        'alefhamzaabovefinalarabic'       => 600,
        'alefhamzabelowfinalarabic'       => 600,
        'aleflamedhebrew'       => 600,
        'alefmaddaabovefinalarabic'       => 600,
        'alefmaksurafinalarabic'       => 600,
        'alefmaksurainitialarabic'       => 600,
        'alefmaksuramedialarabic'       => 600,
        'alefpatahhebrew'       => 600,
        'alefqamatshebrew'       => 600,
        'alpha'       => 600,
        'alphatonos'       => 600,
        'amacron'       => 600,
        'ampersand'       => 600,
        'anoteleia'       => 600,
        'aogonek'       => 600,
        'apostrophearmenian'       => 600,
        'approxequal'       => 600,
        'arighthalfring'       => 600,
        'aring'       => 600,
        'aringacute'       => 600,
        'aringbelow'       => 600,
        'arrowboth'       => 600,
        'arrowdown'       => 600,
        'arrowheaddownmod'       => 600,
        'arrowheadleftmod'       => 600,
        'arrowheadrightmod'       => 600,
        'arrowheadupmod'       => 600,
        'arrowleft'       => 600,
        'arrowright'       => 600,
        'arrowup'       => 600,
        'arrowupdn'       => 600,
        'arrowupdnbse'       => 600,
        'asciicircum'       => 600,
        'asciitilde'       => 600,
        'ascript'       => 600,
        'ascriptturned'       => 600,
        'asterisk'       => 600,
        'at'       => 600,
        'atilde'       => 600,
        'aturned'       => 600,
        'aybarmenian'       => 600,
        'ayinaltonehebrew'       => 600,
        'b'       => 600,
        'backslash'       => 600,
        'bahtthai'       => 600,
        'bar'       => 600,
        'bdotaccent'       => 600,
        'bdotbelow'       => 600,
        'behfinalarabic'       => 600,
        'behinitialarabic'       => 600,
        'behmedialarabic'       => 600,
        'behmeeminitialarabic'       => 600,
        'behmeemisolatedarabic'       => 600,
        'behnoonfinalarabic'       => 600,
        'benarmenian'       => 600,
        'beta'       => 600,
        'betasymbolgreek'       => 600,
        'betdagesh'       => 600,
        'betrafehebrew'       => 600,
        'bhook'       => 600,
        'bilabialclick'       => 600,
        'blinebelow'       => 600,
        'block'       => 600,
        'braceleft'       => 600,
        'braceright'       => 600,
        'bracketleft'       => 600,
        'bracketright'       => 600,
        'breve'       => 600,
        'brevebelowcmb'       => 600,
        'brevecmb'       => 600,
        'breveinvertedbelowcmb'       => 600,
        'breveinvertedcmb'       => 600,
        'breveinverteddoublecmb'       => 600,
        'bridgebelowcmb'       => 600,
        'bridgeinvertedbelowcmb'       => 600,
        'brokenbar'       => 600,
        'bstroke'       => 600,
        'btopbar'       => 600,
        'bullet'       => 600,
        'c'       => 600,
        'caarmenian'       => 600,
        'cacute'       => 600,
        'candrabinducmb'       => 600,
        'caron'       => 600,
        'caronbelowcmb'       => 600,
        'caroncmb'       => 600,
        'ccaron'       => 600,
        'ccedilla'       => 600,
        'ccedillaacute'       => 600,
        'ccircumflex'       => 600,
        'ccurl'       => 600,
        'cdotaccent'       => 600,
        'cedilla'       => 600,
        'cedillacmb'       => 600,
        'cent'       => 600,
        'chaarmenian'       => 600,
        'cheabkhasiancyrillic'       => 600,
        'chedescenderabkhasiancyrillic'       => 600,
        'chedescendercyrillic'       => 600,
        'chedieresiscyrillic'       => 600,
        'cheharmenian'       => 600,
        'chekhakassiancyrillic'       => 600,
        'cheverticalstrokecyrillic'       => 600,
        'chi'       => 600,
        'chook'       => 600,
        'circle'       => 600,
        'circumflex'       => 600,
        'circumflexbelowcmb'       => 600,
        'circumflexcmb'       => 600,
        'clickalveolar'       => 600,
        'clickdental'       => 600,
        'clicklateral'       => 600,
        'clickretroflex'       => 600,
        'club'       => 600,
        'coarmenian'       => 600,
        'colon'       => 600,
        'colonmonetary'       => 600,
        'colontriangularhalfmod'       => 600,
        'colontriangularmod'       => 600,
        'comma'       => 600,
        'commaabovecmb'       => 600,
        'commaaboverightcmb'       => 600,
        'commaarmenian'       => 600,
        'commaaccent'       => 600,
        'commareversedabovecmb'       => 600,
        'commaturnedabovecmb'       => 600,
        'commaturnedmod'       => 600,
        'copyright'       => 600,
        'cruzeiro'       => 600,
        'cstretched'       => 600,
        'currency'       => 600,
        'd'       => 600,
        'daarmenian'       => 600,
        'dadfinalarabic'       => 600,
        'dadinitialarabic'       => 600,
        'dadmedialarabic'       => 600,
        'dagger'       => 600,
        'daggerdbl'       => 600,
        'daletdagesh'       => 600,
        'dalfinalarabic'       => 600,
        'dargahebrew'       => 600,
        'dasiapneumatacyrilliccmb'       => 600,
        'dblarchinvertedbelowcmb'       => 600,
        'dblgravecmb'       => 600,
        'dbllowlinecmb'       => 600,
        'dbloverlinecmb'       => 600,
        'dblprimemod'       => 600,
        'dblverticallineabovecmb'       => 600,
        'dcaron'       => 600,
        'dcedilla'       => 600,
        'dcircumflexbelow'       => 600,
        'dcroat'       => 600,
        'ddalfinalarabic'       => 600,
        'ddotaccent'       => 600,
        'ddotbelow'       => 600,
        'decimalseparatorarabic'       => 600,
        'degree'       => 600,
        'dehihebrew'       => 600,
        'deicoptic'       => 600,
        'delta'       => 600,
        'deltaturned'       => 600,
        'dezh'       => 600,
        'dhook'       => 600,
        'dialytikatonoscmb'       => 600,
        'diamond'       => 600,
        'dieresis'       => 600,
        'dieresisbelowcmb'       => 600,
        'dieresiscmb'       => 600,
        'dieresistonos'       => 600,
        'divide'       => 600,
        'dkshade'       => 600,
        'dlinebelow'       => 600,
        'dnblock'       => 600,
        'dollar'       => 600,
        'dong'       => 600,
        'dotaccent'       => 600,
        'dotaccentcmb'       => 600,
        'dotbelowcomb'       => 600,
        'dotlessi'       => 600,
        'dotlessjstrokehook'       => 600,
        'dottedcircle'       => 600,
        'downtackbelowcmb'       => 600,
        'downtackmod'       => 600,
        'dtail'       => 600,
        'dtopbar'       => 600,
        'dz'       => 600,
        'dzaltone'       => 600,
        'dzcaron'       => 600,
        'dzcurl'       => 600,
        'dzeabkhasiancyrillic'       => 600,
        'e'       => 600,
        'eacute'       => 600,
        'ebreve'       => 600,
        'ecaron'       => 600,
        'ecedillabreve'       => 600,
        'echarmenian'       => 600,
        'echyiwnarmenian'       => 600,
        'ecircumflex'       => 600,
        'ecircumflexacute'       => 600,
        'ecircumflexbelow'       => 600,
        'ecircumflexdotbelow'       => 600,
        'ecircumflexgrave'       => 600,
        'ecircumflexhookabove'       => 600,
        'ecircumflextilde'       => 600,
        'edblgrave'       => 600,
        'edieresis'       => 600,
        'edotaccent'       => 600,
        'edotbelow'       => 600,
        'egrave'       => 600,
        'eharmenian'       => 600,
        'ehookabove'       => 600,
        'eight'       => 600,
        'eightpersian'       => 600,
        'einvertedbreve'       => 600,
        'eiotifiedcyrillic'       => 600,
        'ellipsis'       => 600,
        'emacron'       => 600,
        'emacronacute'       => 600,
        'emacrongrave'       => 600,
        'emdash'       => 600,
        'emphasismarkarmenian'       => 600,
        'endash'       => 600,
        'endescendercyrillic'       => 600,
        'eng'       => 600,
        'enghecyrillic'       => 600,
        'enhookcyrillic'       => 600,
        'eogonek'       => 600,
        'eopen'       => 600,
        'eopenclosed'       => 600,
        'eopenreversed'       => 600,
        'eopenreversedclosed'       => 600,
        'eopenreversedhook'       => 600,
        'epsilon'       => 600,
        'epsilontonos'       => 600,
        'equal'       => 600,
        'equivalence'       => 600,
        'ereversed'       => 600,
        'esdescendercyrillic'       => 600,
        'esh'       => 600,
        'eshcurl'       => 600,
        'eshreversedloop'       => 600,
        'eshsquatreversed'       => 600,
        'estimated'       => 600,
        'eta'       => 600,
        'etarmenian'       => 600,
        'etatonos'       => 600,
        'eth'       => 600,
        'etilde'       => 600,
        'etildebelow'       => 600,
        'etnahtafoukhhebrew'       => 600,
        'eturned'       => 600,
        'exclam'       => 600,
        'exclamarmenian'       => 600,
        'exclamdbl'       => 600,
        'exclamdown'       => 600,
        'ezh'       => 600,
        'ezhcaron'       => 600,
        'ezhcurl'       => 600,
        'ezhreversed'       => 600,
        'ezhtail'       => 600,
        'f'       => 600,
        'fdotaccent'       => 600,
        'feharmenian'       => 600,
        'fehfinalarabic'       => 600,
        'fehinitialarabic'       => 600,
        'fehmedialarabic'       => 600,
        'feicoptic'       => 600,
        'female'       => 600,
        'ff'       => 600,
        'ffi'       => 600,
        'ffl'       => 600,
        'fi'       => 600,
        'figuredash'       => 600,
        'filledbox'       => 600,
        'filledrect'       => 600,
        'finalkafdagesh'       => 600,
        'five'       => 600,
        'fiveeighths'       => 600,
        'fivepersian'       => 600,
        'fl'       => 600,
        'florin'       => 600,
        'four'       => 600,
        'fourpersian'       => 600,
        'fourthtonechinese'       => 600,
        'fraction'       => 600,
        'franc'       => 600,
        'g'       => 600,
        'gacute'       => 600,
        'gaffinalarabic'       => 600,
        'gafinitialarabic'       => 600,
        'gafmedialarabic'       => 600,
        'gamma'       => 600,
        'gammad'       => 600,
        'gammalatinsmall'       => 600,
        'gammasuperior'       => 600,
        'gangiacoptic'       => 600,
        'gbreve'       => 600,
        'gcaron'       => 600,
        'gcircumflex'       => 600,
        'gcommaaccent'       => 600,
        'gdotaccent'       => 600,
        'gereshaccenthebrew'       => 600,
        'gereshhebrew'       => 600,
        'gereshmuqdamhebrew'       => 600,
        'germandbls'       => 600,
        'gershayimaccenthebrew'       => 600,
        'gershayimhebrew'       => 600,
        'ghadarmenian'       => 600,
        'ghainfinalarabic'       => 600,
        'ghaininitialarabic'       => 600,
        'ghainmedialarabic'       => 600,
        'ghemiddlehookcyrillic'       => 600,
        'ghestrokecyrillic'       => 600,
        'ghook'       => 600,
        'gimarmenian'       => 600,
        'gimeldagesh'       => 600,
        'glottalinvertedstroke'       => 600,
        'glottalstop'       => 600,
        'glottalstopinverted'       => 600,
        'glottalstopmod'       => 600,
        'glottalstopreversed'       => 600,
        'glottalstopreversedmod'       => 600,
        'glottalstopreversedsuperior'       => 600,
        'glottalstopstroke'       => 600,
        'glottalstopstrokereversed'       => 600,
        'gmacron'       => 600,
        'grave'       => 600,
        'gravebelowcmb'       => 600,
        'gravecomb'       => 600,
        'gravelowmod'       => 600,
        'gravetonecmb'       => 600,
        'greater'       => 600,
        'greaterequal'       => 600,
        'gscript'       => 600,
        'gstroke'       => 600,
        'guillemotleft'       => 600,
        'guillemotright'       => 600,
        'guilsinglleft'       => 600,
        'guilsinglright'       => 600,
        'h'       => 600,
        'haabkhasiancyrillic'       => 600,
        'hadescendercyrillic'       => 600,
        'hahfinalarabic'       => 600,
        'hahinitialarabic'       => 600,
        'hahmedialarabic'       => 600,
        'hbar'       => 600,
        'hbrevebelow'       => 600,
        'hcedilla'       => 600,
        'hcircumflex'       => 600,
        'hdieresis'       => 600,
        'hdotaccent'       => 600,
        'hdotbelow'       => 600,
        'heart'       => 600,
        'hedagesh'       => 600,
        'hehfinalaltonearabic'       => 600,
        'hehfinalalttwoarabic'       => 600,
        'hehhamzaabovefinalarabic'       => 600,
        'hehhamzaaboveisolatedarabic'       => 600,
        'hehinitialaltonearabic'       => 600,
        'hehinitialarabic'       => 600,
        'hehmedialaltonearabic'       => 600,
        'hehmedialarabic'       => 600,
        'henghook'       => 600,
        'hhook'       => 600,
        'hhooksuperior'       => 600,
        'hlinebelow'       => 600,
        'hoarmenian'       => 600,
        'hookabovecomb'       => 600,
        'hookpalatalizedbelowcmb'       => 600,
        'hookretroflexbelowcmb'       => 600,
        'horicoptic'       => 600,
        'horncmb'       => 600,
        'house'       => 600,
        'hsuperior'       => 600,
        'hturned'       => 600,
        'hungarumlaut'       => 600,
        'hungarumlautcmb'       => 600,
        'hv'       => 600,
        'hyphen'       => 600,
        'i'       => 600,
        'iacute'       => 600,
        'ibreve'       => 600,
        'icaron'       => 600,
        'icircumflex'       => 600,
        'idblgrave'       => 600,
        'idieresis'       => 600,
        'idieresisacute'       => 600,
        'idieresiscyrillic'       => 600,
        'idotbelow'       => 600,
        'iebrevecyrillic'       => 600,
        'igrave'       => 600,
        'ihookabove'       => 600,
        'iinvertedbreve'       => 600,
        'ij'       => 600,
        'iluyhebrew'       => 600,
        'imacron'       => 600,
        'imacroncyrillic'       => 600,
        'infinity'       => 600,
        'iniarmenian'       => 600,
        'integral'       => 600,
        'integralbt'       => 600,
        'integraltp'       => 600,
        'intersection'       => 600,
        'invbullet'       => 600,
        'invcircle'       => 600,
        'invsmileface'       => 600,
        'iogonek'       => 600,
        'iota'       => 600,
        'iotadieresis'       => 600,
        'iotadieresistonos'       => 600,
        'iotalatin'       => 600,
        'iotatonos'       => 600,
        'istroke'       => 600,
        'itilde'       => 600,
        'itildebelow'       => 600,
        'izhitsadblgravecyrillic'       => 600,
        'j'       => 600,
        'jaarmenian'       => 600,
        'jcaron'       => 600,
        'jcircumflex'       => 600,
        'jcrossedtail'       => 600,
        'jdotlessstroke'       => 600,
        'jeemfinalarabic'       => 600,
        'jeeminitialarabic'       => 600,
        'jeemmedialarabic'       => 600,
        'jehfinalarabic'       => 600,
        'jheharmenian'       => 600,
        'jsuperior'       => 600,
        'k'       => 600,
        'kabashkircyrillic'       => 600,
        'kacute'       => 600,
        'kadescendercyrillic'       => 600,
        'kafdagesh'       => 600,
        'kaffinalarabic'       => 600,
        'kafinitialarabic'       => 600,
        'kafmedialarabic'       => 600,
        'kafrafehebrew'       => 600,
        'kahookcyrillic'       => 600,
        'kappa'       => 600,
        'kappasymbolgreek'       => 600,
        'kastrokecyrillic'       => 600,
        'kaverticalstrokecyrillic'       => 600,
        'kcaron'       => 600,
        'kcommaaccent'       => 600,
        'kdotbelow'       => 600,
        'keharmenian'       => 600,
        'kenarmenian'       => 600,
        'kgreenlandic'       => 600,
        'khahfinalarabic'       => 600,
        'khahinitialarabic'       => 600,
        'khahmedialarabic'       => 600,
        'kheicoptic'       => 600,
        'khook'       => 600,
        'klinebelow'       => 600,
        'koppacyrillic'       => 600,
        'koroniscmb'       => 600,
        'ksicyrillic'       => 600,
        'kturned'       => 600,
        'l'       => 600,
        'lacute'       => 600,
        'lamaleffinalarabic'       => 600,
        'lamalefhamzaabovefinalarabic'       => 600,
        'lamalefhamzaaboveisolatedarabic'       => 600,
        'lamalefhamzabelowfinalarabic'       => 600,
        'lamalefhamzabelowisolatedarabic'       => 600,
        'lamalefisolatedarabic'       => 600,
        'lamalefmaddaabovefinalarabic'       => 600,
        'lamalefmaddaaboveisolatedarabic'       => 600,
        'lambda'       => 600,
        'lambdastroke'       => 600,
        'lameddagesh'       => 600,
        'lamfinalarabic'       => 600,
        'lamhahinitialarabic'       => 600,
        'laminitialarabic'       => 600,
        'lamjeeminitialarabic'       => 600,
        'lamkhahinitialarabic'       => 600,
        'lamlamhehisolatedarabic'       => 600,
        'lammedialarabic'       => 600,
        'lammeemhahinitialarabic'       => 600,
        'lammeeminitialarabic'       => 600,
        'lbar'       => 600,
        'lbelt'       => 600,
        'lcaron'       => 600,
        'lcircumflexbelow'       => 600,
        'lcommaaccent'       => 600,
        'ldot'       => 600,
        'ldotbelow'       => 600,
        'ldotbelowmacron'       => 600,
        'leftangleabovecmb'       => 600,
        'lefttackbelowcmb'       => 600,
        'less'       => 600,
        'lessequal'       => 600,
        'lezh'       => 600,
        'lfblock'       => 600,
        'lhookretroflex'       => 600,
        'lira'       => 600,
        'liwnarmenian'       => 600,
        'lj'       => 600,
        'llinebelow'       => 600,
        'lmiddletilde'       => 600,
        'logicalnot'       => 600,
        'longs'       => 600,
        'lowlinecmb'       => 600,
        'lozenge'       => 600,
        'lslash'       => 600,
        'ltshade'       => 600,
        'm'       => 600,
        'macron'       => 600,
        'macronbelowcmb'       => 600,
        'macroncmb'       => 600,
        'macronlowmod'       => 600,
        'macute'       => 600,
        'mahapakhhebrew'       => 600,
        'male'       => 600,
        'masoracirclehebrew'       => 600,
        'mdotaccent'       => 600,
        'mdotbelow'       => 600,
        'meemfinalarabic'       => 600,
        'meeminitialarabic'       => 600,
        'meemmedialarabic'       => 600,
        'meemmeeminitialarabic'       => 600,
        'memdagesh'       => 600,
        'menarmenian'       => 600,
        'merkhahebrew'       => 600,
        'merkhakefulahebrew'       => 600,
        'mhook'       => 600,
        'minus'       => 600,
        'minusbelowcmb'       => 600,
        'minusmod'       => 600,
        'minute'       => 600,
        'mlonglegturned'       => 600,
        'mturned'       => 600,
        'mu'       => 600,
        'multiply'       => 600,
        'munahhebrew'       => 600,
        'musicalnote'       => 600,
        'musicalnotedbl'       => 600,
        'musicsharpsign'       => 600,
        'n'       => 600,
        'nacute'       => 600,
        'napostrophe'       => 600,
        'ncaron'       => 600,
        'ncircumflexbelow'       => 600,
        'ncommaaccent'       => 600,
        'ndotaccent'       => 600,
        'ndotbelow'       => 600,
        'nhookleft'       => 600,
        'nhookretroflex'       => 600,
        'nine'       => 600,
        'ninepersian'       => 600,
        'nj'       => 600,
        'nlegrightlong'       => 600,
        'nlinebelow'       => 600,
        'noonfinalarabic'       => 600,
        'noonghunnafinalarabic'       => 600,
        'noonhehinitialarabic'       => 600,
        'noonjeeminitialarabic'       => 600,
        'noonmedialarabic'       => 600,
        'noonmeeminitialarabic'       => 600,
        'noonmeemisolatedarabic'       => 600,
        'notequal'       => 600,
        'nowarmenian'       => 600,
        'nsuperior'       => 600,
        'ntilde'       => 600,
        'nu'       => 600,
        'numbersign'       => 600,
        'numeralsigngreek'       => 600,
        'numeralsignlowergreek'       => 600,
        'nundagesh'       => 600,
        'o'       => 600,
        'oacute'       => 600,
        'obarred'       => 600,
        'obarredcyrillic'       => 600,
        'obarreddieresiscyrillic'       => 600,
        'obreve'       => 600,
        'ocaron'       => 600,
        'ocircumflex'       => 600,
        'ocircumflexacute'       => 600,
        'ocircumflexdotbelow'       => 600,
        'ocircumflexgrave'       => 600,
        'ocircumflexhookabove'       => 600,
        'ocircumflextilde'       => 600,
        'odblgrave'       => 600,
        'odieresis'       => 600,
        'odieresiscyrillic'       => 600,
        'odotbelow'       => 600,
        'oe'       => 600,
        'ogonek'       => 600,
        'ogonekcmb'       => 600,
        'ograve'       => 600,
        'oharmenian'       => 600,
        'ohookabove'       => 600,
        'ohorn'       => 600,
        'ohornacute'       => 600,
        'ohorndotbelow'       => 600,
        'ohorngrave'       => 600,
        'ohornhookabove'       => 600,
        'ohorntilde'       => 600,
        'ohungarumlaut'       => 600,
        'oi'       => 600,
        'oinvertedbreve'       => 600,
        'olehebrew'       => 600,
        'omacron'       => 600,
        'omacronacute'       => 600,
        'omacrongrave'       => 600,
        'omega'       => 600,
        'omega1'       => 600,
        'omegacyrillic'       => 600,
        'omegalatinclosed'       => 600,
        'omegaroundcyrillic'       => 600,
        'omegatitlocyrillic'       => 600,
        'omegatonos'       => 600,
        'omicron'       => 600,
        'omicrontonos'       => 600,
        'one'       => 600,
        'oneeighth'       => 600,
        'onehalf'       => 600,
        'onepersian'       => 600,
        'onequarter'       => 600,
        'onesuperior'       => 600,
        'onethird'       => 600,
        'oogonek'       => 600,
        'oogonekmacron'       => 600,
        'oopen'       => 600,
        'openbullet'       => 600,
        'ordfeminine'       => 600,
        'ordmasculine'       => 600,
        'orthogonal'       => 600,
        'oslash'       => 600,
        'oslashacute'       => 600,
        'otcyrillic'       => 600,
        'otilde'       => 600,
        'otildeacute'       => 600,
        'otildedieresis'       => 600,
        'overline'       => 600,
        'overlinecmb'       => 600,
        'p'       => 600,
        'pacute'       => 600,
        'palatalizationcyrilliccmb'       => 600,
        'palochkacyrillic'       => 600,
        'paragraph'       => 600,
        'parenleft'       => 600,
        'parenleftaltonearabic'       => 600,
        'parenright'       => 600,
        'parenrightaltonearabic'       => 600,
        'partialdiff'       => 600,
        'pashtahebrew'       => 600,
        'pazerhebrew'       => 600,
        'pdotaccent'       => 600,
        'pedagesh'       => 600,
        'pefinaldageshhebrew'       => 600,
        'peharmenian'       => 600,
        'pehfinalarabic'       => 600,
        'pehinitialarabic'       => 600,
        'pehmedialarabic'       => 600,
        'pemiddlehookcyrillic'       => 600,
        'perafehebrew'       => 600,
        'percent'       => 600,
        'period'       => 600,
        'periodarmenian'       => 600,
        'periodcentered'       => 600,
        'perispomenigreekcmb'       => 600,
        'perthousand'       => 600,
        'peseta'       => 600,
        'phi'       => 600,
        'phi1'       => 600,
        'philatin'       => 600,
        'phook'       => 600,
        'pi'       => 600,
        'piwrarmenian'       => 600,
        'plus'       => 600,
        'plusbelowcmb'       => 600,
        'plusminus'       => 600,
        'plusmod'       => 600,
        'primemod'       => 600,
        'product'       => 600,
        'psi'       => 600,
        'psicyrillic'       => 600,
        'psilipneumatacyrilliccmb'       => 600,
        'q'       => 600,
        'qadmahebrew'       => 600,
        'qaffinalarabic'       => 600,
        'qafinitialarabic'       => 600,
        'qafmedialarabic'       => 600,
        'qarneyparahebrew'       => 600,
        'qhook'       => 600,
        'qofdagesh'       => 600,
        'question'       => 600,
        'questionarmenian'       => 600,
        'questiondown'       => 600,
        'questiongreek'       => 600,
        'quotedbl'       => 600,
        'quotedblbase'       => 600,
        'quotedblleft'       => 600,
        'quotedblright'       => 600,
        'quoteleft'       => 600,
        'quotereversed'       => 600,
        'quoteright'       => 600,
        'quotesinglbase'       => 600,
        'quotesingle'       => 600,
        'r'       => 600,
        'raarmenian'       => 600,
        'racute'       => 600,
        'radical'       => 600,
        'ramshorn'       => 600,
        'rcaron'       => 600,
        'rcommaaccent'       => 600,
        'rdblgrave'       => 600,
        'rdotaccent'       => 600,
        'rdotbelow'       => 600,
        'rdotbelowmacron'       => 600,
        'registered'       => 600,
        'reharmenian'       => 600,
        'rehfinalarabic'       => 600,
        'reshdageshhebrew'       => 600,
        'reviahebrew'       => 600,
        'revlogicalnot'       => 600,
        'rfishhook'       => 600,
        'rfishhookreversed'       => 600,
        'rho'       => 600,
        'rhook'       => 600,
        'rhookturned'       => 600,
        'rhookturnedsuperior'       => 600,
        'rhosymbolgreek'       => 600,
        'rhotichookmod'       => 600,
        'righttackbelowcmb'       => 600,
        'ring'       => 600,
        'ringbelowcmb'       => 600,
        'ringcmb'       => 600,
        'ringhalfleft'       => 600,
        'ringhalfleftarmenian'       => 600,
        'ringhalfleftbelowcmb'       => 600,
        'ringhalfleftcentered'       => 600,
        'ringhalfright'       => 600,
        'ringhalfrightbelowcmb'       => 600,
        'ringhalfrightcentered'       => 600,
        'rinvertedbreve'       => 600,
        'rlinebelow'       => 600,
        'rlongleg'       => 600,
        'rlonglegturned'       => 600,
        'rrehfinalarabic'       => 600,
        'rtblock'       => 600,
        'rturned'       => 600,
        'rturnedsuperior'       => 600,
        's'       => 600,
        'sacute'       => 600,
        'sacutedotaccent'       => 600,
        'sadfinalarabic'       => 600,
        'sadinitialarabic'       => 600,
        'sadmedialarabic'       => 600,
        'sallallahoualayhewasallamarabic'       => 600,
        'samekhdagesh'       => 600,
        'scaron'       => 600,
        'scarondotaccent'       => 600,
        'scedilla'       => 600,
        'schwadieresiscyrillic'       => 600,
        'schwahook'       => 600,
        'scircumflex'       => 600,
        'scommaaccent'       => 600,
        'sdotaccent'       => 600,
        'sdotbelow'       => 600,
        'sdotbelowdotaccent'       => 600,
        'seagullbelowcmb'       => 600,
        'second'       => 600,
        'secondtonechinese'       => 600,
        'section'       => 600,
        'seenfinalarabic'       => 600,
        'seeninitialarabic'       => 600,
        'seenmedialarabic'       => 600,
        'segoltahebrew'       => 600,
        'seharmenian'       => 600,
        'semicolon'       => 600,
        'seven'       => 600,
        'seveneighths'       => 600,
        'sevenpersian'       => 600,
        'shaarmenian'       => 600,
        'shaddadammaarabic'       => 600,
        'shaddadammatanarabic'       => 600,
        'shaddafathaarabic'       => 600,
        'shaddakasraarabic'       => 600,
        'shaddakasratanarabic'       => 600,
        'shade'       => 600,
        'shalshelethebrew'       => 600,
        'sheenfinalarabic'       => 600,
        'sheeninitialarabic'       => 600,
        'sheenmedialarabic'       => 600,
        'sheicoptic'       => 600,
        'shhacyrillic'       => 600,
        'shimacoptic'       => 600,
        'shindagesh'       => 600,
        'shindageshshindot'       => 600,
        'shindageshsindot'       => 600,
        'shook'       => 600,
        'sigma'       => 600,
        'sigma1'       => 600,
        'sigmalunatesymbolgreek'       => 600,
        'six'       => 600,
        'sixpersian'       => 600,
        'slash'       => 600,
        'slongdotaccent'       => 600,
        'smileface'       => 600,
        'soliduslongoverlaycmb'       => 600,
        'solidusshortoverlaycmb'       => 600,
        'space'       => 600,
        'spade'       => 600,
        'squarebelowcmb'       => 600,
        'sterling'       => 600,
        'strokelongoverlaycmb'       => 600,
        'strokeshortoverlaycmb'       => 600,
        'summation'       => 600,
        'sun'       => 600,
        't'       => 600,
        'tahfinalarabic'       => 600,
        'tahinitialarabic'       => 600,
        'tahmedialarabic'       => 600,
        'tau'       => 600,
        'tavdages'       => 600,
        'tbar'       => 600,
        'tcaron'       => 600,
        'tccurl'       => 600,
        'tcedilla'       => 600,
        'tchehfinalarabic'       => 600,
        'tchehinitialarabic'       => 600,
        'tchehmedialarabic'       => 600,
        'tcircumflexbelow'       => 600,
        'tcommaaccent'       => 600,
        'tdieresis'       => 600,
        'tdotaccent'       => 600,
        'tdotbelow'       => 600,
        'tedescendercyrillic'       => 600,
        'tehfinalarabic'       => 600,
        'tehhahinitialarabic'       => 600,
        'tehinitialarabic'       => 600,
        'tehjeeminitialarabic'       => 600,
        'tehmarbutafinalarabic'       => 600,
        'tehmedialarabic'       => 600,
        'tehmeeminitialarabic'       => 600,
        'tehmeemisolatedarabic'       => 600,
        'tehnoonfinalarabic'       => 600,
        'telishagedolahebrew'       => 600,
        'telishaqetanahebrew'       => 600,
        'tesh'       => 600,
        'tetdagesh'       => 600,
        'tetsecyrillic'       => 600,
        'tevirhebrew'       => 600,
        'thalfinalarabic'       => 600,
        'thehfinalarabic'       => 600,
        'thehinitialarabic'       => 600,
        'thehmedialarabic'       => 600,
        'theta'       => 600,
        'theta1'       => 600,
        'thook'       => 600,
        'thorn'       => 600,
        'thousandcyrillic'       => 600,
        'thousandsseparatorarabic'       => 600,
        'three'       => 600,
        'threeeighths'       => 600,
        'threepersian'       => 600,
        'threequarters'       => 600,
        'threesuperior'       => 600,
        'tilde'       => 600,
        'tildebelowcmb'       => 600,
        'tildecomb'       => 600,
        'tildedoublecmb'       => 600,
        'tildeoverlaycmb'       => 600,
        'tildeverticalcmb'       => 600,
        'tipehahebrew'       => 600,
        'titlocyrilliccmb'       => 600,
        'tiwnarmenian'       => 600,
        'tlinebelow'       => 600,
        'toarmenian'       => 600,
        'tonefive'       => 600,
        'tonesix'       => 600,
        'tonetwo'       => 600,
        'tonos'       => 600,
        'tpalatalhook'       => 600,
        'tprime'       => 600,
        'trademark'       => 600,
        'tretroflexhook'       => 600,
        'triagdn'       => 600,
        'triaglf'       => 600,
        'triagrt'       => 600,
        'triagup'       => 600,
        'ts'       => 600,
        'tsadidagesh'       => 600,
        'ttehfinalarabic'       => 600,
        'ttehinitialarabic'       => 600,
        'ttehmedialarabic'       => 600,
        'tturned'       => 600,
        'two'       => 600,
        'twopersian'       => 600,
        'twostroke'       => 600,
        'twosuperior'       => 600,
        'twothirds'       => 600,
        'u'       => 600,
        'uacute'       => 600,
        'ubar'       => 600,
        'ubreve'       => 600,
        'ucaron'       => 600,
        'ucircumflex'       => 600,
        'ucircumflexbelow'       => 600,
        'udblgrave'       => 600,
        'udieresis'       => 600,
        'udieresisacute'       => 600,
        'udieresisbelow'       => 600,
        'udieresiscaron'       => 600,
        'udieresiscyrillic'       => 600,
        'udieresisgrave'       => 600,
        'udieresismacron'       => 600,
        'udotbelow'       => 600,
        'ugrave'       => 600,
        'uhookabove'       => 600,
        'uhorn'       => 600,
        'uhornacute'       => 600,
        'uhorndotbelow'       => 600,
        'uhorngrave'       => 600,
        'uhornhookabove'       => 600,
        'uhorntilde'       => 600,
        'uhungarumlaut'       => 600,
        'uhungarumlautcyrillic'       => 600,
        'uinvertedbreve'       => 600,
        'ukcyrillic'       => 600,
        'umacron'       => 600,
        'umacroncyrillic'       => 600,
        'umacrondieresis'       => 600,
        'underscore'       => 600,
        'underscoredbl'       => 600,
        'uni01F6'       => 600,
        'uni01F7'       => 600,
        'uni01F8'       => 600,
        'uni01F9'       => 600,
        'uni021C'       => 600,
        'uni021D'       => 600,
        'uni021E'       => 600,
        'uni021F'       => 600,
        'uni0220'       => 600,
        'uni0221'       => 600,
        'uni0222'       => 600,
        'uni0223'       => 600,
        'uni0224'       => 600,
        'uni0225'       => 600,
        'uni0226'       => 600,
        'uni0227'       => 600,
        'uni0228'       => 600,
        'uni0229'       => 600,
        'uni022A'       => 600,
        'uni022B'       => 600,
        'uni022C'       => 600,
        'uni022D'       => 600,
        'uni022E'       => 600,
        'uni022F'       => 600,
        'uni0230'       => 600,
        'uni0231'       => 600,
        'uni0232'       => 600,
        'uni0233'       => 600,
        'uni0234'       => 600,
        'uni0235'       => 600,
        'uni0236'       => 600,
        'uni0238'       => 600,
        'uni0239'       => 600,
        'uni023A'       => 600,
        'uni023B'       => 600,
        'uni023C'       => 600,
        'uni023D'       => 600,
        'uni023E'       => 600,
        'uni023F'       => 600,
        'uni0240'       => 600,
        'uni0241'       => 600,
        'uni0242'       => 600,
        'uni0243'       => 600,
        'uni0244'       => 600,
        'uni0245'       => 600,
        'uni0246'       => 600,
        'uni0247'       => 600,
        'uni0248'       => 600,
        'uni0249'       => 600,
        'uni024A'       => 600,
        'uni024B'       => 600,
        'uni024C'       => 600,
        'uni024D'       => 600,
        'uni024E'       => 600,
        'uni024F'       => 600,
        'uni0262'       => 600,
        'uni026A'       => 600,
        'uni0274'       => 600,
        'uni0276'       => 600,
        'uni0280'       => 600,
        'uni028F'       => 600,
        'uni0299'       => 600,
        'uni029C'       => 600,
        'uni029F'       => 600,
        'uni02A9'       => 600,
        'uni02AA'       => 600,
        'uni02AB'       => 600,
        'uni02AC'       => 600,
        'uni02AD'       => 600,
        'uni02AE'       => 600,
        'uni02AF'       => 600,
        'uni02B3'       => 600,
        'uni02DF'       => 600,
        'uni02E1'       => 600,
        'uni02E2'       => 600,
        'uni02EC'       => 600,
        'uni02ED'       => 600,
        'uni02EE'       => 600,
        'uni02EF'       => 600,
        'uni02F0'       => 600,
        'uni02F1'       => 600,
        'uni02F2'       => 600,
        'uni02F3'       => 600,
        'uni02F4'       => 600,
        'uni02F5'       => 600,
        'uni02F6'       => 600,
        'uni02F7'       => 600,
        'uni02F8'       => 600,
        'uni02F9'       => 600,
        'uni02FA'       => 600,
        'uni02FB'       => 600,
        'uni02FC'       => 600,
        'uni02FD'       => 600,
        'uni02FE'       => 600,
        'uni02FF'       => 600,
        'uni0326'       => 600,
        'uni0346'       => 600,
        'uni0347'       => 600,
        'uni0348'       => 600,
        'uni0349'       => 600,
        'uni034A'       => 600,
        'uni034B'       => 600,
        'uni034C'       => 600,
        'uni034D'       => 600,
        'uni034E'       => 600,
        'uni034F'       => 600,
        'uni0350'       => 600,
        'uni0351'       => 600,
        'uni0352'       => 600,
        'uni0353'       => 600,
        'uni0354'       => 600,
        'uni0355'       => 600,
        'uni0356'       => 600,
        'uni0357'       => 600,
        'uni0358'       => 600,
        'uni0359'       => 600,
        'uni035A'       => 600,
        'uni035B'       => 600,
        'uni035C'       => 600,
        'uni035D'       => 600,
        'uni035E'       => 600,
        'uni035F'       => 600,
        'uni0362'       => 600,
        'uni0363'       => 600,
        'uni0364'       => 600,
        'uni0365'       => 600,
        'uni0366'       => 600,
        'uni0367'       => 600,
        'uni0368'       => 600,
        'uni0369'       => 600,
        'uni036A'       => 600,
        'uni036B'       => 600,
        'uni036C'       => 600,
        'uni036D'       => 600,
        'uni036E'       => 600,
        'uni036F'       => 600,
        'uni0370'       => 600,
        'uni0371'       => 600,
        'uni0372'       => 600,
        'uni0373'       => 600,
        'uni0376'       => 600,
        'uni0377'       => 600,
        'uni037B'       => 600,
        'uni037C'       => 600,
        'uni037D'       => 600,
        'uni037F'       => 600,
        'uni03CF'       => 600,
        'uni03D7'       => 600,
        'uni03D8'       => 600,
        'uni03D9'       => 600,
        'uni03DB'       => 600,
        'uni03DF'       => 600,
        'uni03E1'       => 600,
        'uni03F4'       => 600,
        'uni03F5'       => 600,
        'uni03F6'       => 600,
        'uni03F7'       => 600,
        'uni03F8'       => 600,
        'uni03F9'       => 600,
        'uni03FA'       => 600,
        'uni03FB'       => 600,
        'uni03FC'       => 600,
        'uni03FD'       => 600,
        'uni03FE'       => 600,
        'uni03FF'       => 600,
        'uni0400'       => 600,
        'uni040D'       => 600,
        'uni0450'       => 600,
        'uni045D'       => 600,
        'uni0487'       => 600,
        'uni0488'       => 600,
        'uni0489'       => 600,
        'uni048A'       => 600,
        'uni048B'       => 600,
        'uni048C'       => 600,
        'uni048D'       => 600,
        'uni048E'       => 600,
        'uni048F'       => 600,
        'uni04C5'       => 600,
        'uni04C6'       => 600,
        'uni04C9'       => 600,
        'uni04CA'       => 600,
        'uni04CD'       => 600,
        'uni04CE'       => 600,
        'uni04CF'       => 600,
        'uni04EC'       => 600,
        'uni04ED'       => 600,
        'uni04F6'       => 600,
        'uni04F7'       => 600,
        'uni04FA'       => 600,
        'uni04FB'       => 600,
        'uni04FC'       => 600,
        'uni04FD'       => 600,
        'uni04FE'       => 600,
        'uni04FF'       => 600,
        'uni0500'       => 600,
        'uni0501'       => 600,
        'uni0502'       => 600,
        'uni0503'       => 600,
        'uni0504'       => 600,
        'uni0505'       => 600,
        'uni0506'       => 600,
        'uni0507'       => 600,
        'uni0508'       => 600,
        'uni0509'       => 600,
        'uni050A'       => 600,
        'uni050B'       => 600,
        'uni050C'       => 600,
        'uni050D'       => 600,
        'uni050E'       => 600,
        'uni050F'       => 600,
        'uni0510'       => 600,
        'uni0511'       => 600,
        'uni0512'       => 600,
        'uni0513'       => 600,
        'uni0514'       => 600,
        'uni0515'       => 600,
        'uni0516'       => 600,
        'uni0517'       => 600,
        'uni0518'       => 600,
        'uni0519'       => 600,
        'uni051A'       => 600,
        'uni051B'       => 600,
        'uni051C'       => 600,
        'uni051D'       => 600,
        'uni051E'       => 600,
        'uni051F'       => 600,
        'uni0520'       => 600,
        'uni0521'       => 600,
        'uni0522'       => 600,
        'uni0523'       => 600,
        'uni0524'       => 600,
        'uni0525'       => 600,
        'uni0526'       => 600,
        'uni0527'       => 600,
        'uni0528'       => 600,
        'uni0529'       => 600,
        'uni052A'       => 600,
        'uni052B'       => 600,
        'uni052C'       => 600,
        'uni052D'       => 600,
        'uni052E'       => 600,
        'uni052F'       => 600,
        'uni058A'       => 600,
        'uni058D'       => 600,
        'uni058E'       => 600,
        'uni058F'       => 600,
        'uni05A2'       => 600,
        'uni05BA'       => 600,
        'uni05C5'       => 600,
        'uni05C6'       => 600,
        'uni05C7'       => 600,
        'uni0600'       => 600,
        'uni0601'       => 600,
        'uni0602'       => 600,
        'uni0603'       => 600,
        'uni0604'       => 600,
        'uni0605'       => 600,
        'uni0606'       => 600,
        'uni0607'       => 600,
        'uni0608'       => 600,
        'uni0609'       => 600,
        'uni060A'       => 600,
        'uni060B'       => 600,
        'uni060D'       => 600,
        'uni060E'       => 600,
        'uni060F'       => 600,
        'uni0610'       => 600,
        'uni0611'       => 600,
        'uni0612'       => 600,
        'uni0613'       => 600,
        'uni0614'       => 600,
        'uni0615'       => 600,
        'uni0616'       => 600,
        'uni0617'       => 600,
        'uni0618'       => 600,
        'uni0619'       => 600,
        'uni061A'       => 600,
        'uni061C'       => 600,
        'uni061E'       => 600,
        'uni0620'       => 600,
        'uni063B'       => 600,
        'uni063C'       => 600,
        'uni063D'       => 600,
        'uni063E'       => 600,
        'uni063F'       => 600,
        'uni0653'       => 600,
        'uni0655'       => 600,
        'uni0656'       => 600,
        'uni0657'       => 600,
        'uni0658'       => 600,
        'uni0659'       => 600,
        'uni065A'       => 600,
        'uni065B'       => 600,
        'uni065C'       => 600,
        'uni065D'       => 600,
        'uni065E'       => 600,
        'uni065F'       => 600,
        'uni066E'       => 600,
        'uni066F'       => 600,
        'uni0670'       => 600,
        'uni0672'       => 600,
        'uni0673'       => 600,
        'uni0674'       => 600,
        'uni0675'       => 600,
        'uni0676'       => 600,
        'uni0678'       => 600,
        'uni067C'       => 600,
        'uni067D'       => 600,
        'uni0681'       => 600,
        'uni0682'       => 600,
        'uni0685'       => 600,
        'uni0689'       => 600,
        'uni068A'       => 600,
        'uni068B'       => 600,
        'uni068F'       => 600,
        'uni0690'       => 600,
        'uni0692'       => 600,
        'uni0693'       => 600,
        'uni0694'       => 600,
        'uni0695'       => 600,
        'uni0696'       => 600,
        'uni0697'       => 600,
        'uni0699'       => 600,
        'uni069A'       => 600,
        'uni069B'       => 600,
        'uni069C'       => 600,
        'uni069D'       => 600,
        'uni069E'       => 600,
        'uni069F'       => 600,
        'uni06A0'       => 600,
        'uni06A1'       => 600,
        'uni06A2'       => 600,
        'uni06A3'       => 600,
        'uni06A5'       => 600,
        'uni06A7'       => 600,
        'uni06A8'       => 600,
        'uni06AA'       => 600,
        'uni06AB'       => 600,
        'uni06AC'       => 600,
        'uni06AE'       => 600,
        'uni06B0'       => 600,
        'uni06B2'       => 600,
        'uni06B4'       => 600,
        'uni06B5'       => 600,
        'uni06B6'       => 600,
        'uni06B7'       => 600,
        'uni06B8'       => 600,
        'uni06B9'       => 600,
        'uni06BC'       => 600,
        'uni06BD'       => 600,
        'uni06BF'       => 600,
        'uni06C2'       => 600,
        'uni06C3'       => 600,
        'uni06C4'       => 600,
        'uni06CA'       => 600,
        'uni06CD'       => 600,
        'uni06CE'       => 600,
        'uni06CF'       => 600,
        'uni06D4'       => 600,
        'uni06D6'       => 600,
        'uni06D7'       => 600,
        'uni06D8'       => 600,
        'uni06D9'       => 600,
        'uni06DA'       => 600,
        'uni06DB'       => 600,
        'uni06DC'       => 600,
        'uni06DD'       => 600,
        'uni06DE'       => 600,
        'uni06DF'       => 600,
        'uni06E0'       => 600,
        'uni06E1'       => 600,
        'uni06E2'       => 600,
        'uni06E3'       => 600,
        'uni06E4'       => 600,
        'uni06E5'       => 600,
        'uni06E6'       => 600,
        'uni06E7'       => 600,
        'uni06E8'       => 600,
        'uni06E9'       => 600,
        'uni06EA'       => 600,
        'uni06EB'       => 600,
        'uni06EC'       => 600,
        'uni06ED'       => 600,
        'uni06EE'       => 600,
        'uni06EF'       => 600,
        'uni06FA'       => 600,
        'uni06FB'       => 600,
        'uni06FC'       => 600,
        'uni06FD'       => 600,
        'uni06FE'       => 600,
        'uni06FF'       => 600,
        'uni0750'       => 600,
        'uni0751'       => 600,
        'uni0752'       => 600,
        'uni0753'       => 600,
        'uni0754'       => 600,
        'uni0755'       => 600,
        'uni0756'       => 600,
        'uni0757'       => 600,
        'uni0758'       => 600,
        'uni0759'       => 600,
        'uni075A'       => 600,
        'uni075B'       => 600,
        'uni075C'       => 600,
        'uni075D'       => 600,
        'uni075E'       => 600,
        'uni075F'       => 600,
        'uni0760'       => 600,
        'uni0761'       => 600,
        'uni0762'       => 600,
        'uni0763'       => 600,
        'uni0764'       => 600,
        'uni0765'       => 600,
        'uni0766'       => 600,
        'uni0767'       => 600,
        'uni0768'       => 600,
        'uni0769'       => 600,
        'uni076A'       => 600,
        'uni076B'       => 600,
        'uni076C'       => 600,
        'uni076D'       => 600,
        'uni076E'       => 600,
        'uni076F'       => 600,
        'uni0770'       => 600,
        'uni0771'       => 600,
        'uni0772'       => 600,
        'uni0773'       => 600,
        'uni0774'       => 600,
        'uni0775'       => 600,
        'uni0776'       => 600,
        'uni0777'       => 600,
        'uni0778'       => 600,
        'uni0779'       => 600,
        'uni077A'       => 600,
        'uni077B'       => 600,
        'uni077C'       => 600,
        'uni077D'       => 600,
        'uni077E'       => 600,
        'uni077F'       => 600,
        'uni08A0'       => 600,
        'uni08A1'       => 600,
        'uni08A2'       => 600,
        'uni08A3'       => 600,
        'uni08A4'       => 600,
        'uni08A5'       => 600,
        'uni08A6'       => 600,
        'uni08A7'       => 600,
        'uni08A8'       => 600,
        'uni08A9'       => 600,
        'uni08AA'       => 600,
        'uni08AB'       => 600,
        'uni08AC'       => 600,
        'uni08AD'       => 600,
        'uni08AE'       => 600,
        'uni08AF'       => 600,
        'uni08B0'       => 600,
        'uni08B1'       => 600,
        'uni08B2'       => 600,
        'uni08B3'       => 600,
        'uni08B4'       => 600,
        'uni08B6'       => 600,
        'uni08B7'       => 600,
        'uni08B8'       => 600,
        'uni08B9'       => 600,
        'uni08BA'       => 600,
        'uni08BB'       => 600,
        'uni08BC'       => 600,
        'uni08BD'       => 600,
        'uni08D4'       => 600,
        'uni08D5'       => 600,
        'uni08D6'       => 600,
        'uni08D7'       => 600,
        'uni08D8'       => 600,
        'uni08D9'       => 600,
        'uni08DA'       => 600,
        'uni08DB'       => 600,
        'uni08DC'       => 600,
        'uni08DD'       => 600,
        'uni08DE'       => 600,
        'uni08DF'       => 600,
        'uni08E0'       => 600,
        'uni08E1'       => 600,
        'uni08E2'       => 600,
        'uni08E3'       => 600,
        'uni08E4'       => 600,
        'uni08E5'       => 600,
        'uni08E6'       => 600,
        'uni08E7'       => 600,
        'uni08E8'       => 600,
        'uni08E9'       => 600,
        'uni08EA'       => 600,
        'uni08EB'       => 600,
        'uni08EC'       => 600,
        'uni08ED'       => 600,
        'uni08EE'       => 600,
        'uni08EF'       => 600,
        'uni08F0'       => 600,
        'uni08F1'       => 600,
        'uni08F2'       => 600,
        'uni08F3'       => 600,
        'uni08F4'       => 600,
        'uni08F5'       => 600,
        'uni08F6'       => 600,
        'uni08F7'       => 600,
        'uni08F8'       => 600,
        'uni08F9'       => 600,
        'uni08FA'       => 600,
        'uni08FB'       => 600,
        'uni08FC'       => 600,
        'uni08FD'       => 600,
        'uni08FE'       => 600,
        'uni08FF'       => 600,
        'uni1D00'       => 600,
        'uni1D01'       => 600,
        'uni1D02'       => 600,
        'uni1D03'       => 600,
        'uni1D04'       => 600,
        'uni1D05'       => 600,
        'uni1D06'       => 600,
        'uni1D07'       => 600,
        'uni1D08'       => 600,
        'uni1D09'       => 600,
        'uni1D0A'       => 600,
        'uni1D0B'       => 600,
        'uni1D0C'       => 600,
        'uni1D0D'       => 600,
        'uni1D0E'       => 600,
        'uni1D0F'       => 600,
        'uni1D10'       => 600,
        'uni1D11'       => 600,
        'uni1D12'       => 600,
        'uni1D13'       => 600,
        'uni1D14'       => 600,
        'uni1D15'       => 600,
        'uni1D16'       => 600,
        'uni1D17'       => 600,
        'uni1D18'       => 600,
        'uni1D19'       => 600,
        'uni1D1A'       => 600,
        'uni1D1B'       => 600,
        'uni1D1C'       => 600,
        'uni1D1D'       => 600,
        'uni1D1E'       => 600,
        'uni1D1F'       => 600,
        'uni1D20'       => 600,
        'uni1D21'       => 600,
        'uni1D22'       => 600,
        'uni1D23'       => 600,
        'uni1D24'       => 600,
        'uni1D25'       => 600,
        'uni1D26'       => 600,
        'uni1D27'       => 600,
        'uni1D28'       => 600,
        'uni1D29'       => 600,
        'uni1D2A'       => 600,
        'uni1D2B'       => 600,
        'uni1D2C'       => 600,
        'uni1D2D'       => 600,
        'uni1D2E'       => 600,
        'uni1D2F'       => 600,
        'uni1D30'       => 600,
        'uni1D31'       => 600,
        'uni1D32'       => 600,
        'uni1D33'       => 600,
        'uni1D34'       => 600,
        'uni1D35'       => 600,
        'uni1D36'       => 600,
        'uni1D37'       => 600,
        'uni1D38'       => 600,
        'uni1D39'       => 600,
        'uni1D3A'       => 600,
        'uni1D3B'       => 600,
        'uni1D3C'       => 600,
        'uni1D3D'       => 600,
        'uni1D3E'       => 600,
        'uni1D3F'       => 600,
        'uni1D40'       => 600,
        'uni1D41'       => 600,
        'uni1D42'       => 600,
        'uni1D43'       => 600,
        'uni1D44'       => 600,
        'uni1D45'       => 600,
        'uni1D46'       => 600,
        'uni1D47'       => 600,
        'uni1D48'       => 600,
        'uni1D49'       => 600,
        'uni1D4A'       => 600,
        'uni1D4B'       => 600,
        'uni1D4C'       => 600,
        'uni1D4D'       => 600,
        'uni1D4E'       => 600,
        'uni1D4F'       => 600,
        'uni1D50'       => 600,
        'uni1D51'       => 600,
        'uni1D52'       => 600,
        'uni1D53'       => 600,
        'uni1D54'       => 600,
        'uni1D55'       => 600,
        'uni1D56'       => 600,
        'uni1D57'       => 600,
        'uni1D58'       => 600,
        'uni1D59'       => 600,
        'uni1D5A'       => 600,
        'uni1D5B'       => 600,
        'uni1D5C'       => 600,
        'uni1D5D'       => 600,
        'uni1D5E'       => 600,
        'uni1D5F'       => 600,
        'uni1D60'       => 600,
        'uni1D61'       => 600,
        'uni1D62'       => 600,
        'uni1D63'       => 600,
        'uni1D64'       => 600,
        'uni1D65'       => 600,
        'uni1D66'       => 600,
        'uni1D67'       => 600,
        'uni1D68'       => 600,
        'uni1D69'       => 600,
        'uni1D6A'       => 600,
        'uni1D6B'       => 600,
        'uni1D6C'       => 600,
        'uni1D6D'       => 600,
        'uni1D6E'       => 600,
        'uni1D6F'       => 600,
        'uni1D70'       => 600,
        'uni1D71'       => 600,
        'uni1D72'       => 600,
        'uni1D73'       => 600,
        'uni1D74'       => 600,
        'uni1D75'       => 600,
        'uni1D76'       => 600,
        'uni1D77'       => 600,
        'uni1D78'       => 600,
        'uni1D79'       => 600,
        'uni1D7A'       => 600,
        'uni1D7B'       => 600,
        'uni1D7C'       => 600,
        'uni1D7D'       => 600,
        'uni1D7E'       => 600,
        'uni1D7F'       => 600,
        'uni1D80'       => 600,
        'uni1D81'       => 600,
        'uni1D82'       => 600,
        'uni1D83'       => 600,
        'uni1D84'       => 600,
        'uni1D85'       => 600,
        'uni1D86'       => 600,
        'uni1D87'       => 600,
        'uni1D88'       => 600,
        'uni1D89'       => 600,
        'uni1D8A'       => 600,
        'uni1D8B'       => 600,
        'uni1D8C'       => 600,
        'uni1D8D'       => 600,
        'uni1D8E'       => 600,
        'uni1D8F'       => 600,
        'uni1D90'       => 600,
        'uni1D91'       => 600,
        'uni1D92'       => 600,
        'uni1D93'       => 600,
        'uni1D94'       => 600,
        'uni1D95'       => 600,
        'uni1D96'       => 600,
        'uni1D97'       => 600,
        'uni1D98'       => 600,
        'uni1D99'       => 600,
        'uni1D9A'       => 600,
        'uni1D9B'       => 600,
        'uni1D9C'       => 600,
        'uni1D9D'       => 600,
        'uni1D9E'       => 600,
        'uni1D9F'       => 600,
        'uni1DA0'       => 600,
        'uni1DA1'       => 600,
        'uni1DA2'       => 600,
        'uni1DA3'       => 600,
        'uni1DA4'       => 600,
        'uni1DA5'       => 600,
        'uni1DA6'       => 600,
        'uni1DA7'       => 600,
        'uni1DA8'       => 600,
        'uni1DA9'       => 600,
        'uni1DAA'       => 600,
        'uni1DAB'       => 600,
        'uni1DAC'       => 600,
        'uni1DAD'       => 600,
        'uni1DAE'       => 600,
        'uni1DAF'       => 600,
        'uni1DB0'       => 600,
        'uni1DB1'       => 600,
        'uni1DB2'       => 600,
        'uni1DB3'       => 600,
        'uni1DB4'       => 600,
        'uni1DB5'       => 600,
        'uni1DB6'       => 600,
        'uni1DB7'       => 600,
        'uni1DB8'       => 600,
        'uni1DB9'       => 600,
        'uni1DBA'       => 600,
        'uni1DBB'       => 600,
        'uni1DBC'       => 600,
        'uni1DBD'       => 600,
        'uni1DBE'       => 600,
        'uni1DBF'       => 600,
        'uni1DC0'       => 600,
        'uni1DC1'       => 600,
        'uni1DC2'       => 600,
        'uni1DC3'       => 600,
        'uni1DC4'       => 600,
        'uni1DC5'       => 600,
        'uni1DC6'       => 600,
        'uni1DC7'       => 600,
        'uni1DC8'       => 600,
        'uni1DC9'       => 600,
        'uni1DCA'       => 600,
        'uni1DFE'       => 600,
        'uni1DFF'       => 600,
        'uni1E9C'       => 600,
        'uni1E9D'       => 600,
        'uni1E9E'       => 600,
        'uni1E9F'       => 600,
        'uni1EFA'       => 600,
        'uni1EFB'       => 600,
        'uni1EFC'       => 600,
        'uni1EFD'       => 600,
        'uni1EFE'       => 600,
        'uni1EFF'       => 600,
        'uni1F00'       => 600,
        'uni1F01'       => 600,
        'uni1F02'       => 600,
        'uni1F03'       => 600,
        'uni1F04'       => 600,
        'uni1F05'       => 600,
        'uni1F06'       => 600,
        'uni1F07'       => 600,
        'uni1F08'       => 600,
        'uni1F09'       => 600,
        'uni1F0A'       => 600,
        'uni1F0B'       => 600,
        'uni1F0C'       => 600,
        'uni1F0D'       => 600,
        'uni1F0E'       => 600,
        'uni1F0F'       => 600,
        'uni1F10'       => 600,
        'uni1F11'       => 600,
        'uni1F12'       => 600,
        'uni1F13'       => 600,
        'uni1F14'       => 600,
        'uni1F15'       => 600,
        'uni1F18'       => 600,
        'uni1F19'       => 600,
        'uni1F1A'       => 600,
        'uni1F1B'       => 600,
        'uni1F1C'       => 600,
        'uni1F1D'       => 600,
        'uni1F20'       => 600,
        'uni1F21'       => 600,
        'uni1F22'       => 600,
        'uni1F23'       => 600,
        'uni1F24'       => 600,
        'uni1F25'       => 600,
        'uni1F26'       => 600,
        'uni1F27'       => 600,
        'uni1F28'       => 600,
        'uni1F29'       => 600,
        'uni1F2A'       => 600,
        'uni1F2B'       => 600,
        'uni1F2C'       => 600,
        'uni1F2D'       => 600,
        'uni1F2E'       => 600,
        'uni1F2F'       => 600,
        'uni1F30'       => 600,
        'uni1F31'       => 600,
        'uni1F32'       => 600,
        'uni1F33'       => 600,
        'uni1F34'       => 600,
        'uni1F35'       => 600,
        'uni1F36'       => 600,
        'uni1F37'       => 600,
        'uni1F38'       => 600,
        'uni1F39'       => 600,
        'uni1F3A'       => 600,
        'uni1F3B'       => 600,
        'uni1F3C'       => 600,
        'uni1F3D'       => 600,
        'uni1F3E'       => 600,
        'uni1F3F'       => 600,
        'uni1F40'       => 600,
        'uni1F41'       => 600,
        'uni1F42'       => 600,
        'uni1F43'       => 600,
        'uni1F44'       => 600,
        'uni1F45'       => 600,
        'uni1F48'       => 600,
        'uni1F49'       => 600,
        'uni1F4A'       => 600,
        'uni1F4B'       => 600,
        'uni1F4C'       => 600,
        'uni1F4D'       => 600,
        'uni1F50'       => 600,
        'uni1F51'       => 600,
        'uni1F52'       => 600,
        'uni1F53'       => 600,
        'uni1F54'       => 600,
        'uni1F55'       => 600,
        'uni1F56'       => 600,
        'uni1F57'       => 600,
        'uni1F59'       => 600,
        'uni1F5B'       => 600,
        'uni1F5D'       => 600,
        'uni1F5F'       => 600,
        'uni1F60'       => 600,
        'uni1F61'       => 600,
        'uni1F62'       => 600,
        'uni1F63'       => 600,
        'uni1F64'       => 600,
        'uni1F65'       => 600,
        'uni1F66'       => 600,
        'uni1F67'       => 600,
        'uni1F68'       => 600,
        'uni1F69'       => 600,
        'uni1F6A'       => 600,
        'uni1F6B'       => 600,
        'uni1F6C'       => 600,
        'uni1F6D'       => 600,
        'uni1F6E'       => 600,
        'uni1F6F'       => 600,
        'uni1F70'       => 600,
        'uni1F71'       => 600,
        'uni1F72'       => 600,
        'uni1F73'       => 600,
        'uni1F74'       => 600,
        'uni1F75'       => 600,
        'uni1F76'       => 600,
        'uni1F77'       => 600,
        'uni1F78'       => 600,
        'uni1F79'       => 600,
        'uni1F7A'       => 600,
        'uni1F7B'       => 600,
        'uni1F7C'       => 600,
        'uni1F7D'       => 600,
        'uni1F80'       => 600,
        'uni1F81'       => 600,
        'uni1F82'       => 600,
        'uni1F83'       => 600,
        'uni1F84'       => 600,
        'uni1F85'       => 600,
        'uni1F86'       => 600,
        'uni1F87'       => 600,
        'uni1F88'       => 600,
        'uni1F89'       => 600,
        'uni1F8A'       => 600,
        'uni1F8B'       => 600,
        'uni1F8C'       => 600,
        'uni1F8D'       => 600,
        'uni1F8E'       => 600,
        'uni1F8F'       => 600,
        'uni1F90'       => 600,
        'uni1F91'       => 600,
        'uni1F92'       => 600,
        'uni1F93'       => 600,
        'uni1F94'       => 600,
        'uni1F95'       => 600,
        'uni1F96'       => 600,
        'uni1F97'       => 600,
        'uni1F98'       => 600,
        'uni1F99'       => 600,
        'uni1F9A'       => 600,
        'uni1F9B'       => 600,
        'uni1F9C'       => 600,
        'uni1F9D'       => 600,
        'uni1F9E'       => 600,
        'uni1F9F'       => 600,
        'uni1FA0'       => 600,
        'uni1FA1'       => 600,
        'uni1FA2'       => 600,
        'uni1FA3'       => 600,
        'uni1FA4'       => 600,
        'uni1FA5'       => 600,
        'uni1FA6'       => 600,
        'uni1FA7'       => 600,
        'uni1FA8'       => 600,
        'uni1FA9'       => 600,
        'uni1FAA'       => 600,
        'uni1FAB'       => 600,
        'uni1FAC'       => 600,
        'uni1FAD'       => 600,
        'uni1FAE'       => 600,
        'uni1FAF'       => 600,
        'uni1FB0'       => 600,
        'uni1FB1'       => 600,
        'uni1FB2'       => 600,
        'uni1FB3'       => 600,
        'uni1FB4'       => 600,
        'uni1FB6'       => 600,
        'uni1FB7'       => 600,
        'uni1FB8'       => 600,
        'uni1FB9'       => 600,
        'uni1FBA'       => 600,
        'uni1FBB'       => 600,
        'uni1FBC'       => 600,
        'uni1FBD'       => 600,
        'uni1FBE'       => 600,
        'uni1FBF'       => 600,
        'uni1FC0'       => 600,
        'uni1FC1'       => 600,
        'uni1FC2'       => 600,
        'uni1FC3'       => 600,
        'uni1FC4'       => 600,
        'uni1FC6'       => 600,
        'uni1FC7'       => 600,
        'uni1FC8'       => 600,
        'uni1FC9'       => 600,
        'uni1FCA'       => 600,
        'uni1FCB'       => 600,
        'uni1FCC'       => 600,
        'uni1FCD'       => 600,
        'uni1FCE'       => 600,
        'uni1FCF'       => 600,
        'uni1FD0'       => 600,
        'uni1FD1'       => 600,
        'uni1FD2'       => 600,
        'uni1FD3'       => 600,
        'uni1FD6'       => 600,
        'uni1FD7'       => 600,
        'uni1FD8'       => 600,
        'uni1FD9'       => 600,
        'uni1FDA'       => 600,
        'uni1FDB'       => 600,
        'uni1FDD'       => 600,
        'uni1FDE'       => 600,
        'uni1FDF'       => 600,
        'uni1FE0'       => 600,
        'uni1FE1'       => 600,
        'uni1FE2'       => 600,
        'uni1FE3'       => 600,
        'uni1FE4'       => 600,
        'uni1FE5'       => 600,
        'uni1FE6'       => 600,
        'uni1FE7'       => 600,
        'uni1FE8'       => 600,
        'uni1FE9'       => 600,
        'uni1FEA'       => 600,
        'uni1FEB'       => 600,
        'uni1FEC'       => 600,
        'uni1FED'       => 600,
        'uni1FEE'       => 600,
        'uni1FEF'       => 600,
        'uni1FF2'       => 600,
        'uni1FF3'       => 600,
        'uni1FF4'       => 600,
        'uni1FF6'       => 600,
        'uni1FF7'       => 600,
        'uni1FF8'       => 600,
        'uni1FF9'       => 600,
        'uni1FFA'       => 600,
        'uni1FFB'       => 600,
        'uni1FFC'       => 600,
        'uni1FFD'       => 600,
        'uni1FFE'       => 600,
        'uni201F'       => 600,
        'uni203D'       => 600,
        'uni205E'       => 600,
        'uni2090'       => 600,
        'uni2091'       => 600,
        'uni2092'       => 600,
        'uni2093'       => 600,
        'uni2094'       => 600,
        'uni20A0'       => 600,
        'uni20A5'       => 600,
        'uni20A6'       => 600,
        'uni20A8'       => 600,
        'uni20AD'       => 600,
        'uni20AE'       => 600,
        'uni20AF'       => 600,
        'uni20B0'       => 600,
        'uni20B1'       => 600,
        'uni20B2'       => 600,
        'uni20B3'       => 600,
        'uni20B4'       => 600,
        'uni20B5'       => 600,
        'uni20B6'       => 600,
        'uni20B7'       => 600,
        'uni20B8'       => 600,
        'uni20B9'       => 600,
        'uni20BA'       => 600,
        'uni20BB'       => 600,
        'uni20BC'       => 600,
        'uni20BD'       => 600,
        'uni20BE'       => 600,
        'uni20BF'       => 600,
        'uni20F0'       => 600,
        'uni214D'       => 600,
        'uni214E'       => 600,
        'uni2184'       => 600,
        'uni2C60'       => 600,
        'uni2C61'       => 600,
        'uni2C62'       => 600,
        'uni2C63'       => 600,
        'uni2C64'       => 600,
        'uni2C65'       => 600,
        'uni2C66'       => 600,
        'uni2C67'       => 600,
        'uni2C68'       => 600,
        'uni2C69'       => 600,
        'uni2C6A'       => 600,
        'uni2C6B'       => 600,
        'uni2C6C'       => 600,
        'uni2C6D'       => 600,
        'uni2C6E'       => 600,
        'uni2C6F'       => 600,
        'uni2C70'       => 600,
        'uni2C71'       => 600,
        'uni2C72'       => 600,
        'uni2C73'       => 600,
        'uni2C74'       => 600,
        'uni2C75'       => 600,
        'uni2C76'       => 600,
        'uni2C77'       => 600,
        'uni2C78'       => 600,
        'uni2C79'       => 600,
        'uni2C7A'       => 600,
        'uni2C7B'       => 600,
        'uni2C7C'       => 600,
        'uni2C7D'       => 600,
        'uni2C7E'       => 600,
        'uni2C7F'       => 600,
        'uni2E17'       => 600,
        'uniA717'       => 600,
        'uniA718'       => 600,
        'uniA719'       => 600,
        'uniA71A'       => 600,
        'uniA71B'       => 600,
        'uniA71C'       => 600,
        'uniA71D'       => 600,
        'uniA71E'       => 600,
        'uniA71F'       => 600,
        'uniA720'       => 600,
        'uniA721'       => 600,
        'uniA788'       => 600,
        'uniA789'       => 600,
        'uniA78A'       => 600,
        'uniA78B'       => 600,
        'uniA78C'       => 600,
        'uniF301'       => 600,
        'uniFB05'       => 600,
        'uniFB06'       => 600,
        'uniFB13'       => 600,
        'uniFB14'       => 600,
        'uniFB15'       => 600,
        'uniFB16'       => 600,
        'uniFB17'       => 600,
        'uniFB1D'       => 600,
        'uniFB1E'       => 600,
        'uniFB21'       => 600,
        'uniFB22'       => 600,
        'uniFB23'       => 600,
        'uniFB24'       => 600,
        'uniFB25'       => 600,
        'uniFB26'       => 600,
        'uniFB27'       => 600,
        'uniFB28'       => 600,
        'uniFB29'       => 600,
        'uniFB50'       => 600,
        'uniFB51'       => 600,
        'uniFB52'       => 600,
        'uniFB53'       => 600,
        'uniFB54'       => 600,
        'uniFB55'       => 600,
        'uniFB56'       => 600,
        'uniFB5A'       => 600,
        'uniFB5B'       => 600,
        'uniFB5C'       => 600,
        'uniFB5D'       => 600,
        'uniFB5E'       => 600,
        'uniFB5F'       => 600,
        'uniFB60'       => 600,
        'uniFB61'       => 600,
        'uniFB62'       => 600,
        'uniFB63'       => 600,
        'uniFB64'       => 600,
        'uniFB65'       => 600,
        'uniFB66'       => 600,
        'uniFB6A'       => 600,
        'uniFB6E'       => 600,
        'uniFB6F'       => 600,
        'uniFB70'       => 600,
        'uniFB71'       => 600,
        'uniFB72'       => 600,
        'uniFB73'       => 600,
        'uniFB74'       => 600,
        'uniFB75'       => 600,
        'uniFB76'       => 600,
        'uniFB77'       => 600,
        'uniFB78'       => 600,
        'uniFB79'       => 600,
        'uniFB7A'       => 600,
        'uniFB7E'       => 600,
        'uniFB7F'       => 600,
        'uniFB80'       => 600,
        'uniFB81'       => 600,
        'uniFB82'       => 600,
        'uniFB83'       => 600,
        'uniFB84'       => 600,
        'uniFB85'       => 600,
        'uniFB86'       => 600,
        'uniFB87'       => 600,
        'uniFB88'       => 600,
        'uniFB8A'       => 600,
        'uniFB8C'       => 600,
        'uniFB8E'       => 600,
        'uniFB8F'       => 600,
        'uniFB90'       => 600,
        'uniFB91'       => 600,
        'uniFB92'       => 600,
        'uniFB96'       => 600,
        'uniFB97'       => 600,
        'uniFB98'       => 600,
        'uniFB99'       => 600,
        'uniFB9A'       => 600,
        'uniFB9B'       => 600,
        'uniFB9C'       => 600,
        'uniFB9D'       => 600,
        'uniFB9E'       => 600,
        'uniFBA0'       => 600,
        'uniFBA1'       => 600,
        'uniFBA2'       => 600,
        'uniFBA3'       => 600,
        'uniFBA6'       => 600,
        'uniFBAE'       => 600,
        'uniFBB0'       => 600,
        'uniFBB1'       => 600,
        'uniFBB2'       => 600,
        'uniFBB3'       => 600,
        'uniFBB4'       => 600,
        'uniFBB5'       => 600,
        'uniFBB6'       => 600,
        'uniFBB7'       => 600,
        'uniFBB8'       => 600,
        'uniFBB9'       => 600,
        'uniFBBA'       => 600,
        'uniFBBB'       => 600,
        'uniFBBC'       => 600,
        'uniFBBD'       => 600,
        'uniFBBE'       => 600,
        'uniFBBF'       => 600,
        'uniFBC0'       => 600,
        'uniFBC1'       => 600,
        'uniFBD3'       => 600,
        'uniFBD4'       => 600,
        'uniFBD5'       => 600,
        'uniFBD6'       => 600,
        'uniFBD7'       => 600,
        'uniFBD8'       => 600,
        'uniFBD9'       => 600,
        'uniFBDA'       => 600,
        'uniFBDB'       => 600,
        'uniFBDC'       => 600,
        'uniFBDD'       => 600,
        'uniFBDE'       => 600,
        'uniFBDF'       => 600,
        'uniFBE0'       => 600,
        'uniFBE1'       => 600,
        'uniFBE2'       => 600,
        'uniFBE3'       => 600,
        'uniFBE4'       => 600,
        'uniFBE5'       => 600,
        'uniFBE6'       => 600,
        'uniFBE7'       => 600,
        'uniFBE8'       => 600,
        'uniFBE9'       => 600,
        'uniFBEA'       => 600,
        'uniFBEB'       => 600,
        'uniFBEC'       => 600,
        'uniFBED'       => 600,
        'uniFBEE'       => 600,
        'uniFBEF'       => 600,
        'uniFBF0'       => 600,
        'uniFBF1'       => 600,
        'uniFBF2'       => 600,
        'uniFBF3'       => 600,
        'uniFBF4'       => 600,
        'uniFBF5'       => 600,
        'uniFBF6'       => 600,
        'uniFBF7'       => 600,
        'uniFBF8'       => 600,
        'uniFBF9'       => 600,
        'uniFBFA'       => 600,
        'uniFBFB'       => 600,
        'uniFBFC'       => 600,
        'uniFBFD'       => 600,
        'uniFC09'       => 600,
        'uniFC12'       => 600,
        'uniFC31'       => 600,
        'uniFC32'       => 600,
        'uniFC3F'       => 600,
        'uniFC40'       => 600,
        'uniFC41'       => 600,
        'uniFC42'       => 600,
        'uniFC43'       => 600,
        'uniFC44'       => 600,
        'uniFC4F'       => 600,
        'uniFC59'       => 600,
        'uniFC63'       => 600,
        'uniFC6A'       => 600,
        'uniFC6E'       => 600,
        'uniFC6F'       => 600,
        'uniFC70'       => 600,
        'uniFC74'       => 600,
        'uniFC75'       => 600,
        'uniFC8E'       => 600,
        'uniFC8F'       => 600,
        'uniFC91'       => 600,
        'uniFC9C'       => 600,
        'uniFC9D'       => 600,
        'uniFC9E'       => 600,
        'uniFCA0'       => 600,
        'uniFCA3'       => 600,
        'uniFCA5'       => 600,
        'uniFCA6'       => 600,
        'uniFCA8'       => 600,
        'uniFCAA'       => 600,
        'uniFCAC'       => 600,
        'uniFCB0'       => 600,
        'uniFCCD'       => 600,
        'uniFCCE'       => 600,
        'uniFCCF'       => 600,
        'uniFCD0'       => 600,
        'uniFCD3'       => 600,
        'uniFCD4'       => 600,
        'uniFCD6'       => 600,
        'uniFCD8'       => 600,
        'uniFCDA'       => 600,
        'uniFCDB'       => 600,
        'uniFCDC'       => 600,
        'uniFCF2'       => 600,
        'uniFCF3'       => 600,
        'uniFCF4'       => 600,
        'uniFD30'       => 600,
        'uniFD3C'       => 600,
        'uniFD3D'       => 600,
        'uniFDF4'       => 600,
        'uniFDFB'       => 600,
        'uniFDFC'       => 600,
        'uniFE20'       => 600,
        'uniFE21'       => 600,
        'uniFE22'       => 600,
        'uniFE23'       => 600,
        'uniFE70'       => 600,
        'uniFE71'       => 600,
        'uniFE72'       => 600,
        'uniFE73'       => 600,
        'uniFE74'       => 600,
        'uniFE76'       => 600,
        'uniFE77'       => 600,
        'uniFE78'       => 600,
        'uniFE79'       => 600,
        'uniFE7A'       => 600,
        'uniFE7B'       => 600,
        'uniFE7C'       => 600,
        'uniFE7D'       => 600,
        'uniFE7E'       => 600,
        'uniFE7F'       => 600,
        'uniFE80'       => 600,
        'uniFE81'       => 600,
        'uniFE83'       => 600,
        'uniFE85'       => 600,
        'uniFE87'       => 600,
        'uniFE89'       => 600,
        'uniFE8D'       => 600,
        'uniFE8F'       => 600,
        'uniFE93'       => 600,
        'uniFE95'       => 600,
        'uniFE99'       => 600,
        'uniFE9D'       => 600,
        'uniFEA1'       => 600,
        'uniFEA5'       => 600,
        'uniFEA9'       => 600,
        'uniFEAB'       => 600,
        'uniFEAD'       => 600,
        'uniFEAF'       => 600,
        'uniFEB1'       => 600,
        'uniFEB5'       => 600,
        'uniFEB9'       => 600,
        'uniFEBD'       => 600,
        'uniFEC1'       => 600,
        'uniFEC5'       => 600,
        'uniFEC9'       => 600,
        'uniFECD'       => 600,
        'uniFED1'       => 600,
        'uniFED5'       => 600,
        'uniFED9'       => 600,
        'uniFEDD'       => 600,
        'uniFEE1'       => 600,
        'uniFEE5'       => 600,
        'uniFEE9'       => 600,
        'uniFEED'       => 600,
        'uniFEEF'       => 600,
        'uniFEF1'       => 600,
        'uniFFFC'       => 600,
        'uogonek'       => 600,
        'upblock'       => 600,
        'upperdothebrew'       => 600,
        'upsilon'       => 600,
        'upsilondieresis'       => 600,
        'upsilondieresistonos'       => 600,
        'upsilonlatin'       => 600,
        'upsilontonos'       => 600,
        'uptackbelowcmb'       => 600,
        'uptackmod'       => 600,
        'uring'       => 600,
        'ustraightcyrillic'       => 600,
        'ustraightstrokecyrillic'       => 600,
        'utilde'       => 600,
        'utildeacute'       => 600,
        'utildebelow'       => 600,
        'v'       => 600,
        'vdotbelow'       => 600,
        'vehfinalarabic'       => 600,
        'vehinitialarabic'       => 600,
        'vehmedialarabic'       => 600,
        'verticallineabovecmb'       => 600,
        'verticallinebelowcmb'       => 600,
        'verticallinelowmod'       => 600,
        'verticallinemod'       => 600,
        'vewarmenian'       => 600,
        'vhook'       => 600,
        'voarmenian'       => 600,
        'vtilde'       => 600,
        'vturned'       => 600,
        'w'       => 600,
        'wacute'       => 600,
        'wawfinalarabic'       => 600,
        'wawhamzaabovefinalarabic'       => 600,
        'wcircumflex'       => 600,
        'wdieresis'       => 600,
        'wdotaccent'       => 600,
        'wdotbelow'       => 600,
        'wgrave'       => 600,
        'won'       => 600,
        'wring'       => 600,
        'wsuperior'       => 600,
        'wturned'       => 600,
        'wynn'       => 600,
        'x'       => 600,
        'xabovecmb'       => 600,
        'xdieresis'       => 600,
        'xdotaccent'       => 600,
        'xeharmenian'       => 600,
        'xi'       => 600,
        'xsuperior'       => 600,
        'y'       => 600,
        'yacute'       => 600,
        'ycircumflex'       => 600,
        'ydieresis'       => 600,
        'ydotaccent'       => 600,
        'ydotbelow'       => 600,
        'yehbarreefinalarabic'       => 600,
        'yehfinalarabic'       => 600,
        'yehhamzaabovefinalarabic'       => 600,
        'yehhamzaaboveinitialarabic'       => 600,
        'yehhamzaabovemedialarabic'       => 600,
        'yehmeeminitialarabic'       => 600,
        'yehmeemisolatedarabic'       => 600,
        'yehnoonfinalarabic'       => 600,
        'yehthreedotsbelowarabic'       => 600,
        'yen'       => 600,
        'yerahbenyomohebrew'       => 600,
        'yerudieresiscyrillic'       => 600,
        'yetivhebrew'       => 600,
        'ygrave'       => 600,
        'yhook'       => 600,
        'yhookabove'       => 600,
        'yiarmenian'       => 600,
        'yiwnarmenian'       => 600,
        'yoddagesh'       => 600,
        'yotgreek'       => 600,
        'ypogegrammeni'       => 600,
        'ypogegrammenigreekcmb'       => 600,
        'yr'       => 600,
        'yring'       => 600,
        'ysuperior'       => 600,
        'ytilde'       => 600,
        'yturned'       => 600,
        'yusbigcyrillic'       => 600,
        'yusbigiotifiedcyrillic'       => 600,
        'yuslittlecyrillic'       => 600,
        'yuslittleiotifiedcyrillic'       => 600,
        'z'       => 600,
        'zaarmenian'       => 600,
        'zacute'       => 600,
        'zahfinalarabic'       => 600,
        'zahinitialarabic'       => 600,
        'zahmedialarabic'       => 600,
        'zainfinalarabic'       => 600,
        'zaqefgadolhebrew'       => 600,
        'zaqefqatanhebrew'       => 600,
        'zarqahebrew'       => 600,
        'zayindagesh'       => 600,
        'zcaron'       => 600,
        'zcircumflex'       => 600,
        'zcurl'       => 600,
        'zdotaccent'       => 600,
        'zdotbelow'       => 600,
        'zedescendercyrillic'       => 600,
        'zedieresiscyrillic'       => 600,
        'zero'       => 600,
        'zeropersian'       => 600,
        'zeta'       => 600,
        'zhearmenian'       => 600,
        'zhebrevecyrillic'       => 600,
        'zhedescendercyrillic'       => 600,
        'zhedieresiscyrillic'       => 600,
        'zinorhebrew'       => 600,
        'zlinebelow'       => 600,
        'zretroflexhook'       => 600,
        'zstroke'       => 600,
    },
    'wxold' => {
        'A' => '600',               # U+0041
        'a' => '600',               # U+0061
        'Aacute' => '600',          # U+00C1
        'aacute' => '600',          # U+00E1
        'Abreve' => '600',          # U+0102
        'abreve' => '600',          # U+0103
        'Acircumflex' => '600',     # U+00C2
        'acircumflex' => '600',     # U+00E2
        'acute' => '600',           # U+00B4
        'Adieresis' => '600',       # U+00C4
        'adieresis' => '600',       # U+00E4
        'AE' => '600',              # U+00C6
        'ae' => '600',              # U+00E6
        'Agrave' => '600',          # U+00C0
        'agrave' => '600',          # U+00E0
        'Amacron' => '600',         # U+0100
        'amacron' => '600',         # U+0101
        'ampersand' => '600',       # U+0026
        'Aogonek' => '600',         # U+0104
        'aogonek' => '600',         # U+0105
        'Aring' => '600',           # U+00C5
        'aring' => '600',           # U+00E5
        'asciicircum' => '600',     # U+005E
        'asciitilde' => '600',      # U+007E
        'asterisk' => '600',        # U+002A
        'at' => '600',              # U+0040
        'Atilde' => '600',          # U+00C3
        'atilde' => '600',          # U+00E3
        'B' => '600',               # U+0042
        'b' => '600',               # U+0062
        'backslash' => '600',       # U+005C
        'bar' => '600',             # U+007C
        'braceleft' => '600',       # U+007B
        'braceright' => '600',      # U+007D
        'bracketleft' => '600',     # U+005B
        'bracketright' => '600',    # U+005D
        'breve' => '600',           # U+02D8
        'brokenbar' => '600',       # U+00A6
        'bullet' => '600',          # U+2022
        'C' => '600',               # U+0043
        'c' => '600',               # U+0063
        'Cacute' => '600',          # U+0106
        'cacute' => '600',          # U+0107
        'caron' => '600',           # U+02C7
        'Ccaron' => '600',          # U+010C
        'ccaron' => '600',          # U+010D
        'Ccedilla' => '600',        # U+00C7
        'ccedilla' => '600',        # U+00E7
        'cedilla' => '600',         # U+00B8
        'cent' => '600',            # U+00A2
        'circumflex' => '600',      # U+02C6
        'colon' => '600',           # U+003A
        'comma' => '600',           # U+002C
        'commaaccent' => '600',     # U+F6C3
        'copyright' => '600',       # U+00A9
        'currency' => '600',        # U+00A4
        'D' => '600',               # U+0044
        'd' => '600',               # U+0064
        'dagger' => '600',          # U+2020
        'daggerdbl' => '600',       # U+2021
        'Dcaron' => '600',          # U+010E
        'dcaron' => '600',          # U+010F
        'Dcroat' => '600',          # U+0110
        'dcroat' => '600',          # U+0111
        'degree' => '600',          # U+00B0
        'Delta' => '600',           # U+0394
        'dieresis' => '600',        # U+00A8
        'divide' => '600',          # U+00F7
        'dollar' => '600',          # U+0024
        'dotaccent' => '600',       # U+02D9
        'dotlessi' => '600',        # U+0131
        'E' => '600',               # U+0045
        'e' => '600',               # U+0065
        'Eacute' => '600',          # U+00C9
        'eacute' => '600',          # U+00E9
        'Ecaron' => '600',          # U+011A
        'ecaron' => '600',          # U+011B
        'Ecircumflex' => '600',     # U+00CA
        'ecircumflex' => '600',     # U+00EA
        'Edieresis' => '600',       # U+00CB
        'edieresis' => '600',       # U+00EB
        'Edotaccent' => '600',      # U+0116
        'edotaccent' => '600',      # U+0117
        'Egrave' => '600',          # U+00C8
        'egrave' => '600',          # U+00E8
        'eight' => '600',           # U+0038
        'ellipsis' => '600',        # U+2026
        'Emacron' => '600',         # U+0112
        'emacron' => '600',         # U+0113
        'emdash' => '600',          # U+2014
        'endash' => '600',          # U+2013
        'Eogonek' => '600',         # U+0118
        'eogonek' => '600',         # U+0119
        'equal' => '600',           # U+003D
        'Eth' => '600',             # U+00D0
        'eth' => '600',             # U+00F0
        'Euro' => '600',            # U+20AC
        'exclam' => '600',          # U+0021
        'exclamdown' => '600',      # U+00A1
        'F' => '600',               # U+0046
        'f' => '600',               # U+0066
        'fi' => '600',              # U+FB01
        'five' => '600',            # U+0035
        'fl' => '600',              # U+FB02
        'florin' => '600',          # U+0192
        'four' => '600',            # U+0034
        'fraction' => '600',        # U+2044
        'G' => '600',               # U+0047
        'g' => '600',               # U+0067
        'Gbreve' => '600',          # U+011E
        'gbreve' => '600',          # U+011F
        'Gcommaaccent' => '600',    # U+0122
        'gcommaaccent' => '600',    # U+0123
        'germandbls' => '600',      # U+00DF
        'grave' => '600',           # U+0060
        'greater' => '600',         # U+003E
        'greaterequal' => '600',    # U+2265
        'guillemotleft' => '600',   # U+00AB
        'guillemotright' => '600',  # U+00BB
        'guilsinglleft' => '600',   # U+2039
        'guilsinglright' => '600',  # U+203A
        'H' => '600',               # U+0048
        'h' => '600',               # U+0068
        'hungarumlaut' => '600',    # U+02DD
        'dblgravecmb' => '600',     # U+030F
        'hyphen' => '600',          # U+002D
        'I' => '600',               # U+0049
        'i' => '600',               # U+0069
        'Iacute' => '600',          # U+00CD
        'iacute' => '600',          # U+00ED
        'Icircumflex' => '600',     # U+00CE
        'icircumflex' => '600',     # U+00EE
        'Idieresis' => '600',       # U+00CF
        'idieresis' => '600',       # U+00EF
        'Idotaccent' => '600',      # U+0130
        'Igrave' => '600',          # U+00CC
        'igrave' => '600',          # U+00EC
        'Imacron' => '600',         # U+012A
        'imacron' => '600',         # U+012B
        'Iogonek' => '600',         # U+012E
        'iogonek' => '600',         # U+012F
        'J' => '600',               # U+004A
        'j' => '600',               # U+006A
        'K' => '600',               # U+004B
        'k' => '600',               # U+006B
        'Kcommaaccent' => '600',    # U+0136
        'kcommaaccent' => '600',    # U+0137
        'L' => '600',               # U+004C
        'l' => '600',               # U+006C
        'Lacute' => '600',          # U+0139
        'lacute' => '600',          # U+013A
        'Lcaron' => '600',          # U+013D
        'lcaron' => '600',          # U+013E
        'Lcommaaccent' => '600',    # U+013B
        'lcommaaccent' => '600',    # U+013C
        'less' => '600',            # U+003C
        'lessequal' => '600',       # U+2264
        'logicalnot' => '600',      # U+00AC
        'lozenge' => '600',         # U+25CA
        'Lslash' => '600',          # U+0141
        'lslash' => '600',          # U+0142
        'M' => '600',               # U+004D
        'm' => '600',               # U+006D
        'macron' => '600',          # U+00AF
        'minus' => '600',           # U+2212
        'mu' => '600',              # U+00B5
        'multiply' => '600',        # U+00D7
        'N' => '600',               # U+004E
        'n' => '600',               # U+006E
        'Nacute' => '600',          # U+0143
        'nacute' => '600',          # U+0144
        'Ncaron' => '600',          # U+0147
        'ncaron' => '600',          # U+0148
        'Ncommaaccent' => '600',    # U+0145
        'ncommaaccent' => '600',    # U+0146
        'nine' => '600',            # U+0039
        'notequal' => '600',        # U+2260
        'Ntilde' => '600',          # U+00D1
        'ntilde' => '600',          # U+00F1
        'numbersign' => '600',      # U+0023
        'O' => '600',               # U+004F
        'o' => '600',               # U+006F
        'Oacute' => '600',          # U+00D3
        'oacute' => '600',          # U+00F3
        'Ocircumflex' => '600',     # U+00D4
        'ocircumflex' => '600',     # U+00F4
        'Odieresis' => '600',       # U+00D6
        'odieresis' => '600',       # U+00F6
        'OE' => '600',              # U+0152
        'oe' => '600',              # U+0153
        'ogonek' => '600',          # U+02DB
        'Ograve' => '600',          # U+00D2
        'ograve' => '600',          # U+00F2
        'Ohungarumlaut' => '600',   # U+0150
        'ohungarumlaut' => '600',   # U+0151
        'Omacron' => '600',         # U+014C
        'omacron' => '600',         # U+014D
        'one' => '600',             # U+0031
        'onehalf' => '600',         # U+00BD
        'onequarter' => '600',      # U+00BC
        'onesuperior' => '600',     # U+00B9
        'ordfeminine' => '600',     # U+00AA
        'ordmasculine' => '600',    # U+00BA
        'Oslash' => '600',          # U+00D8
        'oslash' => '600',          # U+00F8
        'Otilde' => '600',          # U+00D5
        'otilde' => '600',          # U+00F5
        'P' => '600',               # U+0050
        'p' => '600',               # U+0070
        'paragraph' => '600',       # U+00B6
        'parenleft' => '600',       # U+0028
        'parenright' => '600',      # U+0029
        'partialdiff' => '600',     # U+2202
        'percent' => '600',         # U+0025
        'period' => '600',          # U+002E
        'periodcentered' => '600',  # U+00B7
        'perthousand' => '600',     # U+2030
        'plus' => '600',            # U+002B
        'plusminus' => '600',       # U+00B1
        'Q' => '600',               # U+0051
        'q' => '600',               # U+0071
        'question' => '600',        # U+003F
        'questiondown' => '600',    # U+00BF
        'quotedbl' => '600',        # U+0022
        'quotedblbase' => '600',    # U+201E
        'quotedblleft' => '600',    # U+201C
        'quotedblright' => '600',   # U+201D
        'quoteleft' => '600',       # U+2018
        'quoteright' => '600',      # U+2019
        'quotesinglbase' => '600',  # U+201A
        'quotesingle' => '600',     # U+0027
        'R' => '600',               # U+0052
        'r' => '600',               # U+0072
        'Racute' => '600',          # U+0154
        'racute' => '600',          # U+0155
        'radical' => '600',         # U+221A
        'Rcaron' => '600',          # U+0158
        'rcaron' => '600',          # U+0159
        'Rcommaaccent' => '600',    # U+0156
        'rcommaaccent' => '600',    # U+0157
        'registered' => '600',      # U+00AE
        'ring' => '600',            # U+02DA
        'S' => '600',               # U+0053
        's' => '600',               # U+0073
        'Sacute' => '600',          # U+015A
        'sacute' => '600',          # U+015B
        'Scaron' => '600',          # U+0160
        'scaron' => '600',          # U+0161
        'Scedilla' => '600',        # U+015E
        'scedilla' => '600',        # U+015F
        'Scommaaccent' => '600',    # U+0218
        'scommaaccent' => '600',    # U+0219
        'section' => '600',         # U+00A7
        'semicolon' => '600',       # U+003B
        'seven' => '600',           # U+0037
        'six' => '600',             # U+0036
        'slash' => '600',           # U+002F
        'space' => '600',           # U+0020
        'sterling' => '600',        # U+00A3
        'summation' => '600',       # U+2211
        'T' => '600',               # U+0054
        't' => '600',               # U+0074
        'Tcaron' => '600',          # U+0164
        'tcaron' => '600',          # U+0165
        'Tcommaaccent' => '600',    # U+021A
        'tcommaaccent' => '600',    # U+021B
        'Thorn' => '600',           # U+00DE
        'thorn' => '600',           # U+00FE
        'three' => '600',           # U+0033
        'threequarters' => '600',   # U+00BE
        'threesuperior' => '600',   # U+00B3
        'tilde' => '600',           # U+02DC
        'trademark' => '600',       # U+2122
        'two' => '600',             # U+0032
        'twosuperior' => '600',     # U+00B2
        'U' => '600',               # U+0055
        'u' => '600',               # U+0075
        'Uacute' => '600',          # U+00DA
        'uacute' => '600',          # U+00FA
        'Ucircumflex' => '600',     # U+00DB
        'ucircumflex' => '600',     # U+00FB
        'Udieresis' => '600',       # U+00DC
        'udieresis' => '600',       # U+00FC
        'Ugrave' => '600',          # U+00D9
        'ugrave' => '600',          # U+00F9
        'Uhungarumlaut' => '600',   # U+0170
        'uhungarumlaut' => '600',   # U+0171
        'Umacron' => '600',         # U+016A
        'umacron' => '600',         # U+016B
        'underscore' => '600',      # U+005F
        'Uogonek' => '600',         # U+0172
        'uogonek' => '600',         # U+0173
        'Uring' => '600',           # U+016E
        'uring' => '600',           # U+016F
        'V' => '600',               # U+0056
        'v' => '600',               # U+0076
        'W' => '600',               # U+0057
        'w' => '600',               # U+0077
        'X' => '600',               # U+0058
        'x' => '600',               # U+0078
        'Y' => '600',               # U+0059
        'y' => '600',               # U+0079
        'Yacute' => '600',          # U+00DD
        'yacute' => '600',          # U+00FD
        'Ydieresis' => '600',       # U+0178
        'ydieresis' => '600',       # U+00FF
        'yen' => '600',             # U+00A5
        'Z' => '600',               # U+005A
        'z' => '600',               # U+007A
        'Zacute' => '600',          # U+0179
        'zacute' => '600',          # U+017A
        'Zcaron' => '600',          # U+017D
        'zcaron' => '600',          # U+017E
        'Zdotaccent' => '600',      # U+017B
        'zdotaccent' => '600',      # U+017C
        'zero' => '600',            # U+0030
    },
    'comps' => {
        'Abreve' => [ 'A', '0', '0', 'breve', '0', '130' ],               # U+0102
        'abreve' => [ 'A', '0', '0', 'breve', '0', '0' ],                 # U+0103
        'Acaron' => [ 'A', '0', '0', 'caron', '0', '130' ],               # U+01CD
        'acaron' => [ 'A', '0', '0', 'caron', '0', '0' ],                 # U+01CE
        'Amacron' => [ 'A', '0', '0', 'macron', '0', '130' ],             # U+0100
        'amacron' => [ 'A', '0', '0', 'macron', '0', '0' ],               # U+0101
        'Aogonek' => [ 'A', '0', '0', 'ogonek', '0', '0' ],               # U+0104
        'aogonek' => [ 'A', '0', '0', 'ogonek', '0', '0' ],               # U+0105
        'Bdotaccent' => [ 'B', '0', '0', 'dotaccent', '0', '130' ],       # U+1E02
        'bdotaccent' => [ 'B', '0', '0', 'dotaccent', '0', '0' ],         # U+1E03
        'Cacute' => [ 'C', '0', '0', 'acute', '0', '130' ],               # U+0106
        'cacute' => [ 'C', '0', '0', 'acute', '0', '0' ],                 # U+0107
        'Ccaron' => [ 'C', '0', '0', 'caron', '0', '130' ],               # U+010C
        'ccaron' => [ 'C', '0', '0', 'caron', '0', '0' ],                 # U+010D
        'Ccircumflex' => [ 'C', '0', '0', 'circumflex', '0', '130' ],     # U+0108
        'ccircumflex' => [ 'C', '0', '0', 'circumflex', '0', '0' ],       # U+0109
        'Cdotaccent' => [ 'C', '0', '0', 'dotaccent', '0', '130' ],       # U+010A
        'cdotaccent' => [ 'C', '0', '0', 'dotaccent', '0', '0' ],         # U+010B
        'Dcaron' => [ 'D', '0', '0', 'caron', '0', '130' ],               # U+010E
        'dcaron' => [ 'D', '0', '0', 'caron', '0', '0' ],                 # U+010F
        'Dcedilla' => [ 'D', '0', '0', 'cedilla', '0', '130' ],           # U+1E10
        'dcedilla' => [ 'D', '0', '0', 'cedilla', '0', '0' ],             # U+1E11
        'Ddotaccent' => [ 'D', '0', '0', 'dotaccent', '0', '130' ],       # U+1E0A
        'ddotaccent' => [ 'D', '0', '0', 'dotaccent', '0', '0' ],         # U+1E0B
        'Ebreve' => [ 'E', '0', '0', 'breve', '0', '130' ],               # U+0114
        'ebreve' => [ 'E', '0', '0', 'breve', '0', '0' ],                 # U+0115
        'Ecaron' => [ 'E', '0', '0', 'caron', '0', '130' ],               # U+011A
        'ecaron' => [ 'E', '0', '0', 'caron', '0', '0' ],                 # U+011B
        'Edotaccent' => [ 'E', '0', '0', 'dotaccent', '0', '130' ],       # U+0116
        'edotaccent' => [ 'E', '0', '0', 'dotaccent', '0', '0' ],         # U+0117
        'Emacron' => [ 'E', '0', '0', 'macron', '0', '130' ],             # U+0112
        'emacron' => [ 'E', '0', '0', 'macron', '0', '0' ],               # U+0113
        'Eogonek' => [ 'E', '0', '0', 'ogonek', '0', '0' ],               # U+0118
        'eogonek' => [ 'E', '0', '0', 'ogonek', '0', '0' ],               # U+0119
        'Etilde' => [ 'E', '0', '0', 'tilde', '0', '130' ],               # U+1EBC
        'etilde' => [ 'E', '0', '0', 'tilde', '0', '0' ],                 # U+1EBD
        'Fdotaccent' => [ 'F', '0', '0', 'dotaccent', '0', '130' ],       # U+1E1E
        'fdotaccent' => [ 'F', '0', '0', 'dotaccent', '0', '0' ],         # U+1E1F
        'Gacute' => [ 'G', '0', '0', 'acute', '0', '130' ],               # U+01F4
        'gacute' => [ 'G', '0', '0', 'acute', '0', '0' ],                 # U+01F5
        'Gbreve' => [ 'G', '0', '0', 'breve', '0', '130' ],               # U+011E
        'gbreve' => [ 'G', '0', '0', 'breve', '0', '0' ],                 # U+011F
        'Gcaron' => [ 'G', '0', '0', 'caron', '0', '136' ],               # U+01E6
        'gcaron' => [ 'g', '0', '0', 'caron', '-30', '0' ],               # U+01E7
        'Gcedilla' => [ 'G', '0', '0', 'cedilla', '0', '130' ],           # U+0122
        'gcedilla' => [ 'G', '0', '0', 'cedilla', '0', '0' ],             # U+0123
        'Gcircumflex' => [ 'G', '0', '0', 'circumflex', '0', '130' ],     # U+011C
        'gcircumflex' => [ 'G', '0', '0', 'circumflex', '0', '0' ],       # U+011D
        'Gdotaccent' => [ 'G', '0', '0', 'dotaccent', '0', '130' ],       # U+0120
        'gdotaccent' => [ 'G', '0', '0', 'dotaccent', '0', '0' ],         # U+0121
        'Gmacron' => [ 'G', '0', '0', 'macron', '0', '130' ],             # U+1E20
        'gmacron' => [ 'G', '0', '0', 'macron', '0', '0' ],               # U+1E21
        'Hcedilla' => [ 'H', '0', '0', 'cedilla', '0', '130' ],           # U+1E28
        'hcedilla' => [ 'H', '0', '0', 'cedilla', '0', '0' ],             # U+1E29
        'Hcircumflex' => [ 'H', '0', '0', 'circumflex', '0', '130' ],     # U+0124
        'hcircumflex' => [ 'H', '0', '0', 'circumflex', '0', '0' ],       # U+0125
        'Hdieresis' => [ 'H', '0', '0', 'dieresis', '0', '130' ],         # U+1E26
        'hdieresis' => [ 'H', '0', '0', 'dieresis', '0', '0' ],           # U+1E27
        'Hdotaccent' => [ 'H', '0', '0', 'dotaccent', '0', '130' ],       # U+1E22
        'hdotaccent' => [ 'H', '0', '0', 'dotaccent', '0', '0' ],         # U+1E23
        'Ibreve' => [ 'I', '0', '0', 'breve', '0', '130' ],               # U+012C
        'ibreve' => [ 'I', '0', '0', 'breve', '0', '0' ],                 # U+012D
        'Icaron' => [ 'I', '0', '0', 'caron', '0', '130' ],               # U+01CF
        'icaron' => [ 'I', '0', '0', 'caron', '0', '0' ],                 # U+01D0
        'Idotaccent' => [ 'I', '0', '0', 'dotaccent', '0', '130' ],       # U+0130
        'Imacron' => [ 'I', '0', '0', 'macron', '0', '130' ],             # U+012A
        'imacron' => [ 'I', '0', '0', 'macron', '0', '0' ],               # U+012B
        'Iogonek' => [ 'I', '0', '0', 'ogonek', '0', '0' ],               # U+012E
        'iogonek' => [ 'I', '0', '0', 'ogonek', '0', '0' ],               # U+012F
        'Itilde' => [ 'I', '0', '0', 'tilde', '0', '130' ],               # U+0128
        'itilde' => [ 'I', '0', '0', 'tilde', '0', '0' ],                 # U+0129
        'Jcircumflex' => [ 'J', '0', '0', 'circumflex', '0', '130' ],     # U+0134
        'jcircumflex' => [ 'J', '0', '0', 'circumflex', '0', '0' ],       # U+0135
        'Kacute' => [ 'K', '0', '0', 'acute', '0', '130' ],               # U+1E30
        'kacute' => [ 'K', '0', '0', 'acute', '0', '0' ],                 # U+1E31
        'Kcaron' => [ 'K', '0', '0', 'caron', '0', '130' ],               # U+01E8
        'kcaron' => [ 'K', '0', '0', 'caron', '0', '0' ],                 # U+01E9
        'Kcedilla' => [ 'K', '0', '0', 'cedilla', '0', '130' ],           # U+0136
        'kcedilla' => [ 'K', '0', '0', 'cedilla', '0', '0' ],             # U+0137
        'Lacute' => [ 'L', '0', '0', 'acute', '0', '130' ],               # U+0139
        'lacute' => [ 'L', '0', '0', 'acute', '0', '0' ],                 # U+013A
        'Lcaron' => [ 'L', '0', '0', 'caron', '0', '130' ],               # U+013D
        'lcaron' => [ 'L', '0', '0', 'caron', '0', '0' ],                 # U+013E
        'Lcedilla' => [ 'L', '0', '0', 'cedilla', '0', '130' ],           # U+013B
        'lcedilla' => [ 'L', '0', '0', 'cedilla', '0', '0' ],             # U+013C
        'Ldotaccent' => [ 'L', '0', '0', 'dotaccent', '0', '130' ],       # U+013F
        'ldotaccent' => [ 'L', '0', '0', 'dotaccent', '0', '0' ],         # U+0140
        'Macute' => [ 'M', '0', '0', 'acute', '0', '130' ],               # U+1E3E
        'macute' => [ 'M', '0', '0', 'acute', '0', '0' ],                 # U+1E3F
        'Mdotaccent' => [ 'M', '0', '0', 'dotaccent', '0', '130' ],       # U+1E40
        'mdotaccent' => [ 'M', '0', '0', 'dotaccent', '0', '0' ],         # U+1E41
        'Nacute' => [ 'N', '0', '0', 'acute', '0', '130' ],               # U+0143
        'nacute' => [ 'N', '0', '0', 'acute', '0', '0' ],                 # U+0144
        'Ncaron' => [ 'N', '0', '0', 'caron', '0', '130' ],               # U+0147
        'ncaron' => [ 'N', '0', '0', 'caron', '0', '0' ],                 # U+0148
        'Ncedilla' => [ 'N', '0', '0', 'cedilla', '0', '130' ],           # U+0145
        'ncedilla' => [ 'N', '0', '0', 'cedilla', '0', '0' ],             # U+0146
        'Ndotaccent' => [ 'N', '0', '0', 'dotaccent', '0', '130' ],       # U+1E44
        'ndotaccent' => [ 'N', '0', '0', 'dotaccent', '0', '0' ],         # U+1E45
        'Obreve' => [ 'O', '0', '0', 'breve', '0', '130' ],               # U+014E
        'obreve' => [ 'O', '0', '0', 'breve', '0', '0' ],                 # U+014F
        'Ocaron' => [ 'O', '0', '0', 'caron', '0', '130' ],               # U+01D1
        'ocaron' => [ 'O', '0', '0', 'caron', '0', '0' ],                 # U+01D2
        'Ohungarumlaut' => [ 'O', '0', '0', 'hungarumlaut', '0', '130' ], # U+0150
        'ohungarumlaut' => [ 'O', '0', '0', 'hungarumlaut', '0', '0' ],   # U+0151
        'Omacron' => [ 'O', '0', '0', 'macron', '0', '130' ],             # U+014C
        'omacron' => [ 'O', '0', '0', 'macron', '0', '0' ],               # U+014D
        'Oogonek' => [ 'O', '0', '0', 'ogonek', '0', '0' ],               # U+01EA
        'oogonek' => [ 'O', '0', '0', 'ogonek', '0', '0' ],               # U+01EB
        'Pacute' => [ 'P', '0', '0', 'acute', '0', '130' ],               # U+1E54
        'pacute' => [ 'P', '0', '0', 'acute', '0', '0' ],                 # U+1E55
        'Pdotaccent' => [ 'P', '0', '0', 'dotaccent', '0', '130' ],       # U+1E56
        'pdotaccent' => [ 'P', '0', '0', 'dotaccent', '0', '0' ],         # U+1E57
        'Racute' => [ 'R', '0', '0', 'acute', '0', '130' ],               # U+0154
        'racute' => [ 'R', '0', '0', 'acute', '0', '0' ],                 # U+0155
        'Rcaron' => [ 'R', '0', '0', 'caron', '0', '130' ],               # U+0158
        'rcaron' => [ 'R', '0', '0', 'caron', '0', '0' ],                 # U+0159
        'Rcedilla' => [ 'R', '0', '0', 'cedilla', '0', '130' ],           # U+0156
        'rcedilla' => [ 'R', '0', '0', 'cedilla', '0', '0' ],             # U+0157
        'Rdotaccent' => [ 'R', '0', '0', 'dotaccent', '0', '130' ],       # U+1E58
        'rdotaccent' => [ 'R', '0', '0', 'dotaccent', '0', '0' ],         # U+1E59
        'Sacute' => [ 'S', '0', '0', 'acute', '0', '130' ],               # U+015A
        'sacute' => [ 'S', '0', '0', 'acute', '0', '0' ],                 # U+015B
        'Scaron' => [ 'S', '0', '0', 'caron', '30', '136' ],              # U+0160
        'scaron' => [ 's', '0', '0', 'caron', '0', '0' ],                 # U+0161
        'Scedilla' => [ 'S', '0', '0', 'cedilla', '0', '130' ],           # U+015E
        'scedilla' => [ 'S', '0', '0', 'cedilla', '0', '0' ],             # U+015F
        'Scircumflex' => [ 'S', '0', '0', 'circumflex', '0', '130' ],     # U+015C
        'scircumflex' => [ 'S', '0', '0', 'circumflex', '0', '0' ],       # U+015D
        'Sdotaccent' => [ 'S', '0', '0', 'dotaccent', '0', '130' ],       # U+1E60
        'sdotaccent' => [ 'S', '0', '0', 'dotaccent', '0', '0' ],         # U+1E61
        'Tcaron' => [ 'T', '0', '0', 'caron', '0', '130' ],               # U+0164
        'tcaron' => [ 'T', '0', '0', 'caron', '0', '0' ],                 # U+0165
        'Tcedilla' => [ 'T', '0', '0', 'cedilla', '0', '130' ],           # U+0162
        'tcedilla' => [ 'T', '0', '0', 'cedilla', '0', '0' ],             # U+0163
        'Tdotaccent' => [ 'T', '0', '0', 'dotaccent', '0', '130' ],       # U+1E6A
        'tdotaccent' => [ 'T', '0', '0', 'dotaccent', '0', '0' ],         # U+1E6B
        'Ubreve' => [ 'U', '0', '0', 'breve', '0', '130' ],               # U+016C
        'ubreve' => [ 'U', '0', '0', 'breve', '0', '0' ],                 # U+016D
        'Ucaron' => [ 'U', '0', '0', 'caron', '0', '130' ],               # U+01D3
        'ucaron' => [ 'U', '0', '0', 'caron', '0', '0' ],                 # U+01D4
        'Uhungarumlaut' => [ 'U', '0', '0', 'hungarumlaut', '0', '130' ], # U+0170
        'uhungarumlaut' => [ 'U', '0', '0', 'hungarumlaut', '0', '0' ],   # U+0171
        'Umacron' => [ 'U', '0', '0', 'macron', '0', '130' ],             # U+016A
        'umacron' => [ 'U', '0', '0', 'macron', '0', '0' ],               # U+016B
        'Uogonek' => [ 'U', '0', '0', 'ogonek', '0', '0' ],               # U+0172
        'uogonek' => [ 'U', '0', '0', 'ogonek', '0', '0' ],               # U+0173
        'Uring' => [ 'U', '0', '0', 'ring', '0', '130' ],                 # U+016E
        'uring' => [ 'U', '0', '0', 'ring', '0', '0' ],                   # U+016F
        'Utilde' => [ 'U', '0', '0', 'tilde', '0', '130' ],               # U+0168
        'utilde' => [ 'U', '0', '0', 'tilde', '0', '0' ],                 # U+0169
        'Vtilde' => [ 'V', '0', '0', 'tilde', '0', '130' ],               # U+1E7C
        'vtilde' => [ 'V', '0', '0', 'tilde', '0', '0' ],                 # U+1E7D
        'Wacute' => [ 'W', '0', '0', 'acute', '0', '130' ],               # U+1E82
        'wacute' => [ 'W', '0', '0', 'acute', '0', '0' ],                 # U+1E83
        'Wcircumflex' => [ 'W', '0', '0', 'circumflex', '0', '130' ],     # U+0174
        'wcircumflex' => [ 'W', '0', '0', 'circumflex', '0', '0' ],       # U+0175
        'Wdieresis' => [ 'W', '0', '0', 'dieresis', '0', '130' ],         # U+1E84
        'wdieresis' => [ 'W', '0', '0', 'dieresis', '0', '0' ],           # U+1E85
        'Wdotaccent' => [ 'W', '0', '0', 'dotaccent', '0', '130' ],       # U+1E86
        'wdotaccent' => [ 'W', '0', '0', 'dotaccent', '0', '0' ],         # U+1E87
        'Wgrave' => [ 'W', '0', '0', 'grave', '0', '130' ],               # U+1E80
        'wgrave' => [ 'W', '0', '0', 'grave', '0', '0' ],                 # U+1E81
        'Xdieresis' => [ 'X', '0', '0', 'dieresis', '0', '130' ],         # U+1E8C
        'xdieresis' => [ 'X', '0', '0', 'dieresis', '0', '0' ],           # U+1E8D
        'Xdotaccent' => [ 'X', '0', '0', 'dotaccent', '0', '130' ],       # U+1E8A
        'xdotaccent' => [ 'X', '0', '0', 'dotaccent', '0', '0' ],         # U+1E8B
        'Ycircumflex' => [ 'Y', '0', '0', 'circumflex', '0', '130' ],     # U+0176
        'ycircumflex' => [ 'Y', '0', '0', 'circumflex', '0', '0' ],       # U+0177
        'Ydieresis' => [ 'Y', '0', '0', 'dieresis', '0', '136' ],         # U+0178
        'Ydotaccent' => [ 'Y', '0', '0', 'dotaccent', '0', '130' ],       # U+1E8E
        'ydotaccent' => [ 'Y', '0', '0', 'dotaccent', '0', '0' ],         # U+1E8F
        'Ygrave' => [ 'Y', '0', '0', 'grave', '0', '130' ],               # U+1EF2
        'ygrave' => [ 'Y', '0', '0', 'grave', '0', '0' ],                 # U+1EF3
        'Ytilde' => [ 'Y', '0', '0', 'tilde', '0', '130' ],               # U+1EF8
        'ytilde' => [ 'Y', '0', '0', 'tilde', '0', '0' ],                 # U+1EF9
        'Zacute' => [ 'Z', '0', '0', 'acute', '0', '130' ],               # U+0179
        'zacute' => [ 'Z', '0', '0', 'acute', '0', '0' ],                 # U+017A
        'Zcaron' => [ 'Z', '0', '0', 'caron', '0', '136' ],               # U+017D
        'zcaron' => [ 'z', '0', '0', 'caron', '10', '0' ],                # U+017E
        'Zcircumflex' => [ 'Z', '0', '0', 'circumflex', '0', '130' ],     # U+1E90
        'zcircumflex' => [ 'Z', '0', '0', 'circumflex', '0', '0' ],       # U+1E91
        'Zdotaccent' => [ 'Z', '0', '0', 'dotaccent', '0', '130' ],       # U+017B
        'zdotaccent' => [ 'Z', '0', '0', 'dotaccent', '0', '0' ],         # U+017C
    },
} };

1;
