//start of BitOutputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * BitOutputStream.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces
import java.io.OutputStream;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;


/**
 * ڑꂽo̓Xg[Ƀrbgf[^o͂邽߂
 * o̓Xg[NXB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: BitOutputStream.java,v $
 * Revision 1.1  2002/12/05 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/09/11 00:00:00  dangan
 * add to version control
 * [change]
 *     close()  writen\bh flush() 
 *     O𓊂悤ɏC
 * [maintenance]
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class BitOutputStream extends OutputStream{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  default
    //------------------------------------------------------------------
    //  private static final int DefaultCacheSize
    //------------------------------------------------------------------
    /**
     * ftHgLbVTCY
     */
    private static final int DefaultCacheSize = 1024;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private OutputStream out
    //------------------------------------------------------------------
    /**
     * ڑꂽo̓Xg[
     */
    private OutputStream out;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  cache
    //------------------------------------------------------------------
    //  private byte[] cache
    //  private int    cachePosition
    //------------------------------------------------------------------
    /**
     * xቺ}~poCgz
     */
    private byte[] cache;

    /**
     * cacheBuffer ̌ݏʒu
     */
    private int    cachePosition;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  bit buffer
    //------------------------------------------------------------------
    //  private int bitBuffer
    //  private int bitCount
    //------------------------------------------------------------------
    /**
     * rbgobt@
     */
    private int bitBuffer;

    /**
     * bitBuffer  Lrbg
     */
    private int bitCount;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private BitOutputStream()
    //  public BitOutputStream( OutputStream out )
    //  public BitOutputStream( OutputStream out, int CacheSize )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private BitOutputStream(){  }

    /**
     * o̓Xg[ out  f[^rbgPʂ
     * ߂悤ȃXg[\zB<br>
     * LbVTCYɂ̓ftHglgpB
     * 
     * @param out o̓Xg[
     */
    public BitOutputStream( OutputStream out ){
        this( out, BitOutputStream.DefaultCacheSize );

    }

    /**
     * o̓Xg[ out  f[^rbgPʂ
     * ߂悤ȃXg[\zB<br>
     * 
     * @param out       o̓Xg[
     * @param CacheSize LbVTCY
     * 
     * @exception IllegalArgumentException
     *                   CacheSize  4̏ꍇA܂
     *                   CacheSize  4̔{ŖꍇB
     */
    public BitOutputStream( OutputStream out, int CacheSize ){
        if( out != null && 4 <= CacheSize && 0 == ( CacheSize & 0x03 ) ){
            this.out            = out;
            this.cache          = new byte[ CacheSize ];
            this.cachePosition  = 0;
            this.bitBuffer      = 0;
            this.bitCount       = 0;
        }else if( out == null ){
            throw new NullPointerException( "out" );
        }else if( CacheSize < 4 ){
            throw new IllegalArgumentException( "CacheSize must be 4 or more." );
        }else{
            throw new IllegalArgumentException( "CacheSize must be multiple of 4." );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void write( int data )
    //  public void write( byte[] buffer )
    //  public void write( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * ڑꂽo̓Xg[ 8rbg̃f[^o͂B<br>
     * 
     * @param data 8rbg̃f[^B<br>
     *             24rbg͖B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( int data ) throws IOException {
        this.writeBits( 8, data );
    }

    /**
     * ڑꂽo̓Xg[buffer̓eA
     * 8rbg̃f[^Ƃďo͂B<br>
     * 
     * @param buffer oׂ͂f[^i[oCgz<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( byte[] buffer ) throws IOException {
        this.write( buffer, 0, buffer.length );                                 //throws IOException
    }

    /**
     * ڑꂽo̓Xg[bufferindex
     * lengthoCg̓eA 8rbg̃f[^
     * Ƃďo͂B<br>
     * 
     * @param buffer oׂ͂f[^i[oCgz
     * @param index  buffer̃f[^Jnʒu
     * @param length o͂f[^(oCg)
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void write( byte[] buffer, int index, int length )
                                                           throws IOException {
        if( this.bitCount % 8 == 0 ){
            this.flush();                                                       //throws IOException
            this.out.write( buffer, index, length );                            //throws IOException
        }else{
            while( 0 < length-- )
                this.writeBits( 8, buffer[index++] );                           //throws IOException
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.OutputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ̃rbgo̓Xg[Ƀobt@OĂ
     * 8rbgPʂ̃f[^Sďo͐ɏo͂B
     * 8rbgɖȂf[^͏o͂ȂƂɒӁB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void flush() throws IOException {
        while( 8 <= this.bitCount ){
            this.cache[ this.cachePosition++ ] = (byte)( this.bitBuffer >> 24 );
            this.bitBuffer <<= 8;
            this.bitCount  -= 8;
        }

        this.out.write( this.cache, 0, this.cachePosition );                    //throws IOException
        this.cachePosition = 0;
        this.out.flush();                                                       //throws IOException
    }

    /**
     * ̏o̓Xg[ƁAڑꂽo̓Xg[A
     * gpĂ\[XJB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        while( 0 < this.bitCount ){
            this.cache[ this.cachePosition++ ] = (byte)( this.bitBuffer >> 24 );
            this.bitBuffer <<= 8;
            this.bitCount  -= 8;
        }

        this.out.write( this.cache, 0, this.cachePosition );                    //throws IOException
        this.cachePosition = 0;
        this.out.flush();                                                       //throws IOException
        this.out.close();                                                       //throws IOException

        this.out            = null;
        this.cache          = null;
        this.cachePosition  = 0;
        this.bitCount       = 128;
        this.bitBuffer      = 0;
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  bit write
    //------------------------------------------------------------------
    //  public void writeBit( int data )
    //  public void writeBoolean( boolean bool )
    //  public void writeBits( int count, int data )
    //------------------------------------------------------------------
    /**
     * ڑꂽo̓Xg[1rbg̃f[^o͂B<br>
     * 
     * @param data 1rbg̃f[^B<br>
     *             31rbg͖B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeBit( int data ) throws IOException {
        this.bitBuffer |= ( data & 0x00000001 ) << 31 - this.bitCount;
        this.bitCount++;

        if( 32 <= this.bitCount ) this.writeOutBitBuffer();                        //throws IOException
    }

    /**
     * ^Ulڑꂽo̓Xg[1rbg
     * f[^Ƃďo͂B<br>
     * true  1Afalse  0Ƃďo͂B<br>
     * java.io.DataOutput  writeBoolean() Ƃ
     * ݊̂Œӂ邱ƁB<br>
     * 
     * @param bool ^Ul
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeBoolean( boolean bool ) throws IOException {
        if( bool )  this.bitBuffer |= 1 << 31 - this.bitCount;

        this.bitCount++;

        if( 32 <= this.bitCount ) this.writeOutBitBuffer();                     //throws IOException
    }

    /**
     * ڑꂽo̓Xg[Ƀrbgf[^o͂B<br>
     * 
     * @param count data ̗Lrbg
     * @param data  rbgf[^
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeBits( int count, int data ) throws IOException {
        while( 0 < count ){
            int available = 32 - this.bitCount;
            if( count < available ){
                this.bitBuffer   |= ( data & ( 0xFFFFFFFF >>> 32 - count ) )
                                                          << available - count;
                this.bitCount    += count;
                count            = 0;
            }else{
                count          -= available;
                this.bitBuffer |= data >> count
                                & ( 0xFFFFFFFF >>> 32 - available );
                this.writeOutBitBuffer();
            }
        }
    }

    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private void writeOutBitBuffer()
    //------------------------------------------------------------------
    /**
     * rbgobt@ɒ~ꂽf[^SăLbV
     * o͂ALbVꍇ̓LbṼf[^
     * ڑꂽo̓Xg[ɏo͂B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeOutBitBuffer() throws IOException {
        this.cache[ this.cachePosition++ ] = (byte)( this.bitBuffer >> 24 );
        this.cache[ this.cachePosition++ ] = (byte)( this.bitBuffer >> 16 );
        this.cache[ this.cachePosition++ ] = (byte)( this.bitBuffer >>  8 );
        this.cache[ this.cachePosition++ ] = (byte)this.bitBuffer;

        this.bitBuffer = 0;
        this.bitCount  = 0;

        if( this.cache.length <= this.cachePosition ){
            this.out.write( this.cache );
            this.cachePosition = 0;
        }
    }

}
//end of BitOutputStream.java
