#!/usr/bin/env python

"""
Test periods.

Copyright (C) 2016 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from imiptools.dates import format_datetime
from imiptools.period import Period, get_overlapping

l1 = [
    Period("20160501T020000Z", "20160501T045000Z"),
    Period("20160501T023000Z", "20160501T030000Z"),
    Period("20160501T024500Z", "20160501T031500Z"),
    Period("20160501T040000Z", "20160501T043000Z"),
    Period("20160501T050000Z", "20160501T060000Z"),
    Period("20160501T051500Z", "20160501T054500Z"),
    Period("20160501T052000Z", "20160501T053000Z"),
    Period("20160501T090000Z", "20160501T093000Z"),
    Period("20160501T094000Z", "20160501T104000Z"),
    Period("20160501T100000Z", "20160501T110000Z"),
    ]

l2 = [
    Period("20160501T010000Z", "20160501T020000Z"),
    Period("20160501T013000Z", "20160501T014000Z"),
    Period("20160501T014000Z", "20160501T015000Z"),
    Period("20160501T020000Z", "20160501T033000Z"),
    Period("20160501T040000Z", "20160501T044000Z"),
    Period("20160501T050000Z", "20160501T051000Z"),
    Period("20160501T052000Z", "20160501T053000Z"),
    Period("20160501T085900Z", "20160501T090000Z"),
    Period("20160501T085900Z", "20160501T090100Z"),
    Period("20160501T100000Z", "20160501T110000Z"),
    ]

o1 = [
    Period("20160501T020000Z", "20160501T045000Z"),
    Period("20160501T023000Z", "20160501T030000Z"),
    Period("20160501T024500Z", "20160501T031500Z"),
    Period("20160501T040000Z", "20160501T043000Z"),
    Period("20160501T050000Z", "20160501T060000Z"),
    Period("20160501T051500Z", "20160501T054500Z"),
    Period("20160501T052000Z", "20160501T053000Z"),
    Period("20160501T090000Z", "20160501T093000Z"),
    Period("20160501T094000Z", "20160501T104000Z"),
    Period("20160501T100000Z", "20160501T110000Z"),
    ]

o2 = [
    Period("20160501T020000Z", "20160501T033000Z"),
    Period("20160501T040000Z", "20160501T044000Z"),
    Period("20160501T050000Z", "20160501T051000Z"),
    Period("20160501T052000Z", "20160501T053000Z"),
    Period("20160501T085900Z", "20160501T090100Z"),
    Period("20160501T100000Z", "20160501T110000Z"),
    ]

print o1 == get_overlapping(l1, l2)

for p in get_overlapping(l1, l2):
    print format_datetime(p.get_start_point()), format_datetime(p.get_end_point())

print "----"

print o2 == get_overlapping(l2, l1)

for p in get_overlapping(l2, l1):
    print format_datetime(p.get_start_point()), format_datetime(p.get_end_point())

print "----"

l1[0] = Period("20160501T020000Z", "20160501T120000Z")
o1[0] = l1[0]
print o1 == get_overlapping(l1, l2)

for p in get_overlapping(l1, l2):
    print format_datetime(p.get_start_point()), format_datetime(p.get_end_point())

print "----"

o2 = l2[3:]
print o2 == get_overlapping(l2, l1)

for p in get_overlapping(l2, l1):
    print format_datetime(p.get_start_point()), format_datetime(p.get_end_point())

# vim: tabstop=4 expandtab shiftwidth=4
